/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.GRPCUtils;
import org.languagetool.rules.RemoteRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.RemoteRuleMetrics;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ml.MLServerProto;
import org.languagetool.rules.ml.PostProcessingServerGrpc;
import org.languagetool.tools.CircuitBreakers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRPCPostProcessing {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GRPCPostProcessing.class);
    public static final String CONFIG_TYPE = "grpc-post";
    private final CircuitBreaker circuitBreaker;
    private ManagedChannel channel;
    private PostProcessingServerGrpc.PostProcessingServerBlockingStub stub;
    private RemoteRuleConfig config;
    private static ConcurrentMap<String, GRPCPostProcessing> instances = new ConcurrentHashMap<String, GRPCPostProcessing>();
    private static ConcurrentMap<Language, Set<String>> configIDs = new ConcurrentHashMap<Language, Set<String>>();

    protected GRPCPostProcessing(RemoteRuleConfig config) throws Exception {
        this.config = config;
        CircuitBreakerConfig circuitBreakerConfig = RemoteRule.getCircuitBreakerConfig(config, config.getRuleId());
        this.circuitBreaker = CircuitBreakers.registry().circuitBreaker("grpc-postprocessing-" + config.getRuleId(), circuitBreakerConfig);
        String host = config.getUrl();
        int port = config.getPort();
        boolean ssl = Boolean.parseBoolean(config.getOptions().getOrDefault("secure", "false"));
        String key = config.getOptions().get("clientKey");
        String cert = config.getOptions().get("clientCertificate");
        String ca = config.getOptions().get("rootCertificate");
        this.channel = GRPCRule.Connection.getManagedChannel(host, port, ssl, key, cert, ca);
        this.stub = PostProcessingServerGrpc.newBlockingStub((Channel)this.channel);
    }

    @NotNull
    public static List<GRPCPostProcessing> get(Language lang) {
        return configIDs.getOrDefault(lang, Collections.emptySet()).stream().map(instances::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void configure(Language lang, List<RemoteRuleConfig> configs) {
        configs.stream().filter(RemoteRuleConfig.isRelevantConfig(CONFIG_TYPE, lang)).forEach(config -> {
            String key = config.getRuleId();
            configIDs.computeIfAbsent(lang, k -> new HashSet()).add(key);
            instances.computeIfAbsent(key, k -> {
                try {
                    return new GRPCPostProcessing((RemoteRuleConfig)config);
                }
                catch (Exception e) {
                    log.warn(String.format("Couldn't initialize GRPCPostProcessing instance for language '%s' and configuration '%s'", lang, config), (Throwable)e);
                    return null;
                }
            });
        });
    }

    private MLServerProto.PostProcessingRequest buildRequest(List<AnalyzedSentence> sentences, List<RuleMatch> ruleMatches, List<Integer> offset, Long textSessionId, boolean inputLogging) {
        ruleMatches = ruleMatches.stream().map(r -> new RuleMatch((RuleMatch)r)).collect(Collectors.toList());
        ArrayList<MLServerProto.MatchList> matches = new ArrayList<MLServerProto.MatchList>();
        for (int i = 0; i < sentences.size(); ++i) {
            AnalyzedSentence sentence = sentences.get(i);
            if (i == 0) {
                offset.add(0);
            } else {
                offset.add(offset.get(i - 1) + sentences.get(i - 1).getText().length());
            }
            ArrayList<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
            Iterator<RuleMatch> iter = ruleMatches.iterator();
            while (iter.hasNext()) {
                RuleMatch m = iter.next();
                if (!sentence.getText().equals(m.getSentence().getText())) continue;
                iter.remove();
                m.setOffsetPosition(m.getFromPos() - offset.get(i), m.getToPos() - offset.get(i));
                sentenceMatches.add(m);
            }
            matches.add(MLServerProto.MatchList.newBuilder().addAllMatches(sentenceMatches.stream().map(GRPCUtils::toGRPC).collect(Collectors.toList())).build());
        }
        List<String> sentenceText = sentences.stream().map(AnalyzedSentence::getText).collect(Collectors.toList());
        MLServerProto.PostProcessingRequest.Builder req = MLServerProto.PostProcessingRequest.newBuilder().addAllSentences(sentenceText).addAllMatches(matches);
        if (textSessionId != null) {
            req.addAllTextSessionID(Collections.nCopies(sentenceText.size(), textSessionId));
        }
        req.setInputLogging(inputLogging);
        return req.build();
    }

    public List<RuleMatch> filter(List<AnalyzedSentence> sentences, List<RuleMatch> ruleMatches, Long textSessionID, boolean inputLogging) {
        List result;
        if (this.channel == null) {
            return ruleMatches;
        }
        int chars = sentences.stream().map(s -> s.getText().length()).reduce(0, Integer::sum);
        long start = System.nanoTime();
        try {
            result = this.circuitBreaker != null ? RemoteRuleMetrics.inCircuitBreaker(System.nanoTime(), this.circuitBreaker, this.config.ruleId, chars, () -> this.runPostprocessing(sentences, ruleMatches, textSessionID, inputLogging, chars)) : this.runPostprocessing(sentences, ruleMatches, textSessionID, inputLogging, chars);
        }
        catch (Exception e) {
            log.warn("gRPC postprocessing failed", (Throwable)e);
            return ruleMatches;
        }
        if (result == null) {
            return ruleMatches;
        }
        long delta = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
        log.info("gRPC postprocessing chars={} sentences={} matches={} time={}ms", new Object[]{chars, sentences.size(), ruleMatches.size(), delta});
        RemoteRuleMetrics.wait(this.config.getRuleId(), delta);
        RemoteRuleMetrics.request(this.config.getRuleId(), start, chars, RemoteRuleMetrics.RequestResult.SUCCESS);
        return result;
    }

    protected MLServerProto.MatchResponse sendRequest(MLServerProto.PostProcessingRequest req, long timeout) throws Exception {
        return ((PostProcessingServerGrpc.PostProcessingServerBlockingStub)this.stub.withDeadlineAfter(timeout, TimeUnit.MILLISECONDS)).process(req);
    }

    protected List<RuleMatch> runPostprocessing(List<AnalyzedSentence> sentences, List<RuleMatch> ruleMatches, Long textSessionID, boolean inputLogging, int chars) throws Exception {
        ArrayList<Integer> offset = new ArrayList<Integer>();
        long timeout = RemoteRule.getTimeout(this.config, chars);
        try {
            MLServerProto.PostProcessingRequest req = this.buildRequest(sentences, ruleMatches, offset, textSessionID, inputLogging);
            MLServerProto.MatchResponse response = this.sendRequest(req, timeout);
            ArrayList<RuleMatch> result = new ArrayList<RuleMatch>(response.getSentenceMatchesCount());
            for (int i = 0; i < response.getSentenceMatchesCount(); ++i) {
                MLServerProto.MatchList matchList = response.getSentenceMatches(i);
                AnalyzedSentence sentence = sentences.get(i);
                int offsetShift = (Integer)offset.get(i);
                for (int j = 0; j < matchList.getMatchesCount(); ++j) {
                    RuleMatch match = GRPCUtils.fromGRPC(matchList.getMatches(j), sentence);
                    match.setOffsetPosition(match.getFromPos() + offsetShift, match.getToPos() + offsetShift);
                    result.add(match);
                }
            }
            return result;
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode() == Status.DEADLINE_EXCEEDED.getCode()) {
                throw new TimeoutException("gRPC postprocessing timed out: " + e.getMessage());
            }
            throw e;
        }
    }
}

