/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.Configurator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ConfiguratorRegistry {
    private static ConfiguratorRegistry instance;
    @GuardedBy(value="this")
    private boolean wasConfiguratorsSet;
    @GuardedBy(value="this")
    private List<Configurator> configurators = Collections.emptyList();
    @GuardedBy(value="this")
    private int configuratorsCallCountBeforeSet = 0;

    ConfiguratorRegistry() {
    }

    public static synchronized ConfiguratorRegistry getDefaultRegistry() {
        if (instance == null) {
            instance = new ConfiguratorRegistry();
        }
        return instance;
    }

    public synchronized void setConfigurators(List<? extends Configurator> configurators) {
        if (this.wasConfiguratorsSet) {
            throw new IllegalStateException("Configurators are already set");
        }
        this.configurators = Collections.unmodifiableList(new ArrayList<Configurator>(configurators));
        this.wasConfiguratorsSet = true;
    }

    public synchronized List<Configurator> getConfigurators() {
        if (!this.wasConfiguratorsSet) {
            ++this.configuratorsCallCountBeforeSet;
        }
        return this.configurators;
    }

    public synchronized int getConfiguratorsCallCountBeforeSet() {
        return this.configuratorsCallCountBeforeSet;
    }

    public synchronized boolean wasSetConfiguratorsCalled() {
        return this.wasConfiguratorsSet;
    }
}

