/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.TaskAutoCompletionListProvider;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@VisibleForTesting
public final class TaskChangelistSupport
implements EditChangelistSupport {
    private final Project project;

    public TaskChangelistSupport(Project project) {
        this.project = project;
    }

    public void installSearch(@NotNull EditorTextField name, @NotNull EditorTextField comment) {
        if (name == null) {
            TaskChangelistSupport.$$$reportNull$$$0(0);
        }
        if (comment == null) {
            TaskChangelistSupport.$$$reportNull$$$0(1);
        }
        Document document = name.getDocument();
        TaskAutoCompletionListProvider completionProvider = new TaskAutoCompletionListProvider(this.project);
        TextFieldWithAutoCompletion.installCompletion((Document)document, (Project)this.project, (TextFieldWithAutoCompletionListProvider)completionProvider, (boolean)false);
    }

    @NotNull
    public @NotNull Consumer<@NotNull LocalChangeList> addControls(@NotNull JPanel bottomPanel, @Nullable LocalChangeList initial) {
        if (bottomPanel == null) {
            TaskChangelistSupport.$$$reportNull$$$0(2);
        }
        TaskManagerImpl taskManager = (TaskManagerImpl)TaskManager.getManager((Project)this.project);
        JCheckBox checkBox = new JCheckBox(TaskBundle.message((String)"switch.changelist.track.context.checkbox", (Object[])new Object[0]));
        checkBox.setToolTipText(TaskBundle.message((String)"switch.changelist.track.context.checkbox.tooltip", (Object[])new Object[0]));
        checkBox.setSelected(initial == null ? taskManager.getState().trackContextForNewChangelist : taskManager.getAssociatedTask(initial) != null);
        bottomPanel.add(checkBox);
        Consumer consumer = changeList -> {
            if (initial == null) {
                taskManager.getState().trackContextForNewChangelist = checkBox.isSelected();
                if (checkBox.isSelected()) {
                    taskManager.trackContext(changeList);
                } else {
                    taskManager.getActiveTask().addChangelist(new ChangeListInfo(changeList));
                }
            } else {
                LocalTask associatedTask = taskManager.getAssociatedTask(changeList);
                if (checkBox.isSelected()) {
                    if (associatedTask == null) {
                        taskManager.trackContext(changeList);
                    }
                } else if (associatedTask != null) {
                    taskManager.removeTask(associatedTask);
                }
            }
        };
        if (consumer == null) {
            TaskChangelistSupport.$$$reportNull$$$0(3);
        }
        return consumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/TaskChangelistSupport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/TaskChangelistSupport";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "addControls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installSearch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addControls";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

