/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JTable;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.cell.JTableCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.edt.GuiQuery;

final class JTableContentsQuery {
    @Nonnull
    @RunsInEDT
    static String[][] tableContents(final @Nonnull JTable table, final @Nonnull JTableCellReader cellReader) {
        String[][] result = GuiActionRunner.execute(new GuiQuery<String[][]>(){

            @Override
            @Nonnull
            protected String[][] executeInEDT() {
                int rCount = table.getRowCount();
                int cCount = table.getColumnCount();
                String[][] contents = new String[rCount][cCount];
                for (int r = 0; r < rCount; ++r) {
                    for (int c = 0; c < cCount; ++c) {
                        contents[r][c] = cellReader.valueAt(table, r, c);
                    }
                }
                return contents;
            }
        });
        return (String[][])Preconditions.checkNotNull((Object)result);
    }

    private JTableContentsQuery() {
    }
}

