/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.commands.OpenFileCommand;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ReloadFilesCommand
extends AbstractCallbackBasedCommand {
    @NonNls
    public static final String PREFIX = "%reloadFiles";

    public ReloadFilesCommand(@NotNull String text, int line) {
        if (text == null) {
            ReloadFilesCommand.$$$reportNull$$$0(0);
        }
        super(text, line, true);
    }

    public ReloadFilesCommand() {
        super("", 0);
    }

    public static void synchronizeFiles(List<String> filePaths) {
        ReloadFilesCommand.synchronizeFiles(filePaths, ProjectManager.getInstance().getOpenProjects()[0]);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        if (callback2 == null) {
            ReloadFilesCommand.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ReloadFilesCommand.$$$reportNull$$$0(2);
        }
        Project project = context.getProject();
        ReloadFilesCommand.synchronizeFiles(this.extractCommandList(PREFIX, " "), project);
        callback2.setDone();
    }

    private static void synchronizeFiles(List<String> filePaths, Project project) {
        VirtualFile[] files = (VirtualFile[])filePaths.stream().map(path -> {
            VirtualFile file = OpenFileCommand.findFile(path, project);
            if (file == null) {
                throw new IllegalArgumentException("File not found " + path);
            }
            return file;
        }).toArray(VirtualFile[]::new);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/performancePlugin/commands/ReloadFilesCommand";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

