/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractWyhashFinal;
import com.dynatrace.hash4j.hashing.HashUtil;
import com.dynatrace.hash4j.hashing.Hasher64;
import java.util.Objects;

final class WyhashFinal3
extends AbstractWyhashFinal {
    private static final Hasher64 DEFAULT_HASHER_INSTANCE = WyhashFinal3.create(0L);

    WyhashFinal3(long seedForHash, long[] secret) {
        super(seedForHash ^ secret[0], secret[1], secret[2], secret[3]);
    }

    @Override
    protected long finish(long a, long b, long seed, long len) {
        return HashUtil.mix(this.secret1 ^ len, HashUtil.mix(a ^ this.secret1, b ^ seed));
    }

    static Hasher64 create() {
        return DEFAULT_HASHER_INSTANCE;
    }

    static Hasher64 create(long seedForHash) {
        return new WyhashFinal3(seedForHash, DEFAULT_SECRET);
    }

    static Hasher64 create(long seedForHash, long seedForSecret) {
        return new WyhashFinal3(seedForHash, WyhashFinal3.makeSecret(seedForSecret));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WyhashFinal3)) {
            return false;
        }
        WyhashFinal3 that = (WyhashFinal3)obj;
        return this.seed == that.seed && this.secret1 == that.secret1 && this.secret2 == that.secret2 && this.secret3 == that.secret3;
    }

    public int hashCode() {
        return Objects.hash(this.seed, this.secret1, this.secret2, this.secret3);
    }
}

