/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.similarity;

import com.dynatrace.hash4j.internal.Preconditions;
import com.dynatrace.hash4j.random.PseudoRandomGenerator;
import com.dynatrace.hash4j.random.PseudoRandomGeneratorProvider;
import com.dynatrace.hash4j.similarity.AbstractSimilarityHashPolicy;
import com.dynatrace.hash4j.similarity.ElementHashProvider;
import com.dynatrace.hash4j.similarity.SimilarityHasher;
import java.util.Arrays;
import java.util.Objects;

final class MinHashPolicy_v1
extends AbstractSimilarityHashPolicy {
    public MinHashPolicy_v1(int numberOfComponents, int bitsPerComponent, PseudoRandomGeneratorProvider pseudoRandomGeneratorProvider) {
        super(numberOfComponents, bitsPerComponent, pseudoRandomGeneratorProvider);
    }

    @Override
    public SimilarityHasher createHasher() {
        return new Hasher();
    }

    private class Hasher
    implements SimilarityHasher {
        private final long[] work;
        private final PseudoRandomGenerator pseudoRandomGenerator;

        private Hasher() {
            this.work = new long[MinHashPolicy_v1.this.getNumberOfComponents()];
            this.pseudoRandomGenerator = MinHashPolicy_v1.this.pseudoRandomGeneratorProvider.create();
        }

        @Override
        public byte[] compute(ElementHashProvider elementHashProvider) {
            Objects.requireNonNull(elementHashProvider);
            int numberOfElements = elementHashProvider.getNumberOfElements();
            Preconditions.checkArgument(numberOfElements > 0, "Number of elements must be positive!");
            Arrays.fill(this.work, Long.MAX_VALUE);
            int numberOfComponents = MinHashPolicy_v1.this.getNumberOfComponents();
            for (int k = 0; k < numberOfElements; ++k) {
                this.pseudoRandomGenerator.reset(elementHashProvider.getElementHash(k));
                for (int i2 = 0; i2 < numberOfComponents; ++i2) {
                    long hash = this.pseudoRandomGenerator.nextLong();
                    if (hash >= this.work[i2]) continue;
                    this.work[i2] = hash;
                }
            }
            return MinHashPolicy_v1.this.packedArrayHandler.create(i -> this.work[i], numberOfComponents);
        }
    }
}

