/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.winp.CtrlCSender;
import org.jvnet.winp.WinpException;

class Native {
    private static final String SUFFIX = Native.getSuffix();
    public static final String DLL_NAME = "winp" + SUFFIX;
    public static final String CTRLCEXE_NAME = "sendctrlc" + SUFFIX;
    private static final Logger LOGGER = Logger.getLogger(Native.class.getName());
    private static final String DLL_TARGET = "winp.folder.preferred";
    private static final String UNPACK_DLL_TO_PARENT_DIR = "winp.unpack.dll.to.parent.dir";
    private static volatile String ctrlCExePath;
    private static volatile Throwable loadFailure;

    Native() {
    }

    private static String getSuffix() {
        String arch = System.getProperty("os.arch");
        if ("i386".equals(arch) || "x86".equals(arch)) {
            return "";
        }
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            return ".x64";
        }
        if ("aarch64".equals(arch) || "arm64".equals(arch)) {
            return ".arm64";
        }
        return "_" + arch;
    }

    static native boolean kill(int var0, boolean var1);

    static native boolean isCriticalProcess(int var0);

    static native boolean isProcessRunning(int var0);

    static native int setPriority(int var0, int var1);

    static native int getProcessId(long var0);

    static native boolean exitWindowsEx(int var0, int var1);

    static native String getCmdLineAndEnvVars(int var0);

    static native String getCmdLine(int var0) throws WinpException;

    static native int enumProcesses(int[] var0);

    static native void enableDebugPrivilege();

    static native void noop();

    @CheckReturnValue
    public static boolean sendCtrlC(int pid) throws WinpException {
        if (loadFailure != null) {
            throw new WinpException("Cannot send the CtrlC signal to the process: winp init failed", loadFailure);
        }
        if (ctrlCExePath == null) {
            LOGGER.log(Level.WARNING, "Cannot send the CtrlC signal to the process. Cannot find the executable {0}.dll", CTRLCEXE_NAME);
            return false;
        }
        return CtrlCSender.sendCtrlC(pid, ctrlCExePath);
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="TODO needs triage")
    private static String md5(URL res) {
        String string;
        block10: {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            InputStream in = res.openStream();
            try {
                int len;
                byte[] buf = new byte[8192];
                while ((len = in.read(buf)) >= 0) {
                    md5.update(buf, 0, len);
                }
                string = Native.toHex32(md5.digest());
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AssertionError((Object)e);
                }
                catch (IOException e) {
                    throw new Error("failed to checksum " + res + ": " + e, e);
                }
            }
            in.close();
        }
        return string;
    }

    private static File load() {
        URL dllRes = Native.class.getClassLoader().getResource(DLL_NAME + ".dll");
        try {
            if (dllRes != null) {
                URL exeRes = Native.class.getClassLoader().getResource(CTRLCEXE_NAME + ".exe");
                return Native.loadByUrl(dllRes, exeRes);
            }
            System.loadLibrary(DLL_NAME);
            return null;
        }
        catch (Throwable cause) {
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("Unable to load " + DLL_NAME + ".dll");
            error.initCause(cause);
            throw error;
        }
    }

    private static File loadByUrl(URL dllRes, URL exeRes) throws IOException {
        String dllUrl = dllRes.toExternalForm();
        if (dllUrl.startsWith("file:")) {
            File f;
            if (!exeRes.toExternalForm().startsWith("file:")) {
                LOGGER.log(Level.WARNING, "DLL and EXE are inconsistenly present on disk");
            }
            try {
                f = new File(dllRes.toURI());
            }
            catch (URISyntaxException e) {
                f = new File(dllRes.getPath());
            }
            Native.loadDll(f);
            File exeFile = new File(f.getParentFile(), CTRLCEXE_NAME + ".exe");
            return exeFile;
        }
        try {
            File dllFile = Native.extractToStaticLocation(dllRes);
            File exeFile = Native.extractExe(exeRes, dllFile.getParentFile());
            Native.loadDll(dllFile);
            return exeFile;
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to load DLL from static location", e);
            File dllFile = Native.extractToTmpLocation(dllRes);
            File exeFile = Native.extractExe(exeRes, dllFile.getParentFile());
            Native.loadDll(dllFile);
            return exeFile;
        }
    }

    private static File extractToStaticLocation(URL url) throws IOException {
        File jarFile = Native.getJarFile(url);
        if (jarFile == null) {
            throw new RuntimeException("Failed to locate JAR file by URL " + url);
        }
        String preferred = System.getProperty(DLL_TARGET);
        File destFile = new File(preferred != null ? new File(preferred) : jarFile.getParentFile(), DLL_NAME + "." + Native.md5(url) + ".dll");
        if (!destFile.exists()) {
            Native.copyStream(url.openStream(), new FileOutputStream(destFile));
        }
        return destFile;
    }

    private static File extractToTmpLocation(URL res) throws IOException {
        File tmpFile = File.createTempFile(DLL_NAME, ".dll");
        tmpFile.deleteOnExit();
        Native.copyStream(res.openStream(), new FileOutputStream(tmpFile));
        return tmpFile;
    }

    private static File extractExe(URL res, File dir) throws IOException {
        File destFile = new File(dir, CTRLCEXE_NAME + "." + Native.md5(res) + ".exe");
        if (!destFile.exists()) {
            Native.copyStream(res.openStream(), new FileOutputStream(destFile));
        }
        return destFile;
    }

    private static File getJarFile(URL res) {
        String url = res.toExternalForm();
        if (!(url.startsWith("jar:") || url.startsWith("wsjar:") || url.startsWith("zip:"))) {
            return null;
        }
        int idx = url.lastIndexOf(33);
        String filePortion = url.substring(url.indexOf(58) + 1, idx);
        while (filePortion.startsWith("/")) {
            filePortion = filePortion.substring(1);
        }
        if (filePortion.startsWith("file:")) {
            filePortion = filePortion.substring(5);
        }
        if (filePortion.startsWith("///")) {
            filePortion = filePortion.substring(2);
        }
        filePortion = URLDecoder.decode(filePortion);
        return new File(filePortion.replace('/', File.separatorChar));
    }

    @SuppressFBWarnings(value={"DM_GC"}, justification="Fallback in the case of linkage errors, see details in the code")
    private static void loadDll(File dllFile) {
        try {
            System.load(dllFile.getPath());
        }
        catch (LinkageError e) {
            for (int i = 0; i < 5; ++i) {
                try {
                    System.gc();
                    System.gc();
                    Thread.sleep(1000L);
                    System.load(dllFile.getPath());
                    return;
                }
                catch (InterruptedException x) {
                    throw e;
                }
                catch (LinkageError linkageError) {
                    continue;
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private static String toHex32(byte[] b) {
        return String.format("%032X", new BigInteger(1, b));
    }

    static {
        try {
            File exeFile = Native.load();
            ctrlCExePath = exeFile == null ? null : exeFile.getPath();
        }
        catch (Throwable t) {
            loadFailure = t;
            LOGGER.log(Level.SEVERE, "Cannot init winp native", t);
        }
    }
}

