/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.winp.Native;
import org.jvnet.winp.WinpException;

public class WinProcess {
    private final int pid;
    private String commandline;
    private TreeMap<String, String> envVars;
    private static final Logger LOGGER = Logger.getLogger(WinProcess.class.getName());

    public WinProcess(int pid) {
        this.pid = pid;
    }

    public WinProcess(Process proc) {
        long pidLong = proc.pid();
        this.pid = (int)pidLong;
        if ((long)this.pid != pidLong) {
            throw new IllegalArgumentException("Out of range: " + pidLong);
        }
    }

    public String toString() {
        return "WinProcess pid#" + this.pid + ", command line: " + (this.commandline != null ? this.commandline : "not ready");
    }

    public int getPid() {
        return this.pid;
    }

    public void killRecursively() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Attempting to recursively kill pid=%d (%s)", this.pid, this.getCommandLine()));
        }
        Native.kill(this.pid, true);
    }

    public void kill() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Attempting to kill pid=%d (%s)", this.pid, this.getCommandLine()));
        }
        Native.kill(this.pid, false);
    }

    @CheckReturnValue
    public boolean sendCtrlC() throws WinpException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Attempting to send CTRL+C to pid=%d (%s)", this.pid, this.getCommandLine()));
        }
        return Native.sendCtrlC(this.pid);
    }

    public boolean isRunning() {
        return Native.isProcessRunning(this.pid);
    }

    public boolean isCriticalProcess() {
        return Native.isCriticalProcess(this.pid);
    }

    public void setPriority(int priority) {
        Native.setPriority(this.pid, priority);
    }

    public synchronized String getCommandLine() {
        if (this.commandline == null) {
            this.parseCmdLine();
        }
        return this.commandline;
    }

    public synchronized TreeMap<String, String> getEnvironmentVariables() {
        if (this.envVars == null) {
            this.parseCmdLineAndEnvVars();
        }
        return this.envVars;
    }

    private void parseCmdLine() throws WinpException {
        String s = Native.getCmdLine(this.pid);
        if (s == null) {
            throw new WinpException("Failed to obtain command line for PID = " + this.pid);
        }
        this.commandline = s;
    }

    private void parseCmdLineAndEnvVars() {
        String s = Native.getCmdLineAndEnvVars(this.pid);
        if (s == null) {
            throw new WinpException("Failed to obtain for PID=" + this.pid);
        }
        int end = s.indexOf("\u0000\u0000");
        if (end != -1) {
            s = s.substring(0, end);
        }
        StringTokenizer st = new StringTokenizer(s, "\u0000", false);
        this.commandline = st.nextToken();
        this.envVars = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        while (st.hasMoreElements()) {
            String kv = st.nextToken();
            int sep = kv.indexOf(61);
            if (sep == -1) continue;
            this.envVars.put(kv.substring(0, sep), kv.substring(sep + 1));
        }
    }

    public static Iterable<WinProcess> all() {
        return new Iterable<WinProcess>(){

            @Override
            public Iterator<WinProcess> iterator() {
                return new Iterator<WinProcess>(){
                    private int pos = 0;
                    private int[] pids = new int[256];
                    private int total;
                    {
                        while (true) {
                            this.total = Native.enumProcesses(this.pids);
                            if (this.total == 0) {
                                throw new WinpException("Failed to enumerate processes");
                            }
                            if (this.total < this.pids.length) break;
                            this.pids = new int[this.pids.length * 2];
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < this.total;
                    }

                    @Override
                    public WinProcess next() {
                        return new WinProcess(this.pids[this.pos++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void enableDebugPrivilege() {
        Native.enableDebugPrivilege();
    }
}

