/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.parse.SchemaBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class NamespaceManager {
    private final Map requiredNamespaces = new HashMap();
    private static final String[] conventionalBindings = new String[]{"", SchemaBuilder.INHERIT_NS, "inherit", SchemaBuilder.INHERIT_NS, "", "", "local", "", "rng", "http://relaxng.org/ns/structure/1.0", "a", "http://relaxng.org/ns/compatibility/annotations/1.0"};
    private final Map bindingUsageMap = new HashMap();

    NamespaceManager() {
    }

    void requireNamespace(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.requiredNamespaces.get(string);
        if (bl2 == null || bl2.booleanValue() && !bl) {
            bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.requiredNamespaces.put(string, bl2);
        }
    }

    void requireBinding(String string, String string2) {
        this.noteBinding(string, string2, true);
    }

    void preferBinding(String string, String string2) {
        this.noteBinding(string, string2, false);
    }

    private void noteBinding(String string, String string2, boolean bl) {
        if (string2.equals("http://www.w3.org/XML/1998/namespace")) {
            return;
        }
        Binding binding = new Binding(string, string2);
        BindingUsage bindingUsage = (BindingUsage)this.bindingUsageMap.get(binding);
        if (bindingUsage == null) {
            bindingUsage = new BindingUsage();
            this.bindingUsageMap.put(binding, bindingUsage);
        }
        if (bl) {
            bindingUsage.required = true;
        }
        ++bindingUsage.usageCount;
    }

    NamespaceBindings createBindings() {
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = new HashMap();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.requiredNamespaces.remove("http://www.w3.org/XML/1998/namespace");
        Vector vector = new Vector();
        vector.addAll(this.bindingUsageMap.keySet());
        Collections.sort(vector, new BindingComparator());
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            object3 = (Binding)iterator.next();
            if (hashMap.get(((Binding)object3).prefix) != null) continue;
            object2 = (Boolean)this.requiredNamespaces.get(((Binding)object3).namespaceUri);
            boolean bl2 = bl = object2 != null && (((Binding)object3).prefix.length() > 0 || ((Boolean)object2).booleanValue());
            if (!((BindingUsage)this.bindingUsageMap.get((Object)object3)).required && !bl) continue;
            hashMap.put(((Binding)object3).prefix, ((Binding)object3).namespaceUri);
            iterator.remove();
            if (bl) {
                this.requiredNamespaces.remove(((Binding)object3).namespaceUri);
            }
            if (((Binding)object3).prefix.length() <= 0) continue;
            hashMap2.put(((Binding)object3).namespaceUri, ((Binding)object3).prefix);
        }
        object3 = vector.iterator();
        while (object3.hasNext()) {
            object2 = (Binding)object3.next();
            if (hashMap.get(((Binding)object2).prefix) != null) continue;
            hashMap.put(((Binding)object2).prefix, ((Binding)object2).namespaceUri);
        }
        int n = 0;
        while (n < conventionalBindings.length) {
            String string;
            String string2 = conventionalBindings[n];
            if (hashMap.get(string2) == null && (object = (Boolean)this.requiredNamespaces.get(string = conventionalBindings[n + 1])) != null && (string2.length() > 0 || ((Boolean)object).booleanValue())) {
                hashMap.put(string2, string);
                this.requiredNamespaces.remove(string);
                if (string2.length() > 0) {
                    hashMap2.put(string, string2);
                }
            }
            n += 2;
        }
        Iterator iterator2 = this.requiredNamespaces.keySet().iterator();
        int n2 = 1;
        while (iterator2.hasNext()) {
            object = "ns" + Integer.toString(n2);
            if (hashMap.get(object) == null) {
                Object k = iterator2.next();
                hashMap.put(object, k);
                hashMap2.put((String)k, object);
            }
            ++n2;
        }
        return new NamespaceBindings(hashMap, hashMap2);
    }

    class BindingComparator
    implements Comparator {
        BindingComparator() {
        }

        public int compare(Object object, Object object2) {
            BindingUsage bindingUsage = (BindingUsage)NamespaceManager.this.bindingUsageMap.get(object);
            BindingUsage bindingUsage2 = (BindingUsage)NamespaceManager.this.bindingUsageMap.get(object2);
            if (bindingUsage.required != bindingUsage2.required) {
                return bindingUsage.required ? -1 : 1;
            }
            if (bindingUsage.usageCount != bindingUsage2.usageCount) {
                return bindingUsage2.usageCount - bindingUsage.usageCount;
            }
            Binding binding = (Binding)object;
            Binding binding2 = (Binding)object2;
            if (binding.prefix.length() != binding2.prefix.length()) {
                return binding.prefix.length() - binding2.prefix.length();
            }
            int n = binding.prefix.compareTo(binding2.prefix);
            if (n != 0) {
                return n;
            }
            return binding.namespaceUri.compareTo(binding2.namespaceUri);
        }
    }

    static class BindingUsage {
        boolean required;
        int usageCount;

        BindingUsage() {
        }
    }

    static class Binding {
        private final String prefix;
        private final String namespaceUri;

        Binding(String string, String string2) {
            this.prefix = string;
            this.namespaceUri = string2;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getNamespaceUri() {
            return this.namespaceUri;
        }

        public int hashCode() {
            return this.prefix.hashCode() ^ this.namespaceUri.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Binding)) {
                return false;
            }
            Binding binding = (Binding)object;
            return this.prefix.equals(binding.prefix) && this.namespaceUri.equals(binding.namespaceUri);
        }
    }

    static class NamespaceBindings {
        private final Map prefixMap;
        private final Map nsMap;

        private NamespaceBindings(Map map, Map map2) {
            this.prefixMap = map;
            this.nsMap = map2;
        }

        String getNonEmptyPrefix(String string) {
            return (String)this.nsMap.get(string);
        }

        String getNamespaceUri(String string) {
            return (String)this.prefixMap.get(string);
        }

        Set getPrefixes() {
            return this.prefixMap.keySet();
        }
    }
}

