/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.metrics.SummaryDataPointMarshaler;
import io.opentelemetry.proto.metrics.v1.internal.Summary;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import java.io.IOException;

final class SummaryMarshaler
extends MarshalerWithSize {
    private final SummaryDataPointMarshaler[] dataPoints;

    static SummaryMarshaler create(SummaryData summary) {
        SummaryDataPointMarshaler[] dataPointMarshalers = SummaryDataPointMarshaler.createRepeated(summary.getPoints());
        return new SummaryMarshaler(dataPointMarshalers);
    }

    private SummaryMarshaler(SummaryDataPointMarshaler[] dataPoints) {
        super(SummaryMarshaler.calculateSize(dataPoints));
        this.dataPoints = dataPoints;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Summary.DATA_POINTS, this.dataPoints);
    }

    private static int calculateSize(SummaryDataPointMarshaler[] dataPoints) {
        int size = 0;
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Summary.DATA_POINTS, (Marshaler[])dataPoints);
    }
}

