/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.coverage;

import com.intellij.coverage.filters.ModifiedFilesFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.git.coverage.CurrentFeatureBranchBaseDetector;
import com.intellij.vcs.git.coverage.GitModifiedFilesFilter;
import com.intellij.vcs.git.coverage.MultiRepoGitModifiedFilesFilter;
import com.intellij.vcs.log.Hash;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"createGitFilter", "Lcom/intellij/coverage/filters/ModifiedFilesFilter;", "project", "Lcom/intellij/openapi/project/Project;", "createFilterForRepository", "Lcom/intellij/vcs/git/coverage/GitModifiedFilesFilter;", "repository", "Lgit4idea/repo/GitRepository;", "findBaseCommitCandidates", "", "Lcom/intellij/vcs/git/coverage/CurrentFeatureBranchBaseDetector$BaseCommitAndBranch;", "createModifiedScope", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "baseRevision", "Lcom/intellij/vcs/log/Hash;", "intellij.vcs.git.coverage"})
@SourceDebugExtension(value={"SMAP\nGitModifiedFilesFilterFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitModifiedFilesFilterFactory.kt\ncom/intellij/vcs/git/coverage/GitModifiedFilesFilterFactoryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1617#2,9:74\n1869#2:83\n1870#2:85\n1626#2:86\n1617#2,9:87\n1869#2:96\n1870#2:98\n1626#2:99\n2423#2,14:100\n1#3:84\n1#3:97\n*S KotlinDebug\n*F\n+ 1 GitModifiedFilesFilterFactory.kt\ncom/intellij/vcs/git/coverage/GitModifiedFilesFilterFactoryKt\n*L\n26#1:74,9\n26#1:83\n26#1:85\n26#1:86\n33#1:87,9\n33#1:96\n33#1:98\n33#1:99\n36#1:100,14\n26#1:84\n33#1:97\n*E\n"})
public final class GitModifiedFilesFilterFactoryKt {
    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static final ModifiedFilesFilter createGitFilter(Project project) {
        void $this$mapNotNullTo$iv$iv;
        Collection<GitRepository> collection = GitUtil.getRepositories(project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
        Collection<GitRepository> repositories = collection;
        Iterable $this$mapNotNull$iv = repositories;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitModifiedFilesFilter it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GitRepository it = (GitRepository)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if (GitModifiedFilesFilterFactoryKt.createFilterForRepository(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filters = (List)destination$iv$iv;
        if (filters.isEmpty()) {
            return null;
        }
        GitModifiedFilesFilter gitModifiedFilesFilter = (GitModifiedFilesFilter)((Object)CollectionsKt.singleOrNull((List)filters));
        return gitModifiedFilesFilter != null ? (ModifiedFilesFilter)gitModifiedFilesFilter : (ModifiedFilesFilter)new MultiRepoGitModifiedFilesFilter(project, filters);
    }

    /*
     * WARNING - void declaration
     */
    private static final GitModifiedFilesFilter createFilterForRepository(GitRepository repository2) {
        Object v3;
        void $this$mapNotNullTo$iv$iv;
        List<CurrentFeatureBranchBaseDetector.BaseCommitAndBranch> list = GitModifiedFilesFilterFactoryKt.findBaseCommitCandidates(repository2);
        if (list == null) {
            return null;
        }
        List<CurrentFeatureBranchBaseDetector.BaseCommitAndBranch> candidates = list;
        Iterable $this$mapNotNull$iv = candidates;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitModifiedFilesFilter gitModifiedFilesFilter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CurrentFeatureBranchBaseDetector.BaseCommitAndBranch baseCommitAndBranch = (CurrentFeatureBranchBaseDetector.BaseCommitAndBranch)element$iv$iv;
            boolean bl2 = false;
            Hash hash = baseCommitAndBranch.component1();
            GitRemoteBranch branch = baseCommitAndBranch.component2();
            if (GitModifiedFilesFilterFactoryKt.createModifiedScope(repository2, hash) == null) {
                gitModifiedFilesFilter = null;
            } else {
                Set<VirtualFile> scope;
                Project project = repository2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                gitModifiedFilesFilter = new GitModifiedFilesFilter(project, scope, branch);
            }
            if (gitModifiedFilesFilter == null) continue;
            GitModifiedFilesFilter it$iv$iv = gitModifiedFilesFilter;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                GitModifiedFilesFilter it = (GitModifiedFilesFilter)((Object)minElem$iv);
                boolean bl = false;
                int minValue$iv = it.getModifiedScope().size();
                do {
                    Object e$iv = iterator$iv.next();
                    GitModifiedFilesFilter it2 = (GitModifiedFilesFilter)((Object)e$iv);
                    $i$a$-minByOrNull-GitModifiedFilesFilterFactoryKt$createFilterForRepository$2 = false;
                    int v$iv = it2.getModifiedScope().size();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        return v3;
    }

    private static final List<CurrentFeatureBranchBaseDetector.BaseCommitAndBranch> findBaseCommitCandidates(GitRepository repository2) {
        CurrentFeatureBranchBaseDetector.Status baseCommit = new CurrentFeatureBranchBaseDetector(repository2).findBaseCommit();
        return baseCommit instanceof CurrentFeatureBranchBaseDetector.Status.Success ? ((CurrentFeatureBranchBaseDetector.Status.Success)baseCommit).getCommits() : null;
    }

    private static final Set<VirtualFile> createModifiedScope(GitRepository repository2, Hash baseRevision) {
        String string = repository2.getCurrentRevision();
        if (string == null) {
            return null;
        }
        String currentRevision = string;
        Collection<Change> collection = GitChangeUtils.getDiff(repository2, baseRevision.asString(), currentRevision, false);
        if (collection == null) {
            return null;
        }
        Collection<Change> diff = collection;
        HashSet<ContentRevision> scope = new HashSet<ContentRevision>();
        for (Change change : diff) {
            ContentRevision contentRevision = change.getAfterRevision();
            if (contentRevision == null || (contentRevision = contentRevision.getFile()) == null || (contentRevision = contentRevision.getVirtualFile()) == null) continue;
            ContentRevision virtualFile = contentRevision;
            scope.add(virtualFile);
        }
        return scope;
    }

    public static final /* synthetic */ ModifiedFilesFilter access$createGitFilter(Project project) {
        return GitModifiedFilesFilterFactoryKt.createGitFilter(project);
    }
}

