/*
 * Decompiled with CFR 0.152.
 */
package git4idea.attributes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.attributes.GitAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class GitCheckAttrParser {
    private static final Logger LOG = Logger.getInstance(GitCheckAttrParser.class);
    private static final String UNSPECIFIED_VALUE = "unspecified";
    private static final Pattern PATTERN = Pattern.compile("(.*):([^:]+):([^:]+)");
    @NotNull
    private final Map<String, Collection<GitAttribute>> myAttributes;

    private GitCheckAttrParser(@NotNull List<String> output2) {
        if (output2 == null) {
            GitCheckAttrParser.$$$reportNull$$$0(0);
        }
        this.myAttributes = new HashMap<String, Collection<GitAttribute>>();
        for (String line : output2) {
            if (line.isEmpty()) continue;
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.matches()) {
                LOG.error(String.format("Output doesn't match the expected format. Line: %s%nAll output:%n%s", line, StringUtil.join(output2, (String)"\n")));
            }
            String file = matcher.group(1).trim();
            String attribute = matcher.group(2).trim();
            String info = matcher.group(3).trim();
            GitAttribute attr = GitAttribute.forName(attribute);
            if (attr == null || info.equalsIgnoreCase(UNSPECIFIED_VALUE)) continue;
            this.myAttributes.computeIfAbsent(file, f -> new ArrayList()).add(attr);
        }
    }

    @NotNull
    public static GitCheckAttrParser parse(@NotNull List<String> output2) {
        if (output2 == null) {
            GitCheckAttrParser.$$$reportNull$$$0(1);
        }
        return new GitCheckAttrParser(output2);
    }

    @NotNull
    public Map<String, Collection<GitAttribute>> getAttributes() {
        Map<String, Collection<GitAttribute>> map2 = this.myAttributes;
        if (map2 == null) {
            GitCheckAttrParser.$$$reportNull$$$0(2);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/attributes/GitCheckAttrParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/attributes/GitCheckAttrParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

