/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.icons.HiDPIImage;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.StartupUiUtil;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0001H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/rebase/GitRebaseHelpPopupPanel;", "Ljavax/swing/JPanel;", "<init>", "()V", "helpLink", "Lcom/intellij/ui/components/BrowserLink;", "getHelpLink", "()Lcom/intellij/ui/components/BrowserLink;", "rebaseBranchImage", "Ljavax/swing/JComponent;", "content", "createContent", "createHelpLink", "createImageComponent", "imagePath", "", "loadImage", "Ljava/awt/Image;", "path", "chooseImage", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseHelpPopupPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseHelpPopupPanel.kt\ngit4idea/rebase/GitRebaseHelpPopupPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,86:1\n1#2:87\n13#3:88\n*S KotlinDebug\n*F\n+ 1 GitRebaseHelpPopupPanel.kt\ngit4idea/rebase/GitRebaseHelpPopupPanel\n*L\n79#1:88\n*E\n"})
public final class GitRebaseHelpPopupPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BrowserLink helpLink = this.createHelpLink();
    @NotNull
    private final JComponent rebaseBranchImage = this.createImageComponent("/images/rebase-branch");
    @NotNull
    private final JPanel content = this.createContent();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String REBASE_BRANCH_IMG = "/images/rebase-branch";
    @NotNull
    private static final String DARK_POSTFIX = "-dark";
    @NotNull
    private static final String HIDPI_POSTFIX = "@2x";

    public GitRebaseHelpPopupPanel() {
        this.add((Component)this.content, "Center");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 32 : false;
                if (bl) {
                    this.getHelpLink().doClick();
                }
            }
        });
    }

    @NotNull
    public final BrowserLink getHelpLink() {
        return this.helpLink;
    }

    private final JPanel createContent() {
        return (JPanel)BuilderKt.panel(arg_0 -> GitRebaseHelpPopupPanel.createContent$lambda$0(this, arg_0));
    }

    private final BrowserLink createHelpLink() {
        String string = GitBundle.message("rebase.help.link", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new BrowserLink(string, "https://git-scm.com/docs/git-rebase");
    }

    private final JComponent createImageComponent(String imagePath) {
        JBImageIcon jBImageIcon;
        Image image;
        String suitableImagePath = this.chooseImage(imagePath);
        Image image2 = image = this.loadImage(suitableImagePath);
        if (image2 != null) {
            Image p0 = image2;
            boolean bl = false;
            jBImageIcon = new JBImageIcon(p0);
        } else {
            jBImageIcon = null;
        }
        Icon icon = (Icon)jBImageIcon;
        return new JLabel(icon);
    }

    private final Image loadImage(String path) {
        Image image;
        try {
            BufferedImage img = ImageIO.read(this.getClass().getResourceAsStream(path));
            Intrinsics.checkNotNull((Object)img);
            image = (Image)new HiDPIImage((Image)img, 274, 140, img.getType());
        }
        catch (Exception e) {
            LOG.warn("Failed to load image: " + path, (Throwable)e);
            image = null;
        }
        return image;
    }

    private final String chooseImage(String imagePath) {
        String themePart = StartupUiUtil.isUnderDarcula() ? DARK_POSTFIX : "";
        String retinaPart = StartupUiUtil.isJreHiDPI() ? HIDPI_POSTFIX : "";
        return imagePath + themePart + retinaPart + ".png";
    }

    private static final Unit createContent$lambda$0(GitRebaseHelpPopupPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, GitRebaseHelpPopupPanel::createContent$lambda$0$0, (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitRebaseHelpPopupPanel.createContent$lambda$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitRebaseHelpPopupPanel.createContent$lambda$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = GitBundle.message("rebase.help.rebase.branch", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$1(GitRebaseHelpPopupPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.rebaseBranchImage);
        return Unit.INSTANCE;
    }

    private static final Unit createContent$lambda$0$2(GitRebaseHelpPopupPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.helpLink);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseHelpPopupPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/GitRebaseHelpPopupPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "REBASE_BRANCH_IMG", "", "DARK_POSTFIX", "HIDPI_POSTFIX", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

