/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.commandLine.TerminalProcessHandler;

public class WinTerminalProcessHandler
extends TerminalProcessHandler {
    private static final String NON_CSI_ESCAPE_CODE = "\u001b.[@-_]";
    private static final String CSI_ESCAPE_CODE = "\u001b\\[(.*?)[@-~]";

    public WinTerminalProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, boolean forceUtf8, boolean forceBinary) {
        if (process == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(1);
        }
        super(process, commandLine, forceUtf8, forceBinary);
    }

    @Override
    protected boolean processHasSeparateErrorStream() {
        return true;
    }

    @NotNull
    protected BaseDataReader createErrorDataReader() {
        return new BaseOSProcessHandler.SimpleOutputReader((BaseOSProcessHandler)this, this.createProcessErrReader(), ProcessOutputTypes.STDERR, BaseOutputReader.Options.BLOCKING, "error stream of " + this.myPresentableName);
    }

    @NotNull
    protected BaseOutputReader.Options readerOptions() {
        BaseOutputReader.Options options = BaseOutputReader.Options.NON_BLOCKING;
        if (options == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(2);
        }
        return options;
    }

    @Override
    @NotNull
    protected String filterCombinedText(@NotNull String currentLine) {
        if (currentLine == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(3);
        }
        return WinTerminalProcessHandler.removeAllBeforeCaretReturn(currentLine);
    }

    @Override
    @NotNull
    protected String filterText(@NotNull String text) {
        if (text == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(4);
        }
        text = text.replaceAll(CSI_ESCAPE_CODE, "").replaceAll(NON_CSI_ESCAPE_CODE, "");
        String string = text = StringUtil.trimLeading((String)text, (char)'\r');
        if (string == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected Key resolveOutputType(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(6);
        }
        if (outputType == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(7);
        }
        Key key = outputType;
        if (key == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(8);
        }
        return key;
    }

    @NotNull
    private static String removeAllBeforeCaretReturn(@NotNull String line) {
        if (line == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(9);
        }
        int caretReturn = line.lastIndexOf("\r");
        while (caretReturn >= 0) {
            if (caretReturn + 1 < line.length() && line.charAt(caretReturn + 1) != '\n') {
                line = line.substring(caretReturn + 1);
                break;
            }
            caretReturn = line.lastIndexOf("\r", caretReturn - 1);
        }
        String string = line;
        if (string == null) {
            WinTerminalProcessHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/commandLine/WinTerminalProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readerOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveOutputType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeAllBeforeCaretReturn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterCombinedText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveOutputType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeAllBeforeCaretReturn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 8, 10 -> new IllegalStateException(string);
        };
    }
}

