/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.revisions;

import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.openapi.util.Clock;
import java.util.Objects;

public final class CurrentRevision
extends Revision {
    private final RootEntry myRoot;
    private final String myPath;

    public CurrentRevision(RootEntry root, String path) {
        this.myRoot = root;
        this.myPath = path;
    }

    @Override
    public long getTimestamp() {
        Entry entry = this.findEntry();
        return entry != null ? entry.getTimestamp() : Clock.getTime();
    }

    @Override
    public Entry findEntry() {
        return this.myRoot.findEntry(this.myPath);
    }

    @Override
    public RootEntry getRoot() {
        return this.myRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrentRevision)) {
            return false;
        }
        CurrentRevision that = (CurrentRevision)o;
        return Objects.equals(this.myRoot, that.myRoot) && Objects.equals(this.myPath, that.myPath);
    }

    public int hashCode() {
        return Objects.hash(this.myRoot, this.myPath);
    }
}

