/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton a) {
        if (!a.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(a);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(a);
                    break;
                }
                case 3: {
                    MinimizationOperations.minimizeValmari(a);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(a);
                }
            }
        }
        a.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitions, boolean[][] mark, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            int m1 = t1[k1].to.number;
            int m2 = t2[k2].to.number;
            if (m1 > m2) {
                int t = m1;
                m1 = m2;
                m2 = t;
            }
            if (mark[m1][m2]) {
                return false;
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitions, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            if (t1[k1].to != t2[k2].to) {
                int m1 = t1[k1].to.number;
                int m2 = t2[k2].to.number;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (triggers.get(m1).get(m2) == null) {
                    triggers.get(m1).set(m2, new HashSet());
                }
                triggers.get(m1).get(m2).add(new IntPair(n1, n2));
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
    }

    private static void markPair(boolean[][] mark, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        mark[n1][n2] = true;
        if (triggers.get(n1).get(n2) != null) {
            for (IntPair p : triggers.get(n1).get(n2)) {
                int m1 = p.n1;
                int m2 = p.n2;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (mark[m1][m2]) continue;
                MinimizationOperations.markPair(mark, triggers, m1, m2);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> list, int size) {
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
    }

    public static void minimizeHuffman(Automaton a) {
        int n;
        int n1;
        a.determinize();
        a.totalize();
        Set<State> ss = a.getStates();
        Transition[][] transitions = new Transition[ss.size()][];
        State[] states = ss.toArray(new State[ss.size()]);
        boolean[][] mark = new boolean[states.length][states.length];
        ArrayList<ArrayList<HashSet<IntPair>>> triggers = new ArrayList<ArrayList<HashSet<IntPair>>>();
        for (n1 = 0; n1 < states.length; ++n1) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, states.length);
            triggers.add(v);
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            states[n1].number = n1;
            transitions[n1] = states[n1].getSortedTransitionArray(false);
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (states[n1].accept == states[n2].accept) continue;
                mark[n1][n2] = true;
            }
        }
        for (n1 = 0; n1 < states.length; ++n1) {
            for (int n2 = n1 + 1; n2 < states.length; ++n2) {
                if (mark[n1][n2]) continue;
                if (MinimizationOperations.statesAgree(transitions, mark, n1, n2)) {
                    MinimizationOperations.addTriggers(transitions, triggers, n1, n2);
                    continue;
                }
                MinimizationOperations.markPair(mark, triggers, n1, n2);
            }
        }
        int numclasses = 0;
        for (int n2 = 0; n2 < states.length; ++n2) {
            states[n2].number = -1;
        }
        for (int n12 = 0; n12 < states.length; ++n12) {
            if (states[n12].number != -1) continue;
            states[n12].number = numclasses;
            for (int n2 = n12 + 1; n2 < states.length; ++n2) {
                if (mark[n12][n2]) continue;
                states[n2].number = numclasses;
            }
            ++numclasses;
        }
        State[] newstates = new State[numclasses];
        for (n = 0; n < numclasses; ++n) {
            newstates[n] = new State();
        }
        for (n = 0; n < states.length; ++n) {
            newstates[states[n].number].number = n;
            if (states[n] != a.initial) continue;
            a.initial = newstates[states[n].number];
        }
        for (n = 0; n < numclasses; ++n) {
            State s = newstates[n];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
        }
        a.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton a) {
        if (a.isSingleton()) {
            return;
        }
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
    }

    public static void minimizeHopcroft(Automaton a) {
        int n;
        int q;
        a.determinize();
        Set<Transition> tr = a.initial.getTransitions();
        if (tr.size() == 1) {
            Transition t = tr.iterator().next();
            if (t.to == a.initial && t.min == '\u0000' && t.max == '\uffff') {
                return;
            }
        }
        a.totalize();
        Set<State> ss = a.getStates();
        State[] states = new State[ss.size()];
        int number = 0;
        Iterator<State> iterator = ss.iterator();
        while (iterator.hasNext()) {
            State q2;
            states[number] = q2 = iterator.next();
            q2.number = number++;
        }
        char[] sigma = a.getStartPoints();
        ArrayList reverse = new ArrayList();
        for (int q3 = 0; q3 < states.length; ++q3) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, sigma.length);
            reverse.add(v);
        }
        boolean[][] reverse_nonempty = new boolean[states.length][sigma.length];
        ArrayList partition = new ArrayList();
        MinimizationOperations.initialize(partition, states.length);
        int[] block = new int[states.length];
        StateList[][] active = new StateList[states.length][sigma.length];
        StateListNode[][] active2 = new StateListNode[states.length][sigma.length];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        boolean[][] pending2 = new boolean[sigma.length][states.length];
        ArrayList<State> split = new ArrayList<State>();
        boolean[] split2 = new boolean[states.length];
        ArrayList<Integer> refine = new ArrayList<Integer>();
        boolean[] refine2 = new boolean[states.length];
        ArrayList splitblock = new ArrayList();
        MinimizationOperations.initialize(splitblock, states.length);
        for (q = 0; q < states.length; ++q) {
            splitblock.set(q, new ArrayList());
            partition.set(q, new LinkedList());
            for (int x = 0; x < sigma.length; ++x) {
                ((ArrayList)reverse.get(q)).set(x, new LinkedList());
                active[q][x] = new StateList();
            }
        }
        for (q = 0; q < states.length; ++q) {
            State qq = states[q];
            int j = qq.accept ? 0 : 1;
            ((LinkedList)partition.get(j)).add(qq);
            block[qq.number] = j;
            for (int x = 0; x < sigma.length; ++x) {
                char y = sigma[x];
                State p = qq.step(y);
                ((LinkedList)((ArrayList)reverse.get(p.number)).get(x)).add(qq);
                reverse_nonempty[p.number][x] = true;
            }
        }
        for (int j = 0; j <= 1; ++j) {
            for (int x = 0; x < sigma.length; ++x) {
                for (State qq : (LinkedList)partition.get(j)) {
                    if (!reverse_nonempty[qq.number][x]) continue;
                    active2[qq.number][x] = active[j][x].add(qq);
                }
            }
        }
        for (int x = 0; x < sigma.length; ++x) {
            int a0 = active[0][x].size;
            int a1 = active[1][x].size;
            int j = a0 <= a1 ? 0 : 1;
            pending.add(new IntPair(j, x));
            pending2[x][j] = true;
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x = ip.n2;
            pending2[x][p] = false;
            StateListNode m = active[p][x].first;
            while (m != null) {
                for (State s : (LinkedList)((ArrayList)reverse.get(m.q.number)).get(x)) {
                    if (split2[s.number]) continue;
                    split2[s.number] = true;
                    split.add(s);
                    int j = block[s.number];
                    ((ArrayList)splitblock.get(j)).add(s);
                    if (refine2[j]) continue;
                    refine2[j] = true;
                    refine.add(j);
                }
                m = m.next;
            }
            Iterator iterator2 = refine.iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                if (((ArrayList)splitblock.get(j)).size() < ((LinkedList)partition.get(j)).size()) {
                    LinkedList b1 = (LinkedList)partition.get(j);
                    LinkedList b2 = (LinkedList)partition.get(k);
                    for (State s : (ArrayList)splitblock.get(j)) {
                        b1.remove(s);
                        b2.add(s);
                        block[s.number] = k;
                        for (int c = 0; c < sigma.length; ++c) {
                            StateListNode sn = active2[s.number][c];
                            if (sn == null || sn.sl != active[j][c]) continue;
                            sn.remove();
                            active2[s.number][c] = active[k][c].add(s);
                        }
                    }
                    for (int c = 0; c < sigma.length; ++c) {
                        int aj = active[j][c].size;
                        int ak = active[k][c].size;
                        if (!pending2[c][j] && 0 < aj && aj <= ak) {
                            pending2[c][j] = true;
                            pending.add(new IntPair(j, c));
                            continue;
                        }
                        pending2[c][k] = true;
                        pending.add(new IntPair(k, c));
                    }
                    ++k;
                }
                for (State s : (ArrayList)splitblock.get(j)) {
                    split2[s.number] = false;
                }
                refine2[j] = false;
                ((ArrayList)splitblock.get(j)).clear();
            }
            split.clear();
            refine.clear();
        }
        State[] newstates = new State[k];
        for (n = 0; n < newstates.length; ++n) {
            State s;
            newstates[n] = s = new State();
            for (State q4 : (LinkedList)partition.get(n)) {
                if (q4 == a.initial) {
                    a.initial = s;
                }
                s.accept = q4.accept;
                s.number = q4.number;
                q4.number = n;
            }
        }
        for (n = 0; n < newstates.length; ++n) {
            State s = newstates[n];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
        }
        a.removeDeadTransitions();
    }

    public static void minimizeValmari(Automaton automaton) {
        automaton.determinize();
        Set<State> states = automaton.getStates();
        MinimizationOperations.splitTransitions(states);
        int stateCount = states.size();
        int transitionCount = automaton.getNumberOfTransitions();
        Set<State> acceptStates = automaton.getAcceptStates();
        Partition blocks = new Partition(stateCount);
        Partition cords = new Partition(transitionCount);
        IntPair[] labels = new IntPair[transitionCount];
        int[] tails = new int[transitionCount];
        int[] heads = new int[transitionCount];
        Automaton.setStateNumbers(states);
        int number = 0;
        for (State s : automaton.getStates()) {
            for (Transition t : s.getTransitions()) {
                tails[number] = s.number;
                labels[number] = new IntPair(t.min, t.max);
                heads[number] = t.getDest().number;
                ++number;
            }
        }
        for (State s : acceptStates) {
            blocks.mark(s.number);
        }
        blocks.split();
        if (transitionCount > 0) {
            Arrays.sort(cords.elements, new LabelComparator(labels));
            cords.markedElementCount[0] = 0;
            cords.setCount = 0;
            IntPair a = labels[cords.elements[0]];
            int i = 0;
            while (i < transitionCount) {
                int t = cords.elements[i];
                if (labels[t].n1 != a.n1 || labels[t].n2 != a.n2) {
                    a = labels[t];
                    cords.past[cords.setCount++] = i;
                    cords.first[cords.setCount] = i;
                    cords.markedElementCount[cords.setCount] = 0;
                }
                cords.setNo[t] = cords.setCount;
                cords.locations[t] = i++;
            }
            cords.past[cords.setCount++] = transitionCount;
        }
        int[] A = new int[transitionCount];
        int[] F = new int[stateCount + 1];
        MinimizationOperations.makeAdjacent(A, F, heads, stateCount, transitionCount);
        for (int c = 0; c < cords.setCount; ++c) {
            for (int i = cords.first[c]; i < cords.past[c]; ++i) {
                blocks.mark(tails[cords.elements[i]]);
            }
            blocks.split();
            for (int b = 1; b < blocks.setCount; ++b) {
                for (int i = blocks.first[b]; i < blocks.past[b]; ++i) {
                    for (int j = F[blocks.elements[i]]; j < F[blocks.elements[i] + 1]; ++j) {
                        cords.mark(A[j]);
                    }
                }
                cords.split();
            }
        }
        State[] newStates = new State[blocks.setCount];
        for (int bl = 0; bl < blocks.setCount; ++bl) {
            newStates[bl] = new State();
            if (blocks.first[bl] >= acceptStates.size()) continue;
            newStates[bl].accept = true;
        }
        for (int t = 0; t < transitionCount; ++t) {
            if (blocks.locations[tails[t]] != blocks.first[blocks.setNo[tails[t]]]) continue;
            State tail = newStates[blocks.setNo[tails[t]]];
            State head = newStates[blocks.setNo[heads[t]]];
            tail.addTransition(new Transition((char)labels[t].n1, (char)labels[t].n2, head));
        }
        automaton.setInitialState(newStates[blocks.setNo[automaton.getInitialState().number]]);
        automaton.reduce();
    }

    private static void makeAdjacent(int[] A, int[] F, int[] K, int nn, int mm) {
        int t;
        int q;
        for (q = 0; q <= nn; ++q) {
            F[q] = 0;
        }
        for (t = 0; t < mm; ++t) {
            int n = K[t];
            F[n] = F[n] + 1;
        }
        for (q = 0; q < nn; ++q) {
            int n = q + 1;
            F[n] = F[n] + F[q];
        }
        t = mm;
        while (t-- > 0) {
            int n = K[t];
            int n2 = F[n] - 1;
            F[n] = n2;
            A[n2] = t;
        }
    }

    private static void splitTransitions(Set<State> states) {
        TreeSet<Character> pointSet = new TreeSet<Character>();
        for (State s : states) {
            for (Transition t : s.getTransitions()) {
                pointSet.add(Character.valueOf(t.min));
                pointSet.add(Character.valueOf(t.max));
            }
        }
        for (State s : states) {
            Set<Transition> transitions = s.getTransitions();
            s.resetTransitions();
            for (Transition t : transitions) {
                if (t.min == t.max) {
                    s.addTransition(t);
                    continue;
                }
                NavigableSet<Character> headSet = pointSet.headSet(Character.valueOf(t.max), true);
                NavigableSet<Character> tailSet = pointSet.tailSet(Character.valueOf(t.min), false);
                TreeSet<Character> intersection = new TreeSet<Character>((SortedSet<Character>)headSet);
                intersection.retainAll(tailSet);
                char start = t.min;
                for (Character c : intersection) {
                    s.addTransition(new Transition(start, t.to));
                    s.addTransition(new Transition(c.charValue(), t.to));
                    if (c.charValue() - start > 1) {
                        s.addTransition(new Transition((char)(start + '\u0001'), (char)(c.charValue() - '\u0001'), t.to));
                    }
                    start = c.charValue();
                }
            }
        }
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State q) {
            return new StateListNode(q, this);
        }
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static class Partition {
        int[] markedElementCount;
        int[] touchedSets;
        int touchedSetCount;
        int setCount;
        Integer[] elements;
        int[] locations;
        int[] setNo;
        int[] first;
        int[] past;

        Partition(int size) {
            this.setCount = size == 0 ? 0 : 1;
            this.elements = new Integer[size];
            this.locations = new int[size];
            this.setNo = new int[size];
            this.first = new int[size];
            this.past = new int[size];
            this.markedElementCount = new int[size];
            this.touchedSets = new int[size];
            for (int i = 0; i < size; ++i) {
                this.locations[i] = i;
                this.elements[i] = this.locations[i];
                this.setNo[i] = 0;
            }
            if (this.setCount != 0) {
                this.first[0] = 0;
                this.past[0] = size;
            }
        }

        void mark(int e) {
            int s = this.setNo[e];
            int i = this.locations[e];
            int j = this.first[s] + this.markedElementCount[s];
            this.elements[i] = this.elements[j];
            this.locations[this.elements[i].intValue()] = i;
            this.elements[j] = e;
            this.locations[e] = j;
            int n = s;
            int n2 = this.markedElementCount[n];
            this.markedElementCount[n] = n2 + 1;
            if (n2 == 0) {
                this.touchedSets[this.touchedSetCount++] = s;
            }
        }

        void split() {
            while (this.touchedSetCount > 0) {
                int s;
                int j;
                if ((j = this.first[s = this.touchedSets[--this.touchedSetCount]] + this.markedElementCount[s]) == this.past[s]) {
                    this.markedElementCount[s] = 0;
                    continue;
                }
                if (this.markedElementCount[s] <= this.past[s] - j) {
                    this.first[this.setCount] = this.first[s];
                    this.past[this.setCount] = this.first[s] = j;
                } else {
                    this.past[this.setCount] = this.past[s];
                    this.first[this.setCount] = this.past[s] = j;
                }
                for (int i = this.first[this.setCount]; i < this.past[this.setCount]; ++i) {
                    this.setNo[this.elements[i].intValue()] = this.setCount;
                }
                this.markedElementCount[this.setCount++] = 0;
                this.markedElementCount[s] = 0;
            }
        }
    }

    static class LabelComparator
    implements Comparator<Integer> {
        private IntPair[] labels;

        LabelComparator(IntPair[] labels) {
            this.labels = labels;
        }

        @Override
        public int compare(Integer i, Integer j) {
            IntPair p1 = this.labels[i];
            IntPair p2 = this.labels[j];
            if (p1.n1 < p2.n1) {
                return -1;
            }
            if (p1.n1 > p2.n1) {
                return 1;
            }
            if (p1.n2 < p2.n2) {
                return -1;
            }
            if (p1.n2 > p2.n2) {
                return 1;
            }
            return 0;
        }
    }
}

