/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Objects;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerUtil;
import org.apache.lucene.search.TwoPhaseIterator;

public class DisiWrapper {
    public final DocIdSetIterator iterator;
    final PostingsEnum postingsEnum;
    public final Scorer scorer;
    public final Scorable scorable;
    public final long cost;
    public final float matchCost;
    public int doc;
    public DisiWrapper next;
    public final DocIdSetIterator approximation;
    public final TwoPhaseIterator twoPhaseView;
    long scaledMaxScore;
    float maxWindowScore;
    final float weight;

    public DisiWrapper(Scorer scorer, boolean impacts) {
        this(scorer, impacts, 1.0f);
    }

    DisiWrapper(Scorer scorer, boolean impacts, float weight) {
        PostingsEnum pe;
        this.scorer = Objects.requireNonNull(scorer);
        this.scorable = ScorerUtil.likelyTermScorer(scorer);
        this.iterator = impacts ? ScorerUtil.likelyImpactsEnum(scorer.iterator()) : scorer.iterator();
        DocIdSetIterator docIdSetIterator = this.iterator;
        this.postingsEnum = docIdSetIterator instanceof PostingsEnum ? (pe = (PostingsEnum)docIdSetIterator) : null;
        this.cost = this.iterator.cost();
        this.doc = -1;
        this.twoPhaseView = scorer.twoPhaseIterator();
        if (this.twoPhaseView != null) {
            this.approximation = this.twoPhaseView.approximation();
            this.matchCost = this.twoPhaseView.matchCost();
        } else {
            this.approximation = this.iterator;
            this.matchCost = 0.0f;
        }
        this.weight = weight;
    }
}

