/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.knn.KnnSearchStrategy;

public interface KnnCollector {
    public boolean earlyTerminated();

    public void incVisitedCount(int var1);

    public long visitedCount();

    public long visitLimit();

    public int k();

    public boolean collect(int var1, float var2);

    public float minCompetitiveSimilarity();

    public TopDocs topDocs();

    public KnnSearchStrategy getSearchStrategy();

    public static abstract class Decorator
    implements KnnCollector {
        protected final KnnCollector collector;

        public Decorator(KnnCollector collector) {
            this.collector = collector;
        }

        @Override
        public boolean earlyTerminated() {
            return this.collector.earlyTerminated();
        }

        @Override
        public void incVisitedCount(int count) {
            this.collector.incVisitedCount(count);
        }

        @Override
        public long visitedCount() {
            return this.collector.visitedCount();
        }

        @Override
        public long visitLimit() {
            return this.collector.visitLimit();
        }

        @Override
        public int k() {
            return this.collector.k();
        }

        @Override
        public boolean collect(int docId, float similarity) {
            return this.collector.collect(docId, similarity);
        }

        @Override
        public float minCompetitiveSimilarity() {
            return this.collector.minCompetitiveSimilarity();
        }

        @Override
        public TopDocs topDocs() {
            return this.collector.topDocs();
        }

        @Override
        public KnnSearchStrategy getSearchStrategy() {
            return this.collector.getSearchStrategy();
        }
    }
}

