/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.core.util;

import java.util.Objects;

public final class TermSize {
    private final int myColumns;
    private final int myRows;

    public TermSize(int columns, int rows) {
        if (columns < 0) {
            throw new IllegalArgumentException("negative column count: " + columns);
        }
        if (rows < 0) {
            throw new IllegalArgumentException("negative row count: " + rows);
        }
        this.myColumns = columns;
        this.myRows = rows;
    }

    public int getColumns() {
        return this.myColumns;
    }

    public int getRows() {
        return this.myRows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermSize other = (TermSize)o;
        return this.myColumns == other.myColumns && this.myRows == other.myRows;
    }

    public int hashCode() {
        return Objects.hash(this.myColumns, this.myRows);
    }

    public String toString() {
        return "columns=" + this.myColumns + ", rows=" + this.myRows;
    }
}

