/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelUtil;
import com.intellij.database.run.ui.ResultViewFactory;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.database.run.ui.table.TableScrollPane;
import com.intellij.database.run.ui.table.TableSelectionModel;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class TableResultViewFactory
implements ResultViewFactory {
    public static final TableResultViewFactory TABLE_FACTORY = new TableResultViewFactory();

    @Override
    @NotNull
    public ResultView createResultView(final @NotNull DataGrid resultPanel, @NotNull ActionGroup columnHeaderActions, @NotNull ActionGroup rowHeaderActions) {
        if (resultPanel == null) {
            TableResultViewFactory.$$$reportNull$$$0(0);
        }
        if (columnHeaderActions == null) {
            TableResultViewFactory.$$$reportNull$$$0(1);
        }
        if (rowHeaderActions == null) {
            TableResultViewFactory.$$$reportNull$$$0(2);
        }
        final TableResultView table2 = new TableResultView(resultPanel, columnHeaderActions, rowHeaderActions);
        table2.getEmptyText().setText("");
        table2.setSelectionMode(2);
        table2.setCellSelectionEnabled(true);
        table2.setAutoResizeMode(0);
        table2.setBackground(resultPanel.getColorsScheme().getDefaultBackground());
        table2.setShowGrid(true);
        table2.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    int columnIndex;
                    int rowIndex = table2.isTransposed() ? table2.columnAtPoint(e.getPoint()) : table2.rowAtPoint(e.getPoint());
                    int n = columnIndex = table2.isTransposed() ? table2.rowAtPoint(e.getPoint()) : table2.columnAtPoint(e.getPoint());
                    if (rowIndex >= 0 && columnIndex >= 0 && !table2.isCellSelected(rowIndex, columnIndex)) {
                        int modelRow = table2.getRawIndexConverter().row2Model().applyAsInt(rowIndex);
                        int modelColumn = table2.getRawIndexConverter().column2Model().applyAsInt(columnIndex);
                        SelectionModel selectionModel = resultPanel.getSelectionModel();
                        selectionModel.setSelection(ModelIndexSet.forRows((CoreGrid)resultPanel, (int[])new int[]{modelRow}), ModelIndexSet.forColumns((CoreGrid)resultPanel, (int[])new int[]{modelColumn}));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultViewFactory$1", "mousePressed"));
            }
        });
        TableResultView tableResultView = table2;
        if (tableResultView == null) {
            TableResultViewFactory.$$$reportNull$$$0(3);
        }
        return tableResultView;
    }

    @Override
    @NotNull
    public JComponent wrap(final @NotNull DataGrid grid, @NotNull ResultView resultView) {
        if (grid == null) {
            TableResultViewFactory.$$$reportNull$$$0(4);
        }
        if (resultView == null) {
            TableResultViewFactory.$$$reportNull$$$0(5);
        }
        final TableResultView table2 = (TableResultView)resultView;
        final Ref myTransparentHeaderBg = new Ref((Object)false);
        MyCornerToolsComponent cornerComponent = new MyCornerToolsComponent(grid.getProject()){

            @Override
            TableResultView getTable() {
                return table2;
            }

            @Override
            DataGrid getGrid() {
                return grid;
            }

            public Color getBackground() {
                return (Boolean)myTransparentHeaderBg.get() != false ? this.getTable().getBackground() : DataGridUIUtil.softHighlightOf(this.getTable().getBackground());
            }
        };
        table2.addColumnHeaderBackgroundChangedListener(v -> myTransparentHeaderBg.set(v));
        TableScrollPane scrollPane = new TableScrollPane(table2, grid, (JComponent)((Object)cornerComponent), grid.getAutoscrollLocker()){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                if (EditorSettingsExternalizable.getInstance().isWheelFontChangeEnabled() && !MouseGestureManager.getInstance().hasTrackpad() && EditorUtil.isChangeFontSize((MouseWheelEvent)e)) {
                    int rotation = e.getWheelRotation();
                    if (rotation != 0) {
                        table2.changeFontSize(-rotation, 1.0);
                    }
                    return;
                }
                super.processMouseWheelEvent(e);
            }

            public void paint(Graphics g) {
                table2.startPaintingSession();
                try {
                    super.paint(g);
                }
                finally {
                    table2.endPaintingSession();
                }
            }
        };
        table2.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(@NotNull ListSelectionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                grid.getHiddenColumnSelectionHolder().setWholeRowSelected(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/table/TableResultViewFactory$4", "valueChanged"));
            }
        });
        TableScrollPane tableScrollPane = scrollPane;
        if (tableScrollPane == null) {
            TableResultViewFactory.$$$reportNull$$$0(6);
        }
        return tableScrollPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnHeaderActions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowHeaderActions";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableResultViewFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableResultViewFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "wrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultView";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }

    private static abstract class MyCornerToolsComponent
    extends JBViewport {
        MyCornerToolsComponent(@NotNull Project project) {
            if (project == null) {
                MyCornerToolsComponent.$$$reportNull$$$0(0);
            }
            EditorHeaderComponent view = new EditorHeaderComponent();
            view.setOpaque(false);
            this.add((Component)view);
            DumbAwareAction action = DumbAwareAction.create((String)DataGridBundle.message((String)"action.select.all.text", (Object[])new Object[0]), (Icon)EmptyIcon.ICON_18, e -> {
                this.selectAll();
                if (!this.getTable().hasFocus()) {
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)((Object)this.getTable()), true);
                }
            });
            ActionButton button = new ActionButton((AnAction)action, null, "", (Dimension)JBUI.emptySize());
            view.add((Component)button, (Object)"Center");
            view.setBorder(IdeBorderFactory.createBorder((int)12));
        }

        abstract TableResultView getTable();

        abstract DataGrid getGrid();

        void selectAll() {
            boolean deselect;
            ListSelectionModel rowModel = this.getTable().getSelectionModel();
            int r0 = rowModel.getMinSelectionIndex();
            int r1 = rowModel.getMaxSelectionIndex();
            ListSelectionModel columnModel = this.getTable().getColumnModel().getSelectionModel();
            int c0 = columnModel.getMinSelectionIndex();
            int c1 = columnModel.getMaxSelectionIndex();
            boolean bl = deselect = r1 - r0 + 1 == this.getTable().getRowCount() && c1 - c0 + 1 == this.getTable().getColumnCount();
            if (deselect) {
                this.getTable().clearSelection();
            } else {
                this.getGrid().getAutoscrollLocker().runWithLock(() -> {
                    TableSelectionModel model2 = (TableSelectionModel)ObjectUtils.tryCast(SelectionModelUtil.get(this.getGrid(), this.getTable()), TableSelectionModel.class);
                    if (model2 != null) {
                        model2.setRowSelectionInterval(0, this.getTable().getRowCount());
                        model2.setColumnSelectionInterval(0, this.getTable().getColumnCount());
                    }
                });
            }
            this.getGrid().getHiddenColumnSelectionHolder().setWholeRowSelected(!deselect);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/run/ui/table/TableResultViewFactory$MyCornerToolsComponent", "<init>"));
        }
    }
}

