/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.dependency.fest_reflect.type;

import org.assertj.swing.dependency.fest_reflect.type.TypeLoader;
import org.assertj.swing.dependency.fest_util.Strings;

public final class Type {
    private final String name;

    public static Type newType(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the class to load should not be null");
        }
        if (Strings.isEmpty(name)) {
            throw new IllegalArgumentException("The name of the class to load should not be empty");
        }
        return new Type(name);
    }

    private Type(String name) {
        this.name = name;
    }

    public Class<?> load() {
        return TypeLoader.newLoader(this.name, this.thisClassLoader()).load();
    }

    public <T> Class<? extends T> loadAs(Class<T> type) {
        return TypeLoader.newLoader(this.name, this.thisClassLoader()).loadAs(type);
    }

    private ClassLoader thisClassLoader() {
        return this.getClass().getClassLoader();
    }

    public TypeLoader withClassLoader(ClassLoader classLoader) {
        return TypeLoader.newLoader(this.name, classLoader);
    }
}

