/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.phonetics.nysiis;

import ai.grazie.nlp.phonetics.PhoneticEncoder;
import ai.grazie.utils.multiplatform.SafeJsExport;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\f\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002J\f\u0010\u000e\u001a\u00020\f*\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/grazie/nlp/phonetics/nysiis/NYSIIS;", "Lai/grazie/nlp/phonetics/PhoneticEncoder;", "<init>", "()V", "firstLetter", "", "Lkotlin/Pair;", "", "lastLetter", "mStrs", "eStrs", "isVowel", "", "", "isRoman", "encode", "value", "nlp-phonetics"})
@SourceDebugExtension(value={"SMAP\nNYSIIS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NYSIIS.kt\nai/grazie/nlp/phonetics/nysiis/NYSIIS\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,84:1\n1069#2,2:85\n*S KotlinDebug\n*F\n+ 1 NYSIIS.kt\nai/grazie/nlp/phonetics/nysiis/NYSIIS\n*L\n24#1:85,2\n*E\n"})
public final class NYSIIS
implements PhoneticEncoder {
    @NotNull
    public static final NYSIIS INSTANCE = new NYSIIS();
    @NotNull
    private static final List<Pair<String, String>> firstLetter;
    @NotNull
    private static final List<Pair<String, String>> lastLetter;
    @NotNull
    private static final List<Pair<String, String>> mStrs;
    @NotNull
    private static final List<String> eStrs;

    private NYSIIS() {
    }

    private final boolean isVowel(char $this$isVowel) {
        return StringsKt.contains$default((CharSequence)"AEIOU", (char)$this$isVowel, (boolean)false, (int)2, null);
    }

    private final boolean isRoman(String $this$isRoman) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = $this$isRoman;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (StringsKt.contains$default((CharSequence)"IVX", (char)it, (boolean)false, (int)2, null)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    @Override
    @NotNull
    public String encode(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return value;
        }
        String string = value.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        Object w = string;
        char[] cArray = new char[]{' ', ','};
        List ww = StringsKt.split$default((CharSequence)((CharSequence)w), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (ww.size() > 1 && this.isRoman((String)CollectionsKt.last((List)ww))) {
            w = StringsKt.dropLast((String)w, (int)((String)CollectionsKt.last((List)ww)).length());
        }
        int n = " ,'-".length();
        for (int i = 0; i < n; ++i) {
            char c = " ,'-".charAt(i);
            w = StringsKt.replace$default((String)w, (String)String.valueOf(c), (String)"", (boolean)false, (int)4, null);
        }
        for (String string2 : eStrs) {
            if (!StringsKt.endsWith$default((String)w, (String)string2, (boolean)false, (int)2, null)) continue;
            w = StringsKt.dropLast((String)w, (int)string2.length());
        }
        for (Pair pair : firstLetter) {
            if (!StringsKt.startsWith$default((String)w, (String)((String)pair.getFirst()), (boolean)false, (int)2, null)) continue;
            w = StringsKt.replaceFirst$default((String)w, (String)((String)pair.getFirst()), (String)((String)pair.getSecond()), (boolean)false, (int)4, null);
        }
        for (Pair pair : lastLetter) {
            if (!StringsKt.endsWith$default((String)w, (String)((String)pair.getFirst()), (boolean)false, (int)2, null)) continue;
            w = StringsKt.dropLast((String)w, (int)2) + pair.getSecond();
        }
        StringBuilder key = new StringBuilder().append(((String)w).charAt(0));
        w = StringsKt.drop((String)w, (int)1);
        for (Pair<String, String> mStr : mStrs) {
            w = StringsKt.replace$default((String)w, (String)((String)mStr.getFirst()), (String)((String)mStr.getSecond()), (boolean)false, (int)4, null);
        }
        StringBuilder stringBuilder = new StringBuilder().append(key.charAt(0)).append((String)w);
        int len = stringBuilder.length();
        for (int i = 1; i < len; ++i) {
            char c = stringBuilder.charAt(i);
            if (StringsKt.contains$default((CharSequence)"EIOU", (char)c, (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.setCharAt(i, 'A');
                continue;
            }
            if (c == 'Q') {
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.setCharAt(i, 'G');
                continue;
            }
            if (c == 'Z') {
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.setCharAt(i, 'S');
                continue;
            }
            if (c == 'M') {
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.setCharAt(i, 'N');
                continue;
            }
            if (c == 'K') {
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.setCharAt(i, 'C');
                continue;
            }
            if (c == 'H') {
                if (this.isVowel(stringBuilder.charAt(i - 1)) && (i >= len - 1 || this.isVowel(stringBuilder.charAt(i + 1)))) continue;
                Intrinsics.checkNotNull((Object)stringBuilder);
                stringBuilder.setCharAt(i, stringBuilder.charAt(i - 1));
                continue;
            }
            if (c != 'W' || !this.isVowel(stringBuilder.charAt(i - 1))) continue;
            Intrinsics.checkNotNull((Object)stringBuilder);
            stringBuilder.setCharAt(i, 'A');
        }
        if (stringBuilder.charAt(len - 1) == 'S') {
            stringBuilder.setLength(len - 1);
            --len;
        }
        if (len > 1 && Intrinsics.areEqual((Object)stringBuilder.substring(len - 2), (Object)"AY")) {
            stringBuilder.setLength(len - 2);
            stringBuilder.append("Y");
            --len;
        }
        if (len > 0 && stringBuilder.charAt(len - 1) == 'A') {
            stringBuilder.setLength(len - 1);
            --len;
        }
        char prev = key.charAt(0);
        int n2 = len;
        for (int j = 1; j < n2; ++j) {
            char c = stringBuilder.charAt(j);
            if (prev == c) continue;
            key.append(c);
            prev = c;
        }
        String string3 = key.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"MAC", (Object)"MCC"), TuplesKt.to((Object)"KN", (Object)"N"), TuplesKt.to((Object)"K", (Object)"C"), TuplesKt.to((Object)"PH", (Object)"FF"), TuplesKt.to((Object)"PF", (Object)"FF"), TuplesKt.to((Object)"SCH", (Object)"SSS")};
        firstLetter = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"EE", (Object)"Y"), TuplesKt.to((Object)"IE", (Object)"Y"), TuplesKt.to((Object)"DT", (Object)"D"), TuplesKt.to((Object)"RT", (Object)"D"), TuplesKt.to((Object)"RD", (Object)"D"), TuplesKt.to((Object)"NT", (Object)"D"), TuplesKt.to((Object)"ND", (Object)"D")};
        lastLetter = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"EV", (Object)"AF"), TuplesKt.to((Object)"KN", (Object)"N"), TuplesKt.to((Object)"SCH", (Object)"SSS"), TuplesKt.to((Object)"PH", (Object)"FF")};
        mStrs = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"JR", "JNR", "SR", "SNR"};
        eStrs = CollectionsKt.listOf((Object[])objectArray);
    }
}

