/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.langs.Language;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

record ChangeLanguageVariant(Lang from, Lang to, boolean wasOxford, boolean toOxford, String text) implements LocalQuickFix
{
    static final String BRITISH_OXFORD_ID = "GB-oxendict";

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.text;
        if (string == null) {
            ChangeLanguageVariant.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            ChangeLanguageVariant.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            ChangeLanguageVariant.$$$reportNull$$$0(2);
        }
        var action2 = new BasicUndoableAction(new VirtualFile[]{descriptor.getPsiElement().getContainingFile().getVirtualFile()}){

            public void undo() {
                ChangeLanguageVariant.changeVariant(ChangeLanguageVariant.this.to, ChangeLanguageVariant.this.from, ChangeLanguageVariant.this.wasOxford);
            }

            public void redo() {
                ChangeLanguageVariant.changeVariant(ChangeLanguageVariant.this.from, ChangeLanguageVariant.this.to, ChangeLanguageVariant.this.toOxford);
            }
        };
        action2.redo();
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
    }

    private static void changeVariant(Lang from, Lang to, boolean toOxford) {
        GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)s -> {
            EnumSet<Lang> languages2 = EnumSet.copyOf(s.getEnabledLanguages());
            languages2.remove((Object)from);
            languages2.add(to);
            return s.withLanguages(languages2);
        }));
        if (from.isEnglish()) {
            GrazieConfig.Companion.update((Function1<? super GrazieConfig.State, GrazieConfig.State>)((Function1)state -> state.withOxfordSpelling(toOxford)));
        }
    }

    @Nullable
    static LocalQuickFix create(Language language, String toVariant, String text) {
        Lang from = StreamEx.of(GrazieConfig.Companion.get().getAvailableLanguages()).findFirst(l -> language.getIso().equals((Object)l.getIso())).orElse(null);
        if (from == null) {
            return null;
        }
        boolean toOxford = BRITISH_OXFORD_ID.equals(toVariant);
        String toCountry = toOxford ? "GB" : toVariant;
        Lang to = (Lang)((Object)ContainerUtil.find((Object[])Lang.values(), l -> l.getIso().equals((Object)from.getIso()) && toCountry.equals(ChangeLanguageVariant.countryCode(l))));
        return to == null ? null : new ChangeLanguageVariant(from, to, GrazieConfig.Companion.get().getUseOxfordSpelling(), toOxford, text);
    }

    @Nullable
    private static String countryCode(Lang l) {
        return switch (l) {
            case Lang.AMERICAN_ENGLISH -> "US";
            case Lang.BRITISH_ENGLISH -> "GB";
            case Lang.CANADIAN_ENGLISH -> "CA";
            case Lang.GERMANY_GERMAN -> "DE";
            case Lang.AUSTRIAN_GERMAN -> "AT";
            default -> null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/ChangeLanguageVariant";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/ChangeLanguageVariant";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

