/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.settings.Setting;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.grazie.utils.TextUtilsKt;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Rule {
    private final String globalId;
    private final Language language;
    private final String presentableName;
    private final List<String> categories;

    public Rule(String globalId, Language language, String presentableName, String category) {
        this(globalId, language, presentableName, List.of(category));
    }

    public Rule(String globalId, Language language, String presentableName, List<String> categories) {
        this.globalId = globalId;
        this.language = language;
        this.presentableName = presentableName;
        this.categories = List.copyOf(categories);
        if (categories.isEmpty()) {
            throw new IllegalArgumentException("There should be at least one category specified for rule " + globalId);
        }
        if (!globalId.contains(".")) {
            throw new IllegalArgumentException("Global id should be a qualified name with at least one dot inside: " + String.valueOf(this));
        }
    }

    public String getGlobalId() {
        return this.globalId;
    }

    public String getPresentableName() {
        return this.presentableName;
    }

    public Language getLanguage() {
        return this.language;
    }

    @NotNull
    public abstract String getDescription();

    @NotNull
    public String getSearchableDescription() {
        String string = this.getDescription();
        if (string == null) {
            Rule.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public URL getUrl() {
        return null;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    @Deprecated(forRemoval=true)
    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isEnabledByDefault(TextStyleDomain domain) {
        return true;
    }

    @Nullable
    public Setting getFeaturedSetting() {
        return null;
    }

    public final boolean isCurrentlyEnabled(TextContent content) {
        GrazieConfig.State state = GrazieConfig.Companion.get();
        TextStyleDomain domain = TextUtilsKt.getTextDomain(content);
        return this.isEnabledInState(state, domain);
    }

    public final boolean isEnabledInState(GrazieConfig.State state, TextStyleDomain domain) {
        return this.isEnabledByDefault(domain) ? !state.isRuleDisabled(this.globalId, domain) : state.isRuleEnabled(this.globalId, domain);
    }

    public final boolean equals(Object o) {
        return this == o || this.getClass().equals(o.getClass()) && this.globalId.equals(((Rule)o).globalId);
    }

    public final int hashCode() {
        return Objects.hash(this.globalId);
    }

    public String toString() {
        return this.presentableName + "(" + this.globalId + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/grazie/text/Rule", "getSearchableDescription"));
    }
}

