/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.PyInjectionUtil;
import com.jetbrains.python.codeInsight.PyInjectorBase;
import com.jetbrains.python.codeInsight.functionTypeComments.PyFunctionTypeAnnotationDialect;
import com.jetbrains.python.codeInsight.typeHints.PyTypeHintDialect;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypeParameterListOwner;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector;", "Lcom/jetbrains/python/codeInsight/PyInjectorBase;", "<init>", "()V", "registerInjection", "Lcom/jetbrains/python/codeInsight/PyInjectionUtil$InjectionResult;", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "context", "Lcom/intellij/psi/PsiElement;", "getInjectedLanguage", "Lcom/intellij/lang/Language;", "isTypingCastTypeArgument", "", "expr", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "isTypingTypeVarTypeArgument", "isTypingNewTypeTypeArgument", "isTypingAssertTypeTypeArgument", "Companion", "intellij.python.community.impl"})
public final class PyTypingAnnotationInjector
extends PyInjectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex RE_TYPING_ANNOTATION = new Regex("(?x)\n      \\s*\n      \\S+(\\[.*])?   # initial type like: \"list[int]\"\n      (\\s*\\|\\s*     # union operator: \" | \"\n        \\S+(\\[.*])? # type between union operator\n      )*            # repeating\n      \\s*", RegexOption.DOT_MATCHES_ALL);

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    protected PyInjectionUtil.InjectionResult registerInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Language language = this.getInjectedLanguage(context);
        if (language != null) {
            Language language2 = language;
            boolean bl = false;
            PsiElement element = PyInjectionUtil.getLargestStringLiteral(context);
            if (element != null) {
                PyInjectionUtil.InjectionResult injectionResult;
                if (language2 == PyTypeHintDialect.INSTANCE) {
                    String string = element.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                        injectionResult = PyInjectionUtil.registerStringLiteralInjectionWithParenthesis(element, registrar, language2);
                        return injectionResult;
                    }
                }
                injectionResult = PyInjectionUtil.registerStringLiteralInjection(element, registrar, language2);
                return injectionResult;
            }
        }
        if (!(context instanceof PsiComment)) return PyInjectionUtil.InjectionResult.EMPTY;
        if (!(context instanceof PsiLanguageInjectionHost)) return PyInjectionUtil.InjectionResult.EMPTY;
        if (!(context.getContainingFile() instanceof PyFile)) return PyInjectionUtil.InjectionResult.EMPTY;
        return PyTypingAnnotationInjector.Companion.registerCommentInjection(registrar, (PsiLanguageInjectionHost)context);
    }

    @Override
    @Nullable
    public Language getInjectedLanguage(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context instanceof PyStringLiteralExpression) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)((PyStringLiteralExpression)context).getProject(), (PsiFile)((PyStringLiteralExpression)context).getContainingFile());
            Intrinsics.checkNotNull((Object)typeEvalContext);
            if (PyTypingAnnotationInjector.Companion.isTypingLiteralArgument(context, typeEvalContext) || PyTypingAnnotationInjector.Companion.isTypingAnnotatedMetadataArgument(context, typeEvalContext)) {
                return null;
            }
            Class[] classArray = new Class[]{PyCallExpression.class};
            if (PsiTreeUtil.getParentOfType((PsiElement)context, PyAnnotation.class, (boolean)true, (Class[])classArray) != null) {
                String string = ((PyStringLiteralExpression)context).getStringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
                if (PyTypingAnnotationInjector.Companion.isTypingAnnotation(string)) {
                    return (Language)PyTypeHintDialect.INSTANCE;
                }
            }
            if (PyTypingAnnotationInjector.Companion.isInsideValueOfExplicitTypeAnnotation((PyStringLiteralExpression)context)) {
                return (Language)PyTypeHintDialect.INSTANCE;
            }
            if (PyTypingAnnotationInjector.Companion.isInsideNewStyleTypeVarBound(context)) {
                return (Language)PyTypeHintDialect.INSTANCE;
            }
            if (this.isTypingCastTypeArgument((PyStringLiteralExpression)context, typeEvalContext)) {
                return (Language)PyTypeHintDialect.INSTANCE;
            }
            if (this.isTypingTypeVarTypeArgument((PyStringLiteralExpression)context, typeEvalContext)) {
                return (Language)PyTypeHintDialect.INSTANCE;
            }
            if (this.isTypingNewTypeTypeArgument((PyStringLiteralExpression)context, typeEvalContext)) {
                return (Language)PyTypeHintDialect.INSTANCE;
            }
            if (this.isTypingAssertTypeTypeArgument((PyStringLiteralExpression)context, typeEvalContext)) {
                return (Language)PyTypeHintDialect.INSTANCE;
            }
        }
        return null;
    }

    private final boolean isTypingCastTypeArgument(PyStringLiteralExpression expr, TypeEvalContext context) {
        PyArgumentList pyArgumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PyArgumentList.class);
        if (pyArgumentList == null) {
            return false;
        }
        PyArgumentList argList = pyArgumentList;
        PsiElement psiElement = argList.getParent();
        PyCallExpression pyCallExpression = psiElement instanceof PyCallExpression ? (PyCallExpression)psiElement : null;
        if (pyCallExpression == null) {
            return false;
        }
        PyCallExpression call = pyCallExpression;
        PyExpression pyExpression = call.getCallee();
        if (pyExpression == null) {
            return false;
        }
        PyExpression callee = pyExpression;
        Collection collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)callee, (TypeEvalContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveToQualifiedNames(...)");
        Collection resolvedNames = collection;
        if (!resolvedNames.contains("typing.cast") && !resolvedNames.contains("typing_extensions.cast")) {
            return false;
        }
        PyExpression[] pyExpressionArray = argList.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
        PyExpression[] args = pyExpressionArray;
        if (args.length == 0) {
            return false;
        }
        PyKeywordArgument pyKeywordArgument = argList.getKeywordArgument("typ");
        if (pyKeywordArgument != null) {
            PyKeywordArgument it = pyKeywordArgument;
            boolean bl = false;
            return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)it), (PsiElement)((PsiElement)expr), (boolean)false);
        }
        PyExpression firstArg = args[0];
        return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)firstArg), (PsiElement)((PsiElement)expr), (boolean)false);
    }

    private final boolean isTypingTypeVarTypeArgument(PyStringLiteralExpression expr, TypeEvalContext context) {
        PyExpression value;
        PyExpression value2;
        PyExpression arg;
        PyArgumentList pyArgumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PyArgumentList.class);
        if (pyArgumentList == null) {
            return false;
        }
        PyArgumentList argList = pyArgumentList;
        PsiElement psiElement = argList.getParent();
        PyCallExpression pyCallExpression = psiElement instanceof PyCallExpression ? (PyCallExpression)psiElement : null;
        if (pyCallExpression == null) {
            return false;
        }
        PyCallExpression call = pyCallExpression;
        PyExpression pyExpression = call.getCallee();
        if (pyExpression == null) {
            return false;
        }
        PyExpression callee = pyExpression;
        Collection collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)callee, (TypeEvalContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveToQualifiedNames(...)");
        Collection resolvedNames = collection;
        if (!resolvedNames.contains("typing.TypeVar") && !resolvedNames.contains("typing_extensions.TypeVar")) {
            return false;
        }
        PyExpression[] pyExpressionArray = argList.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
        Iterator iterator = ArraysKt.drop((Object[])pyExpressionArray, (int)1).iterator();
        while (iterator.hasNext() && !((arg = (PyExpression)iterator.next()) instanceof PyKeywordArgument)) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)arg), (PsiElement)((PsiElement)expr), (boolean)false)) continue;
            return true;
        }
        PyKeywordArgument boundKw = argList.getKeywordArgument("bound");
        if (boundKw != null && (value2 = boundKw.getValueExpression()) != null && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value2), (PsiElement)((PsiElement)expr), (boolean)false)) {
            return true;
        }
        PyKeywordArgument defaultKw = argList.getKeywordArgument("default");
        return defaultKw != null && (value = defaultKw.getValueExpression()) != null && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)value), (PsiElement)((PsiElement)expr), (boolean)false);
    }

    private final boolean isTypingNewTypeTypeArgument(PyStringLiteralExpression expr, TypeEvalContext context) {
        PyArgumentList pyArgumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PyArgumentList.class);
        if (pyArgumentList == null) {
            return false;
        }
        PyArgumentList argList = pyArgumentList;
        PsiElement psiElement = argList.getParent();
        PyCallExpression pyCallExpression = psiElement instanceof PyCallExpression ? (PyCallExpression)psiElement : null;
        if (pyCallExpression == null) {
            return false;
        }
        PyCallExpression call = pyCallExpression;
        PyExpression pyExpression = call.getCallee();
        if (pyExpression == null) {
            return false;
        }
        PyExpression callee = pyExpression;
        Collection collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)callee, (TypeEvalContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveToQualifiedNames(...)");
        Collection resolvedNames = collection;
        if (!resolvedNames.contains("typing.NewType")) {
            return false;
        }
        PyExpression[] pyExpressionArray = argList.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
        PyExpression[] args = pyExpressionArray;
        if (args.length < 2) {
            return false;
        }
        PyExpression secondArg = args[1];
        return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)secondArg), (PsiElement)((PsiElement)expr), (boolean)false);
    }

    private final boolean isTypingAssertTypeTypeArgument(PyStringLiteralExpression expr, TypeEvalContext context) {
        PyArgumentList pyArgumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PyArgumentList.class);
        if (pyArgumentList == null) {
            return false;
        }
        PyArgumentList argList = pyArgumentList;
        PsiElement psiElement = argList.getParent();
        PyCallExpression pyCallExpression = psiElement instanceof PyCallExpression ? (PyCallExpression)psiElement : null;
        if (pyCallExpression == null) {
            return false;
        }
        PyCallExpression call = pyCallExpression;
        PyExpression pyExpression = call.getCallee();
        if (pyExpression == null) {
            return false;
        }
        PyExpression callee = pyExpression;
        Collection collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)callee, (TypeEvalContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveToQualifiedNames(...)");
        Collection resolvedNames = collection;
        if (!resolvedNames.contains("typing.assert_type")) {
            return false;
        }
        PyExpression[] pyExpressionArray = argList.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getArguments(...)");
        PyExpression[] args = pyExpressionArray;
        if (args.length < 2) {
            return false;
        }
        PyExpression expectedTypeArg = args[1];
        return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)expectedTypeArg), (PsiElement)((PsiElement)expr), (boolean)false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector$Companion;", "", "<init>", "()V", "RE_TYPING_ANNOTATION", "Lkotlin/text/Regex;", "getRE_TYPING_ANNOTATION", "()Lkotlin/text/Regex;", "isInsideValueOfExplicitTypeAnnotation", "", "expr", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "registerCommentInjection", "Lcom/jetbrains/python/codeInsight/PyInjectionUtil$InjectionResult;", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "isTypingLiteralArgument", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "isTypingAnnotatedMetadataArgument", "isFunctionTypeComment", "comment", "isInsideNewStyleTypeVarBound", "isTypingAnnotation", "s", "", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyTypingAnnotationInjector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTypingAnnotationInjector.kt\ncom/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,269:1\n1761#2,3:270\n1761#2,3:273\n*S KotlinDebug\n*F\n+ 1 PyTypingAnnotationInjector.kt\ncom/jetbrains/python/codeInsight/typing/PyTypingAnnotationInjector$Companion\n*L\n133#1:270,3\n149#1:273,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getRE_TYPING_ANNOTATION() {
            return RE_TYPING_ANNOTATION;
        }

        private final boolean isInsideValueOfExplicitTypeAnnotation(PyStringLiteralExpression expr) {
            PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expr), PyAssignmentStatement.class);
            if (assignment == null || !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)assignment.getAssignedValue()), (PsiElement)((PsiElement)expr), (boolean)false)) {
                return false;
            }
            return PyTypingTypeProvider.isExplicitTypeAlias((PyAssignmentStatement)assignment, (TypeEvalContext)TypeEvalContext.codeAnalysis((Project)expr.getProject(), (PsiFile)expr.getContainingFile()));
        }

        private final PyInjectionUtil.InjectionResult registerCommentInjection(MultiHostRegistrar registrar, PsiLanguageInjectionHost host) {
            String text = host.getText();
            String annotationText = PyTypingTypeProvider.getTypeCommentValue((String)text);
            if (annotationText != null) {
                Language language = null;
                language = PyTypingTypeProvider.TYPE_IGNORE_PATTERN.matcher(text).matches() ? null : (this.isFunctionTypeComment((PsiElement)host) ? (Language)PyFunctionTypeAnnotationDialect.INSTANCE : (Language)PyTypeHintDialect.INSTANCE);
                if (language != null) {
                    registrar.startInjecting(language);
                    TextRange textRange = PyTypingTypeProvider.getTypeCommentValueRange((String)text);
                    Intrinsics.checkNotNull((Object)textRange);
                    registrar.addPlace("", "", host, textRange);
                    registrar.doneInjecting();
                    return new PyInjectionUtil.InjectionResult(true, true);
                }
            }
            PyInjectionUtil.InjectionResult injectionResult = PyInjectionUtil.InjectionResult.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)injectionResult, (String)"EMPTY");
            return injectionResult;
        }

        private final boolean isTypingLiteralArgument(PsiElement element, TypeEvalContext context) {
            boolean bl;
            block6: {
                PsiElement psiElement;
                PsiElement parent = element.getParent();
                if (parent instanceof PyTupleExpression) {
                    parent = ((PyTupleExpression)parent).getParent();
                }
                PySubscriptionExpression pySubscriptionExpression = (psiElement = parent) instanceof PySubscriptionExpression ? (PySubscriptionExpression)psiElement : null;
                if (pySubscriptionExpression == null) {
                    return false;
                }
                PySubscriptionExpression subscription = pySubscriptionExpression;
                PyExpression pyExpression = subscription.getOperand();
                PyReferenceExpression pyReferenceExpression = pyExpression instanceof PyReferenceExpression ? (PyReferenceExpression)pyExpression : null;
                if (pyReferenceExpression == null) {
                    return false;
                }
                PyReferenceExpression operand = pyReferenceExpression;
                Collection collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)((PyExpression)operand), (TypeEvalContext)context);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveToQualifiedNames(...)");
                Collection resolvedNames = collection;
                Iterable $this$any$iv = resolvedNames;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)"typing.Literal", (Object)it) || Intrinsics.areEqual((Object)"typing_extensions.Literal", (Object)it))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isTypingAnnotatedMetadataArgument(PsiElement element, TypeEvalContext context) {
            boolean bl;
            PyTupleExpression tuple;
            block6: {
                tuple = (PyTupleExpression)PyUtil.as((Object)element.getParent(), PyTupleExpression.class);
                if (tuple == null) {
                    return false;
                }
                PySubscriptionExpression parent = (PySubscriptionExpression)PyUtil.as((Object)tuple.getParent(), PySubscriptionExpression.class);
                if (parent == null) {
                    return false;
                }
                PyExpression pyExpression = parent.getOperand();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getOperand(...)");
                PyExpression operand = pyExpression;
                Collection collection = PyTypingTypeProvider.resolveToQualifiedNames((PyExpression)operand, (TypeEvalContext)context);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveToQualifiedNames(...)");
                Collection resolvedNames = collection;
                Iterable $this$any$iv = resolvedNames;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)"typing.Annotated", (Object)it) || Intrinsics.areEqual((Object)"typing_extensions.Annotated", (Object)it))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return ((PyExpression[])tuple.getElements())[0] != element;
            }
            return false;
        }

        private final boolean isFunctionTypeComment(PsiElement comment) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)comment, PyFunction.class);
            return function != null && function.getTypeComment() == comment;
        }

        private final boolean isInsideNewStyleTypeVarBound(PsiElement element) {
            Class[] classArray = new Class[]{PyTypeParameterListOwner.class};
            return PsiTreeUtil.getParentOfType((PsiElement)element, PyTypeParameter.class, (boolean)true, (Class[])classArray) != null;
        }

        private final boolean isTypingAnnotation(String s) {
            return this.getRE_TYPING_ANNOTATION().matches((CharSequence)s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

