/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.extensions.ModuleExtKt;
import com.jetbrains.python.packaging.PyPackageVersion;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0019\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0086\u0002\u001a\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0002\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"compareTo", "", "Lcom/jetbrains/python/packaging/PyPackageVersion;", "other", "compareVersions", "", "actual", "operation", "", "required", "getPythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "psiFile", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPackageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageUtils.kt\ncom/jetbrains/python/requirements/PackageUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1563#2:106\n1634#2,3:107\n*S KotlinDebug\n*F\n+ 1 PackageUtils.kt\ncom/jetbrains/python/requirements/PackageUtilsKt\n*L\n58#1:106\n58#1:107,3\n*E\n"})
public final class PackageUtilsKt {
    public static final int compareTo(@Nullable PyPackageVersion $this$compareTo, @Nullable PyPackageVersion other) {
        if ($this$compareTo == null && other == null) {
            return 0;
        }
        if ($this$compareTo == null) {
            return -1;
        }
        if (other == null) {
            return 1;
        }
        char[] cArray = new char[]{'.'};
        List partsThis = StringsKt.split$default((CharSequence)$this$compareTo.getRelease(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        char[] cArray2 = new char[]{'.'};
        List partsOther = StringsKt.split$default((CharSequence)other.getRelease(), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        int diff = partsThis.size() - partsOther.size();
        PyPackageVersion a = $this$compareTo;
        PyPackageVersion b = other;
        if (diff != 0) {
            int n = 0;
            int n2 = Math.abs(diff);
            Object[] objectArray = new String[n2];
            while (n < n2) {
                int n3 = n++;
                objectArray[n3] = "0";
            }
            Object[] tail = objectArray;
            if (diff > 0) {
                b = PyPackageVersion.copy$default((PyPackageVersion)other, null, (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)partsOther, (Object[])tail), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), null, null, null, null, (int)61, null);
            } else {
                a = PyPackageVersion.copy$default((PyPackageVersion)$this$compareTo, null, (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)partsThis, (Object[])tail), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), null, null, null, null, (int)61, null);
            }
        }
        return PyPackageVersionComparator.INSTANCE.compare(a, b);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean compareVersions(@Nullable PyPackageVersion actual, @NotNull String operation, @Nullable PyPackageVersion required) {
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        if (Intrinsics.areEqual((Object)operation, (Object)"===")) {
            PyPackageVersion pyPackageVersion = actual;
            PyPackageVersion pyPackageVersion2 = required;
            return Intrinsics.areEqual((Object)(pyPackageVersion != null ? pyPackageVersion.getPresentableText() : null), (Object)(pyPackageVersion2 != null ? pyPackageVersion2.getPresentableText() : null));
        }
        if (actual == null) {
            return false;
        }
        if (required == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"==")) {
            return PackageUtilsKt.compareTo(actual, required) == 0;
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"~=")) {
            void $this$mapTo$iv$iv;
            char[] cArray = new char[]{'.'};
            List parts = StringsKt.split$default((CharSequence)required.getRelease(), (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() < 2) {
                return PackageUtilsKt.compareVersions(actual, "==", required);
            }
            Iterable $this$map$iv = parts.subList(0, parts.size() - 2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Integer.parseInt((String)it));
            }
            List partsAsInt = (List)destination$iv$iv;
            int lastGroup = Integer.parseInt((String)parts.get(parts.size() - 2)) + 1;
            PyPackageVersion maxRequired = PyPackageVersion.copy$default((PyPackageVersion)required, null, (String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)partsAsInt, (Iterable)CollectionsKt.listOf((Object)lastGroup)), (CharSequence)".", null, null, (int)0, null, null, (int)62, null), null, null, null, null, (int)61, null);
            return PackageUtilsKt.compareVersions(actual, ">=", required) && PackageUtilsKt.compareVersions(actual, "<", maxRequired);
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"!=")) {
            return PackageUtilsKt.compareTo(actual, required) != 0;
        }
        if (Intrinsics.areEqual((Object)operation, (Object)">=")) {
            return PackageUtilsKt.compareVersions(actual, "==", required) || PackageUtilsKt.compareVersions(actual, ">", required);
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"<=")) {
            return PackageUtilsKt.compareVersions(actual, "==", required) || PackageUtilsKt.compareVersions(actual, "<", required);
        }
        if (Intrinsics.areEqual((Object)operation, (Object)">")) {
            if (actual.getPre() != null) {
                return false;
            }
            return PackageUtilsKt.compareTo(actual, required) > 0;
        }
        if (Intrinsics.areEqual((Object)operation, (Object)"<")) {
            if (actual.getPre() != null) {
                return false;
            }
            return PackageUtilsKt.compareTo(actual, required) < 0;
        }
        return false;
    }

    @Nullable
    public static final Sdk getPythonSdk(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return PackageUtilsKt.getPythonSdk(project, virtualFile2);
    }

    @Nullable
    public static final Sdk getPythonSdk(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module2 == null) {
            return null;
        }
        Module module3 = module2;
        Sdk sdk2 = ModuleExtKt.getSdk((Module)module3);
        if (sdk2 == null) {
            return null;
        }
        Sdk moduleSdk = sdk2;
        if (moduleSdk.getSdkType() instanceof PythonSdkType) {
            return moduleSdk;
        }
        return null;
    }
}

