/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.quickfix.WrapExceptTupleInParenthesesQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.validation.PyCompatibilityVisitor;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyCompatibilityInspection
extends PyInspection {
    @NotNull
    public static final List<String> BACKPORTED_PACKAGES = ImmutableList.builder().add((Object)"enum").add((Object)"typing").add((Object)"dataclasses").build();
    public static final List<String> COMPATIBILITY_LIBS = Collections.singletonList("six");
    public static final int LATEST_INSPECTION_VERSION = 3;
    @NotNull
    public static final List<LanguageLevel> DEFAULT_PYTHON_VERSIONS = ImmutableList.of((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.getLatest());
    @NotNull
    public static final List<LanguageLevel> SUPPORTED_LEVELS = ((StreamEx)StreamEx.of((Object[])LanguageLevel.values()).filter(v -> v == LanguageLevel.PYTHON27 || v.isAtLeast(LanguageLevel.PYTHON37))).toImmutableList();
    private static final @NotNull List<@NlsSafe String> SUPPORTED_IN_SETTINGS = ContainerUtil.map(SUPPORTED_LEVELS, LanguageLevel::toString);
    public JDOMExternalizableStringList ourVersions = new JDOMExternalizableStringList();

    public PyCompatibilityInspection() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.ourVersions.addAll(SUPPORTED_IN_SETTINGS);
        } else {
            this.ourVersions.addAll((Collection)ContainerUtil.map(DEFAULT_PYTHON_VERSIONS, LanguageLevel::toString));
        }
    }

    @Nullable
    public static PyCompatibilityInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyCompatibilityInspection.$$$reportNull$$$0(0);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyCompatibilityInspection.class.getSimpleName();
        return (PyCompatibilityInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    private List<LanguageLevel> updateVersionsToProcess() {
        ArrayList<LanguageLevel> result = new ArrayList<LanguageLevel>();
        for (String version : this.ourVersions) {
            if (!SUPPORTED_IN_SETTINGS.contains(version)) continue;
            LanguageLevel level = LanguageLevel.fromPythonVersion((String)version);
            result.add(level);
        }
        return result;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptCheckbox[] versionCheckboxes = (OptCheckbox[])ContainerUtil.map2Array(SUPPORTED_IN_SETTINGS, OptCheckbox.class, ver -> OptPane.checkbox((String)ver, (String)ver, (OptRegularComponent[])new OptRegularComponent[0]));
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.group((String)PyPsiBundle.message("INSP.compatibility.check.for.compatibility.with.python.versions", new Object[0]), (OptRegularComponent[])versionCheckboxes)});
        if (optPane == null) {
            PyCompatibilityInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = OptionController.of(arg_0 -> this.ourVersions.contains(arg_0), (bindId, value) -> {
            boolean checked = (Boolean)value;
            if (!checked) {
                this.ourVersions.remove(bindId);
            } else if (!this.ourVersions.contains(bindId)) {
                this.ourVersions.add(bindId);
            }
        });
        if (optionController == null) {
            PyCompatibilityInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PyCompatibilityInspection.$$$reportNull$$$0(3);
        }
        return new Visitor(holder, this.updateVersionsToProcess());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyCompatibilityInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class Visitor
    extends PyCompatibilityVisitor {
        private final ProblemsHolder myHolder;
        private final Set<String> myUsedImports = Collections.synchronizedSet(new HashSet());
        private final Set<String> myFromCompatibilityLibs = Collections.synchronizedSet(new HashSet());

        Visitor(ProblemsHolder holder, List<LanguageLevel> versionsToProcess) {
            super(versionsToProcess);
            this.myHolder = holder;
        }

        @Override
        protected void registerProblem(@NotNull PsiElement element, @NotNull TextRange range, @NotNull @InspectionMessage String message, boolean asError, LocalQuickFix ... fixes) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (range == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (message == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (fixes == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (element.getTextLength() == 0) {
                return;
            }
            range = range.shiftRight(-element.getTextRange().getStartOffset());
            this.myHolder.registerProblem(element, range, message, fixes);
        }

        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            PyTargetExpression target;
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            super.visitPyCallExpression(node);
            PyExpression callee = node.getCallee();
            if (callee != null && this.importedFromCompatibilityLibs(callee)) {
                return;
            }
            TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)node.getProject(), (PsiFile)node.getContainingFile());
            PsiElement resolvedCallee = Optional.ofNullable(callee).map(PsiElement::getReference).map(PsiReference::resolve).map(e -> e instanceof PyClass ? ((PyClass)e).findInitOrNew(false, context) : e).orElse(null);
            if (resolvedCallee instanceof PyFunction) {
                String className;
                String functionName;
                PyFunction function = (PyFunction)resolvedCallee;
                PyClass containingClass = function.getContainingClass();
                String string = functionName = PyUtil.isConstructorLikeMethod((PsiElement)function) ? callee.getText() : function.getName();
                if (containingClass != null && UnsupportedFeaturesUtil.CLASS_METHODS.containsKey(className = containingClass.getName())) {
                    Map<LanguageLevel, Set<String>> unsupportedMethods = UnsupportedFeaturesUtil.CLASS_METHODS.get(className);
                    this.registerForAllMatchingVersions((LanguageLevel level) -> unsupportedMethods.getOrDefault(level, Collections.emptySet()).contains(functionName), PyPsiBundle.message("INSP.compatibility.feature.have.method", functionName), (PsiElement)node, new LocalQuickFix[0]);
                }
                if (PyBuiltinCache.getInstance((PsiElement)function).isBuiltin((PsiElement)function) && !"print".equals(functionName) && !"exec".equals(functionName) && !this.myUsedImports.contains(functionName)) {
                    this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.BUILTINS.get(level).contains(functionName), PyPsiBundle.message("INSP.compatibility.feature.have.method", functionName), (PsiElement)node, new LocalQuickFix[0]);
                }
            } else if (resolvedCallee instanceof PyTargetExpression && !(target = (PyTargetExpression)resolvedCallee).isQualified() && "long".equals(target.getName()) && PyBuiltinCache.getInstance(resolvedCallee).isBuiltin(resolvedCallee)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.BUILTINS.get(level).contains("long"), PyPsiBundle.message("INSP.compatibility.feature.have.type.long", new Object[0]), (PsiElement)node, new LocalQuickFix[0]);
            }
        }

        public void visitPyImportElement(@NotNull PyImportElement importElement) {
            QualifiedName qName;
            if (importElement == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            this.myUsedImports.add(importElement.getVisibleName());
            PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyIfStatement.class);
            if (ifParent != null) {
                return;
            }
            PyTryExceptStatement tryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyTryExceptStatement.class);
            if (tryExceptStatement != null) {
                for (PyExceptPart part : tryExceptStatement.getExceptParts()) {
                    PyExpression exceptClass = part.getExceptClass();
                    if (exceptClass == null || !exceptClass.getText().equals("ImportError")) continue;
                    return;
                }
            }
            if ((qName = Visitor.getImportedFullyQName(importElement)) != null && !qName.matches(new String[]{"builtins"}) && !qName.matches(new String[]{"__builtin__"})) {
                if (COMPATIBILITY_LIBS.contains(qName.getFirstComponent())) {
                    this.myFromCompatibilityLibs.add(qName.getLastComponent());
                }
                String moduleName = qName.toString();
                this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.MODULES.get(level).contains(moduleName) && !BACKPORTED_PACKAGES.contains(moduleName), PyPsiBundle.message("INSP.compatibility.feature.have.module", moduleName), (PsiElement)importElement, new LocalQuickFix[0]);
            }
        }

        @Nullable
        private static QualifiedName getImportedFullyQName(@NotNull PyImportElement importElement) {
            QualifiedName importedQName;
            if (importElement == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if ((importedQName = importElement.getImportedQName()) == null) {
                return null;
            }
            PyStatement containingImportStatement = importElement.getContainingImportStatement();
            QualifiedName importSourceQName = containingImportStatement instanceof PyFromImportStatement ? ((PyFromImportStatement)containingImportStatement).getImportSourceQName() : null;
            return importSourceQName == null ? importedQName : importSourceQName.append(importedQName);
        }

        public void visitPyFromImportStatement(@NotNull PyFromImportStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            super.visitPyFromImportStatement(node);
            if (node.getRelativeLevel() > 0) {
                return;
            }
            QualifiedName name = node.getImportSourceQName();
            PyReferenceExpression source = node.getImportSource();
            if (name != null && source != null) {
                String moduleName = name.toString();
                this.registerForAllMatchingVersions((LanguageLevel level) -> UnsupportedFeaturesUtil.MODULES.get(level).contains(moduleName) && !BACKPORTED_PACKAGES.contains(moduleName), PyPsiBundle.message("INSP.compatibility.feature.have.module", name), (PsiElement)source, new LocalQuickFix[0]);
            }
        }

        public void visitPyArgumentList(@NotNull PyArgumentList node) {
            block4: {
                boolean isPython2;
                block5: {
                    if (node == null) {
                        Visitor.$$$reportNull$$$0(8);
                    }
                    if (!(node.getParent() instanceof PyClass)) break block4;
                    isPython2 = LanguageLevel.forElement((PsiElement)node).isPython2();
                    if (isPython2) break block5;
                    if (!ContainerUtil.exists((Iterable)this.myVersionsToProcess, LanguageLevel::isPython2)) break block4;
                }
                Arrays.stream(node.getArguments()).filter(PyKeywordArgument.class::isInstance).forEach(expression -> this.myHolder.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.compatibility.this.syntax.available.only.since.py3", new Object[0]), !isPython2 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]));
            }
        }

        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            super.visitPyElement((PyElement)node);
            if (ContainerUtil.exists((Iterable)this.myVersionsToProcess, LanguageLevel::isPy3K)) {
                PsiElement res;
                PyExpression qualifier;
                String nodeText = node.getText();
                if ((nodeText.endsWith("iteritems") || nodeText.endsWith("iterkeys") || nodeText.endsWith("itervalues")) && (qualifier = node.getQualifier()) != null) {
                    TypeEvalContext context = TypeEvalContext.codeAnalysis((Project)node.getProject(), (PsiFile)node.getContainingFile());
                    PyType type = context.getType((PyTypedElement)qualifier);
                    PyClassType dictType = PyBuiltinCache.getInstance((PsiElement)node).getDictType();
                    if (PyTypeChecker.match((PyType)dictType, type, context)) {
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.old.dict.methods.not.available.in.py3", new Object[0]), new LocalQuickFix[0]);
                    }
                }
                if ("basestring".equals(nodeText) && (res = node.getReference().resolve()) != null) {
                    PsiFile file = res.getContainingFile();
                    if (file != null) {
                        VirtualFile virtualFile = file.getVirtualFile();
                        if (virtualFile != null && ProjectRootManager.getInstance((Project)node.getProject()).getFileIndex().isInLibraryClasses(virtualFile)) {
                            this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.basestring.type.not.available.in.py3", new Object[0]), new LocalQuickFix[0]);
                        }
                    } else {
                        this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.compatibility.basestring.type.not.available.in.py3", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        }

        @Override
        public void visitPyExceptBlock(@NotNull PyExceptPart exceptExpr) {
            PyTupleExpression tuple;
            if (exceptExpr == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            super.visitPyExceptBlock(exceptExpr);
            TreeSet<LanguageLevel> allVersions = new TreeSet<LanguageLevel>(this.myVersionsToProcess);
            allVersions.add(LanguageLevel.forElement((PsiElement)exceptExpr));
            boolean hasBelow300 = ContainerUtil.exists(allVersions, level -> level.isOlderThan(LanguageLevel.PYTHON30));
            boolean hasBelow314 = ContainerUtil.exists(allVersions, level -> level.isOlderThan(LanguageLevel.PYTHON314));
            String allVersionsStr = StringUtil.join(allVersions, LanguageLevel::toString, (String)", ");
            PyExpression exceptClass = exceptExpr.getExceptClass();
            PyExpression target = exceptExpr.getTarget();
            if (exceptClass == null) {
                return;
            }
            if (LanguageLevel.forElement((PsiElement)exceptExpr).isAtLeast(LanguageLevel.PYTHON314) && exceptClass instanceof PyTupleExpression && (tuple = (PyTupleExpression)exceptClass).getElements().length > 1 && target == null) {
                if (hasBelow300) {
                    this.registerProblem((PsiElement)exceptClass, PyPsiBundle.message("INSP.compatibility.except.clause.different.semantics", allVersionsStr), new LocalQuickFix[0]);
                } else if (hasBelow314) {
                    LocalQuickFix quickFix = LocalQuickFix.from((ModCommandAction)new WrapExceptTupleInParenthesesQuickFix(tuple));
                    this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON30) && level.isOlderThan(LanguageLevel.PYTHON314), PyPsiBundle.message("INSP.compatibility.except.clause.missing.parens", new Object[0]), (PsiElement)exceptClass, quickFix);
                }
            }
        }

        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(11);
            }
            super.visitPyTargetExpression(node);
            this.warnAsyncAndAwaitAreBecomingKeywordsInPy37((PsiNameIdentifierOwner)node);
        }

        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(12);
            }
            super.visitPyClass(node);
            this.warnAsyncAndAwaitAreBecomingKeywordsInPy37((PsiNameIdentifierOwner)node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(13);
            }
            super.visitPyFunction(node);
            this.warnAsyncAndAwaitAreBecomingKeywordsInPy37((PsiNameIdentifierOwner)node);
        }

        @Override
        protected boolean registerForLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                Visitor.$$$reportNull$$$0(14);
            }
            return level != LanguageLevel.forElement((PsiElement)this.myHolder.getFile());
        }

        private void warnAsyncAndAwaitAreBecomingKeywordsInPy37(@NotNull PsiNameIdentifierOwner nameIdentifierOwner) {
            PsiElement nameIdentifier;
            if (nameIdentifierOwner == null) {
                Visitor.$$$reportNull$$$0(15);
            }
            if ((nameIdentifier = nameIdentifierOwner.getNameIdentifier()) != null && ArrayUtil.contains((String)nameIdentifierOwner.getName(), (String[])new String[]{"await", "async"}) && LanguageLevel.forElement((PsiElement)nameIdentifierOwner).isOlderThan(LanguageLevel.PYTHON37)) {
                this.registerForAllMatchingVersions((LanguageLevel level) -> level.isAtLeast(LanguageLevel.PYTHON37), PyPsiBundle.message("INSP.compatibility.feature.allow.async.and.await.as.names", new Object[0]), nameIdentifier, PythonUiService.getInstance().createPyRenameElementQuickFix((PsiElement)nameIdentifierOwner));
            }
        }

        private boolean importedFromCompatibilityLibs(@NotNull PyExpression callee) {
            if (callee == null) {
                Visitor.$$$reportNull$$$0(16);
            }
            if (callee instanceof PyQualifiedExpression) {
                QualifiedName qualifiedName = ((PyQualifiedExpression)callee).asQualifiedName();
                return qualifiedName != null && this.myFromCompatibilityLibs.contains(qualifiedName.getFirstComponent());
            }
            return this.myFromCompatibilityLibs.contains(callee.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importElement";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptExpr";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifierOwner";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callee";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyImportElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getImportedFullyQName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFromImportStatement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyArgumentList";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyReferenceExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyExceptBlock";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyTargetExpression";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerForLanguageLevel";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warnAsyncAndAwaitAreBecomingKeywordsInPy37";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importedFromCompatibilityLibs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

