/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Sets;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstCallable;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyTypeCheckerInspection;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyTypeCheckerInspectionProblemRegistrar {
    PyTypeCheckerInspectionProblemRegistrar() {
    }

    static void registerProblem(@NotNull PyInspectionVisitor visitor, @NotNull PyCallSiteExpression callSite, @NotNull List<PyType> argumentTypes, @NotNull List<PyTypeCheckerInspection.AnalyzeCalleeResults> calleesResults, @NotNull TypeEvalContext context) {
        if (visitor == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(0);
        }
        if (callSite == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(1);
        }
        if (argumentTypes == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(2);
        }
        if (calleesResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(4);
        }
        if (calleesResults.size() == 1) {
            PyTypeCheckerInspectionProblemRegistrar.registerSingleCalleeProblem(visitor, callSite, calleesResults.get(0), context);
        } else if (!calleesResults.isEmpty()) {
            PyTypeCheckerInspectionProblemRegistrar.registerMultiCalleeProblem(visitor, callSite, argumentTypes, calleesResults, context);
        }
    }

    private static void registerSingleCalleeProblem(@NotNull PyInspectionVisitor visitor, @NotNull PyCallSiteExpression callSite, @NotNull PyTypeCheckerInspection.AnalyzeCalleeResults calleeResults, @NotNull TypeEvalContext context) {
        PsiElement rpar;
        PyArgumentList argumentList;
        if (visitor == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(5);
        }
        if (callSite == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(6);
        }
        if (calleeResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(8);
        }
        for (PyTypeCheckerInspection.AnalyzeArgumentResult argumentResult : calleeResults.getResults()) {
            if (argumentResult.isMatched()) continue;
            visitor.registerProblem((PsiElement)argumentResult.getArgument(), PyTypeCheckerInspectionProblemRegistrar.getSingleCalleeProblemMessage(argumentResult, context));
        }
        for (PyTypeCheckerInspection.UnexpectedArgumentForParamSpec unexpectedArgumentForParamSpec : calleeResults.getUnmatchedArguments()) {
            PyExpression argument = unexpectedArgumentForParamSpec.getArgument();
            String string = unexpectedArgumentForParamSpec.getParamSpecType().getVariableName();
            visitor.registerProblem((PsiElement)argument, PyPsiBundle.message("INSP.type.checker.unexpected.argument.from.paramspec", string));
        }
        if (callSite instanceof PyCallExpression && (argumentList = ((PyCallExpression)callSite).getArgumentList()) != null && (rpar = PyPsiUtils.getFirstChildOfType((PsiElement)argumentList, (PyElementType)PyTokenTypes.RPAR)) != null) {
            for (PyTypeCheckerInspection.UnfilledParameterFromParamSpec unfilledParameterFromParamSpec : calleeResults.getUnmatchedParameters()) {
                String parameterName = unfilledParameterFromParamSpec.getParameter().getName();
                String paramSpecTypeName = unfilledParameterFromParamSpec.getParamSpecType().getVariableName();
                if (parameterName == null) continue;
                visitor.registerProblem(rpar, PyPsiBundle.message("INSP.type.checker.unfilled.parameter.for.paramspec", parameterName, paramSpecTypeName));
            }
            for (PyTypeCheckerInspection.UnfilledPositionalVararg unfilledPositionalVararg : calleeResults.getUnfilledPositionalVarargs()) {
                String varargName = unfilledPositionalVararg.varargName();
                String expectedTypes = unfilledPositionalVararg.expectedTypes();
                visitor.registerProblem(rpar, PyPsiBundle.message("INSP.type.checker.unfilled.vararg", varargName, expectedTypes));
            }
        }
    }

    private static void registerMultiCalleeProblem(@NotNull PyInspectionVisitor visitor, @NotNull PyCallSiteExpression callSite, @NotNull List<PyType> argumentTypes, @NotNull List<PyTypeCheckerInspection.AnalyzeCalleeResults> calleesResults, @NotNull TypeEvalContext context) {
        if (visitor == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(9);
        }
        if (callSite == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(10);
        }
        if (argumentTypes == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(11);
        }
        if (calleesResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(13);
        }
        if (callSite instanceof PyBinaryExpression) {
            PyTypeCheckerInspectionProblemRegistrar.registerMultiCalleeProblemForBinaryExpression(visitor, (PyBinaryExpression)callSite, argumentTypes, calleesResults, context);
        } else {
            visitor.registerProblem(PyTypeCheckerInspectionProblemRegistrar.getMultiCalleeElementToHighlight(callSite), PyTypeCheckerInspectionProblemRegistrar.getMultiCalleeProblemMessage(argumentTypes, calleesResults, context, PyTypeCheckerInspectionProblemRegistrar.isOnTheFly(visitor)));
        }
    }

    @NotNull
    @InspectionMessage
    private static String getSingleCalleeProblemMessage(@NotNull PyTypeCheckerInspection.AnalyzeArgumentResult argumentResult, @NotNull TypeEvalContext context) {
        String expectedSubstitutedName;
        if (argumentResult == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(15);
        }
        PyType actualType = argumentResult.getActualType();
        PyType expectedType = argumentResult.getExpectedType();
        assert (actualType != null);
        assert (expectedType != null);
        String actualTypeName = PythonDocumentationProvider.getTypeName(actualType, context);
        if (expectedType instanceof PyStructuralType) {
            Set<String> expectedAttributes = ((PyStructuralType)expectedType).getAttributeNames();
            Set<String> actualAttributes = PyTypeCheckerInspectionProblemRegistrar.getAttributes(actualType, context);
            if (actualAttributes != null) {
                Sets.SetView missingAttributes = Sets.difference(expectedAttributes, actualAttributes);
                String missingAttributeList = StringUtil.join((Collection)missingAttributes, s -> String.format("'%s'", s), (String)", ");
                String string = PyPsiBundle.message("INSP.type.checker.type.does.not.have.expected.attribute", actualTypeName, missingAttributes.size(), missingAttributeList);
                if (string == null) {
                    PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(16);
                }
                return string;
            }
        }
        @Nullable PyType expectedTypeAfterSubstitution = argumentResult.getExpectedTypeAfterSubstitution();
        String expectedTypeName = PythonDocumentationProvider.getVerboseTypeName(expectedType, context);
        String string = expectedSubstitutedName = expectedTypeAfterSubstitution != null && !expectedTypeAfterSubstitution.equals((Object)expectedType) ? PythonDocumentationProvider.getTypeName(expectedTypeAfterSubstitution, context) : null;
        if (PyProtocolsKt.matchingProtocolDefinitions(expectedType, actualType, context)) {
            if (expectedSubstitutedName != null) {
                String string2 = PyPsiBundle.message("INSP.type.checker.only.concrete.class.can.be.used.where.matched.protocol.expected", expectedSubstitutedName, expectedTypeName);
                if (string2 == null) {
                    PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(17);
                }
                return string2;
            }
            String string3 = PyPsiBundle.message("INSP.type.checker.only.concrete.class.can.be.used.where.protocol.expected", expectedTypeName);
            if (string3 == null) {
                PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(18);
            }
            return string3;
        }
        if (expectedSubstitutedName != null) {
            String string4 = PyPsiBundle.message("INSP.type.checker.expected.matched.type.got.type.instead", expectedSubstitutedName, expectedTypeName, actualTypeName);
            if (string4 == null) {
                PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(19);
            }
            return string4;
        }
        String string5 = PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", expectedTypeName, actualTypeName);
        if (string5 == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(20);
        }
        return string5;
    }

    private static void registerMultiCalleeProblemForBinaryExpression(@NotNull PyInspectionVisitor visitor, @NotNull PyBinaryExpression binaryExpression, @NotNull List<PyType> argumentTypes, @NotNull List<PyTypeCheckerInspection.AnalyzeCalleeResults> calleesResults, @NotNull TypeEvalContext context) {
        List preferredOperatorsResults;
        if (visitor == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(21);
        }
        if (binaryExpression == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(22);
        }
        if (argumentTypes == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(23);
        }
        if (calleesResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(25);
        }
        Predicate<PyTypeCheckerInspection.AnalyzeCalleeResults> isRightOperatorResults = calleeResults -> binaryExpression.isRightOperator((PyAstCallable)calleeResults.getCallable());
        boolean allCalleesAreRightOperators = calleesResults.stream().allMatch(isRightOperatorResults);
        List list = preferredOperatorsResults = allCalleesAreRightOperators ? calleesResults : ContainerUtil.filter(calleesResults, calleeResults -> !isRightOperatorResults.test((PyTypeCheckerInspection.AnalyzeCalleeResults)calleeResults));
        if (preferredOperatorsResults.size() == 1) {
            PyTypeCheckerInspectionProblemRegistrar.registerSingleCalleeProblem(visitor, (PyCallSiteExpression)binaryExpression, (PyTypeCheckerInspection.AnalyzeCalleeResults)preferredOperatorsResults.get(0), context);
        } else {
            visitor.registerProblem((PsiElement)(allCalleesAreRightOperators ? binaryExpression.getLeftExpression() : binaryExpression.getRightExpression()), PyTypeCheckerInspectionProblemRegistrar.getMultiCalleeProblemMessage(argumentTypes, preferredOperatorsResults, context, PyTypeCheckerInspectionProblemRegistrar.isOnTheFly(visitor)));
        }
    }

    @NotNull
    private static PsiElement getMultiCalleeElementToHighlight(@NotNull PyCallSiteExpression callSite) {
        if (callSite == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(26);
        }
        if (callSite instanceof PyCallExpression) {
            PyCallExpression call = (PyCallExpression)callSite;
            PyArgumentList argumentList = call.getArgumentList();
            PsiElement result = Optional.ofNullable(argumentList).map(PyArgumentList::getArguments).filter(arguments -> ((PyExpression[])arguments).length == 1).map(arguments -> arguments[0]).orElse((PsiElement)argumentList);
            PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)result, (Object)callSite);
            if (psiElement == null) {
                PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(27);
            }
            return psiElement;
        }
        if (callSite instanceof PySubscriptionExpression) {
            PsiElement psiElement = (PsiElement)ObjectUtils.notNull((Object)((PySubscriptionExpression)callSite).getIndexExpression(), (Object)callSite);
            if (psiElement == null) {
                PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(28);
            }
            return psiElement;
        }
        PyCallSiteExpression pyCallSiteExpression = callSite;
        if (pyCallSiteExpression == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(29);
        }
        return pyCallSiteExpression;
    }

    @NotNull
    @InspectionMessage
    private static String getMultiCalleeProblemMessage(@NotNull List<PyType> argumentTypes, @NotNull List<PyTypeCheckerInspection.AnalyzeCalleeResults> calleesResults, @NotNull TypeEvalContext context, boolean isOnTheFly) {
        if (argumentTypes == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(30);
        }
        if (calleesResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(32);
        }
        String actualTypesRepresentation = PyTypeCheckerInspectionProblemRegistrar.getMultiCalleeActualTypesRepresentation(argumentTypes, context);
        String expectedTypesRepresentation = PyTypeCheckerInspectionProblemRegistrar.getMultiCalleePossibleExpectedTypesRepresentation(calleesResults, context, isOnTheFly);
        if (isOnTheFly) {
            String string = new HtmlBuilder().append(PyPsiBundle.message("INSP.type.checker.unexpected.types.prefix", new Object[0])).br().appendRaw(actualTypesRepresentation).br().append(PyPsiBundle.message("INSP.type.checker.expected.types.prefix", new Object[0])).br().appendRaw(expectedTypesRepresentation).wrapWith("html").toString();
            if (string == null) {
                PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = PyPsiBundle.message("INSP.type.checker.unexpected.types.prefix", new Object[0]) + " " + actualTypesRepresentation + " " + PyPsiBundle.message("INSP.type.checker.expected.types.prefix", new Object[0]) + " " + expectedTypesRepresentation;
        if (string == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(34);
        }
        return string;
    }

    private static boolean isOnTheFly(@NotNull PyInspectionVisitor visitor) {
        ProblemsHolder holder;
        if (visitor == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(35);
        }
        return (holder = visitor.getHolder()) != null && holder.isOnTheFly();
    }

    @Nullable
    private static Set<String> getAttributes(@NotNull PyType type, @NotNull TypeEvalContext context) {
        if (type == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(37);
        }
        if (type instanceof PyStructuralType) {
            return ((PyStructuralType)type).getAttributeNames();
        }
        if (type instanceof PyClassLikeType) {
            return ((PyClassLikeType)type).getMemberNames(true, context);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    private static String getMultiCalleeActualTypesRepresentation(@NotNull List<PyType> argumentTypes, @NotNull TypeEvalContext context) {
        if (argumentTypes == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(38);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(39);
        }
        String string = argumentTypes.stream().map(type -> PythonDocumentationProvider.getTypeName(type, context)).collect(Collectors.joining(", ", "(", ")"));
        if (string == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String getMultiCalleePossibleExpectedTypesRepresentation(@NotNull List<PyTypeCheckerInspection.AnalyzeCalleeResults> calleesResults, @NotNull TypeEvalContext context, boolean isOnTheFly) {
        if (calleesResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(41);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(42);
        }
        String string = calleesResults.stream().map(calleeResult -> {
            String expectedTypesRepresentation = PyTypeCheckerInspectionProblemRegistrar.getMultiCalleeExpectedTypesRepresentation(calleeResult.getResults(), context);
            return isOnTheFly ? XmlStringUtil.escapeString((String)expectedTypesRepresentation) : expectedTypesRepresentation;
        }).collect(Collectors.joining(isOnTheFly ? "<br>" : " "));
        if (string == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    private static String getMultiCalleeExpectedTypesRepresentation(@NotNull List<PyTypeCheckerInspection.AnalyzeArgumentResult> calleeResults, @NotNull TypeEvalContext context) {
        if (calleeResults == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(44);
        }
        if (context == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(45);
        }
        String string = calleeResults.stream().map(argumentResult -> (PyType)ObjectUtils.chooseNotNull((Object)argumentResult.getExpectedTypeAfterSubstitution(), (Object)argumentResult.getExpectedType())).map(type -> PythonDocumentationProvider.getTypeName(type, context)).collect(Collectors.joining(", ", "(", ")"));
        if (string == null) {
            PyTypeCheckerInspectionProblemRegistrar.$$$reportNull$$$0(46);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17, 18, 19, 20, 27, 28, 29, 33, 34, 40, 43, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 2: 
            case 11: 
            case 23: 
            case 30: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 3: 
            case 12: 
            case 24: 
            case 31: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleesResults";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 15: 
            case 25: 
            case 32: 
            case 37: 
            case 39: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeResults";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentResult";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 40: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyTypeCheckerInspectionProblemRegistrar";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyTypeCheckerInspectionProblemRegistrar";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleCalleeProblemMessage";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCalleeElementToHighlight";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCalleeProblemMessage";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCalleeActualTypesRepresentation";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCalleePossibleExpectedTypesRepresentation";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultiCalleeExpectedTypesRepresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerSingleCalleeProblem";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerMultiCalleeProblem";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSingleCalleeProblemMessage";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 40: 
            case 43: 
            case 46: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "registerMultiCalleeProblemForBinaryExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMultiCalleeElementToHighlight";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMultiCalleeProblemMessage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isOnTheFly";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getMultiCalleeActualTypesRepresentation";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getMultiCalleePossibleExpectedTypesRepresentation";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMultiCalleeExpectedTypesRepresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17, 18, 19, 20, 27, 28, 29, 33, 34, 40, 43, 46 -> new IllegalStateException(string);
        };
    }
}

