/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiListLikeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.FunctionParameter;
import com.jetbrains.python.NotNullPredicate;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.impl.PyElementGeneratorImpl;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyArgumentListImpl
extends PyElementImpl
implements PyArgumentList,
PsiListLikeElement {
    private static final NoKeyArguments NO_KEY_ARGUMENTS = new NoKeyArguments();

    public PyArgumentListImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyArgumentList((PyArgumentList)this);
    }

    public void addArgument(@NotNull PyExpression arg) {
        if (arg == null) {
            PyArgumentListImpl.$$$reportNull$$$0(0);
        }
        PyElementGeneratorImpl generator = new PyElementGeneratorImpl(this.getProject());
        Deque<PyKeywordArgument> keywordArguments = this.getKeyWordArguments();
        Deque<PyExpression> parameters = this.getParameters();
        if (keywordArguments.isEmpty() && parameters.isEmpty()) {
            generator.insertItemIntoListRemoveRedundantCommas(this, null, arg);
            return;
        }
        if (arg instanceof PyKeywordArgument) {
            if (parameters.isEmpty()) {
                generator.insertItemIntoListRemoveRedundantCommas(this, (PyExpression)keywordArguments.getLast(), arg);
            } else if (keywordArguments.isEmpty()) {
                generator.insertItemIntoListRemoveRedundantCommas(this, parameters.getLast(), arg);
            } else {
                generator.insertItemIntoListRemoveRedundantCommas(this, (PyExpression)keywordArguments.getLast(), arg);
            }
        } else if (parameters.isEmpty()) {
            generator.insertItemIntoListRemoveRedundantCommas(this, null, arg);
        } else {
            generator.insertItemIntoListRemoveRedundantCommas(this, parameters.getLast(), arg);
        }
    }

    @NotNull
    private Deque<PyExpression> getParameters() {
        PyExpression[] childrenOfType = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PyExpression.class);
        if (childrenOfType == null) {
            return new ArrayDeque<PyExpression>(0);
        }
        ArrayDeque arrayDeque = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(childrenOfType), (Predicate)NO_KEY_ARGUMENTS));
        if (arrayDeque == null) {
            PyArgumentListImpl.$$$reportNull$$$0(1);
        }
        return arrayDeque;
    }

    @NotNull
    private Deque<PyKeywordArgument> getKeyWordArguments() {
        ArrayDeque arrayDeque = Queues.newArrayDeque((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)this, PyKeywordArgument.class));
        if (arrayDeque == null) {
            PyArgumentListImpl.$$$reportNull$$$0(2);
        }
        return arrayDeque;
    }

    public void addArgumentFirst(PyExpression arg) {
        ASTNode node = this.getNode();
        ASTNode[] pars = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LPAR}));
        if (pars.length == 0) {
            try {
                this.add((PsiElement)arg);
            }
            catch (IncorrectOperationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            ASTNode anchorBefore;
            ASTNode before = PyPsiUtils.getNextNonWhitespaceSibling((ASTNode)pars[0]);
            if (before != null && PyArgumentListImpl.elementPrecedesElementsOfType(before, PythonDialectsTokenSetProvider.getInstance().getExpressionTokens())) {
                ASTNode comma = this.createComma();
                node.addChild(comma, before);
                node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), before);
                anchorBefore = comma;
            } else {
                anchorBefore = before;
            }
            ASTNode argNode = arg.getNode();
            if (anchorBefore == null) {
                node.addChild(argNode);
            } else {
                node.addChild(argNode, anchorBefore);
            }
        }
    }

    @NotNull
    private ASTNode createComma() {
        ASTNode aSTNode = PyElementGenerator.getInstance((Project)this.getProject()).createComma();
        if (aSTNode == null) {
            PyArgumentListImpl.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    private static boolean elementPrecedesElementsOfType(ASTNode before, TokenSet expressions) {
        for (ASTNode node = before; node != null; node = node.getTreeNext()) {
            if (!expressions.contains(node.getElementType())) continue;
            return true;
        }
        return false;
    }

    private void addArgumentLastWithoutComma(PyExpression arg) {
        ASTNode par = this.getClosingParen();
        if (par == null) {
            try {
                this.add((PsiElement)arg);
            }
            catch (IncorrectOperationException e1) {
                throw new IllegalStateException(e1);
            }
        } else {
            this.getNode().addChild(arg.getNode(), par);
        }
    }

    private void addArgumentNode(PyExpression arg, ASTNode beforeThis, boolean commaFirst) {
        ASTNode comma = PyElementGenerator.getInstance((Project)this.getProject()).createComma();
        ASTNode node = this.getNode();
        ASTNode argNode = arg.getNode();
        if (commaFirst) {
            node.addChild(comma, beforeThis);
            node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), beforeThis);
            node.addChild(argNode, beforeThis);
        } else {
            node.addChild(argNode, beforeThis);
            node.addChild(comma, beforeThis);
            node.addChild((ASTNode)ASTFactory.whitespace((CharSequence)" "), beforeThis);
        }
    }

    public void addArgumentAfter(PyExpression argument, @Nullable PyExpression afterThis) {
        if (afterThis == null) {
            this.addArgumentFirst(argument);
            return;
        }
        boolean good = false;
        for (PyExpression expression : this.getArguments()) {
            if (expression != afterThis) continue;
            good = true;
            break;
        }
        if (!good) {
            throw new IllegalArgumentException("Expression " + String.valueOf(afterThis) + " is not an argument (" + Arrays.toString(this.getArguments()) + ")");
        }
        for (ASTNode node = afterThis.getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            IElementType type = node.getElementType();
            if (type == PyTokenTypes.RPAR) {
                this.addArgumentNode(argument, node, true);
                break;
            }
            if (PythonDialectsTokenSetProvider.getInstance().getExpressionTokens().contains(type)) {
                this.addArgumentNode(argument, node, true);
                break;
            }
            if (type != PyTokenTypes.COMMA) continue;
            ASTNode next = PyPsiUtils.getNextNonWhitespaceSibling((ASTNode)node);
            if (next == null) {
                this.addArgumentLastWithoutComma(argument);
                break;
            }
            if (next.getElementType() == PyTokenTypes.RPAR) {
                this.addArgumentNode(argument, next, false);
                break;
            }
            this.addArgumentNode(argument, next, false);
            break;
        }
    }

    public void deleteChildInternal(@NotNull ASTNode node) {
        if (node == null) {
            PyArgumentListImpl.$$$reportNull$$$0(4);
        }
        if (ArrayUtil.contains((Object)node.getPsi(), (Object[])this.getArguments())) {
            PyPsiUtils.deleteAdjacentCommaWithWhitespaces((PsiElement)this, (PsiElement)node.getPsi());
        }
        super.deleteChildInternal(node);
    }

    @Nullable
    public PyExpression getValueExpressionForParam(@NotNull FunctionParameter parameter) {
        PyKeywordArgument kwarg;
        String parameterName;
        if (parameter == null) {
            PyArgumentListImpl.$$$reportNull$$$0(5);
        }
        if ((parameterName = parameter.getName()) != null && (kwarg = this.getKeywordArgument(parameterName)) != null) {
            return kwarg.getValueExpression();
        }
        PyExpression[] arguments = this.getArguments();
        int position = parameter.getPosition();
        if (position != -1 && arguments.length > position) {
            PyExpression result = arguments[position];
            if (result instanceof PyKeywordArgument) {
                ((PyKeywordArgument)result).getValueExpression();
            } else {
                return result;
            }
        }
        return null;
    }

    @NotNull
    public List<? extends PsiElement> getComponents() {
        List<PyExpression> list = Arrays.asList(this.getArguments());
        if (list == null) {
            PyArgumentListImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyArgumentListImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyArgumentListImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyWordArguments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComma";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addArgument";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValueExpressionForParam";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6 -> new IllegalStateException(string);
        };
    }

    private static class NoKeyArguments
    extends NotNullPredicate<PyExpression> {
        private NoKeyArguments() {
        }

        @Override
        protected boolean applyNotNull(@NotNull PyExpression input) {
            if (input == null) {
                NoKeyArguments.$$$reportNull$$$0(0);
            }
            return PsiTreeUtil.getParentOfType((PsiElement)input, PyKeywordArgument.class) == null && !(input instanceof PyKeywordArgument);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyArgumentListImpl$NoKeyArguments", "applyNotNull"));
        }
    }
}

