/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Queues;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.NotNullPredicate;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyEllipsisLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySlashParameter;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.StringLiteralExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Formatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyElementGeneratorImpl
extends PyElementGenerator {
    private static final CommasOnly COMMAS_ONLY = new CommasOnly();
    static int[] PATH_PARAMETER = new int[]{0, 3, 1};

    public PyElementGeneratorImpl(Project project) {
        super(project);
    }

    public ASTNode createNameIdentifier(String name, LanguageLevel languageLevel) {
        PsiFile dummyFile = this.createDummyFile(languageLevel, name);
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        PyReferenceExpression refExpression = (PyReferenceExpression)expressionStatement.getFirstChild();
        return refExpression.getNode().getFirstChildNode();
    }

    public PyStringLiteralExpression createStringLiteralAlreadyEscaped(String str) {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a=(" + str + ")");
        PyAssignmentStatement expressionStatement = (PyAssignmentStatement)dummyFile.getFirstChild();
        PyExpression assignedValue = expressionStatement.getAssignedValue();
        if (assignedValue != null) {
            return (PyStringLiteralExpression)((PyParenthesizedExpression)assignedValue).getContainedExpression();
        }
        return this.createStringLiteralFromString(str);
    }

    public PyStringLiteralExpression createStringLiteralFromString(@NotNull String unescaped) {
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(0);
        }
        return this.createStringLiteralFromString(null, unescaped, true, true);
    }

    public PyStringLiteralExpression createStringLiteral(@NotNull StringLiteralExpression oldElement, @NotNull String unescaped) {
        Pair quotes;
        if (oldElement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(1);
        }
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(2);
        }
        if ((quotes = PyStringLiteralCoreUtil.getQuotes((String)oldElement.getText())) != null) {
            return this.createStringLiteralAlreadyEscaped((String)quotes.first + unescaped + (String)quotes.second);
        }
        return this.createStringLiteralFromString(unescaped);
    }

    protected PyStringLiteralExpression createStringLiteralFromString(@Nullable PsiFile destination, @NotNull String unescaped, boolean preferUTF8, boolean preferDoubleQuotes) {
        VirtualFile vfile;
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(3);
        }
        boolean useDouble = !unescaped.contains("\"") && preferDoubleQuotes || unescaped.contains("'");
        boolean useMulti = unescaped.matches(".*(\r|\n).*");
        String quotes = useMulti ? (useDouble ? "\"\"\"" : "'''") : (useDouble ? "\"" : "'");
        StringBuilder buf = new StringBuilder(unescaped.length() * 2);
        buf.append(quotes);
        VirtualFile virtualFile = vfile = destination == null ? null : destination.getVirtualFile();
        Charset charset = vfile == null ? (preferUTF8 ? StandardCharsets.UTF_8 : StandardCharsets.US_ASCII) : vfile.getCharset();
        CharsetEncoder encoder = charset.newEncoder();
        Formatter formatter = new Formatter(buf);
        boolean unicode = false;
        for (int i = 0; i < unescaped.length(); ++i) {
            int c = unescaped.codePointAt(i);
            if (c == 34 && useDouble) {
                buf.append("\\\"");
                continue;
            }
            if (c == 39 && !useDouble) {
                buf.append("\\'");
                continue;
            }
            if (!(c != 13 && c != 10 || useMulti)) {
                buf.append(c == 13 ? "\\r" : "\\n");
                continue;
            }
            if (!encoder.canEncode(new String(Character.toChars(c)))) {
                if (c <= 255) {
                    formatter.format("\\x%02x", c);
                    continue;
                }
                if (c < 65535) {
                    unicode = true;
                    formatter.format("\\u%04x", c);
                    continue;
                }
                unicode = true;
                formatter.format("\\U%08x", c);
                continue;
            }
            buf.appendCodePoint(c);
        }
        buf.append(quotes);
        if (unicode) {
            buf.insert(0, "u");
        }
        return this.createStringLiteralAlreadyEscaped(buf.toString());
    }

    public PyStringLiteralExpression createStringLiteralFromString(@NotNull String unescaped, boolean preferDoubleQuotes) {
        if (unescaped == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(4);
        }
        return this.createStringLiteralFromString(null, unescaped, true, preferDoubleQuotes);
    }

    public PyListLiteralExpression createListLiteral() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "[]");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        return (PyListLiteralExpression)expressionStatement.getFirstChild();
    }

    public ASTNode createDot() {
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a.b");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        ASTNode dot = expressionStatement.getFirstChild().getNode().getFirstChildNode().getTreeNext();
        return dot.copyElement();
    }

    @NotNull
    public PsiElement insertItemIntoListRemoveRedundantCommas(@NotNull PyElement list, @Nullable PyExpression afterThis, @NotNull PyExpression toInsert) {
        LeafPsiElement lastComma;
        ArrayDeque commas;
        if (list == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(5);
        }
        if (toInsert == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(6);
        }
        PsiElement result = this.insertItemIntoList(list, afterThis, toInsert);
        LeafPsiElement[] leafs = (LeafPsiElement[])PsiTreeUtil.getChildrenOfType((PsiElement)list, LeafPsiElement.class);
        if (leafs != null && !(commas = Queues.newArrayDeque((Iterable)Collections2.filter(Arrays.asList(leafs), (Predicate)COMMAS_ONLY))).isEmpty() && PsiTreeUtil.getNextSiblingOfType((PsiElement)(lastComma = (LeafPsiElement)commas.getLast()), PyExpression.class) == null) {
            lastComma.delete();
        }
        PsiElement psiElement = result;
        if (psiElement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    public PsiElement insertItemIntoList(PyElement list, @Nullable PyExpression afterThis, PyExpression toInsert) throws IncorrectOperationException {
        ASTNode add = toInsert.getNode().copyElement();
        if (afterThis == null) {
            ASTNode exprNode = list.getNode();
            ASTNode[] closingTokens = exprNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.LBRACKET, PyTokenTypes.LPAR}));
            if (closingTokens.length == 0) {
                exprNode.addChild(add);
            } else {
                ASTNode next = PyPsiUtils.getNextNonWhitespaceSibling((ASTNode)closingTokens[closingTokens.length - 1]);
                if (next != null) {
                    ASTNode comma = this.createComma();
                    exprNode.addChild(comma, next);
                    exprNode.addChild(add, comma);
                } else {
                    exprNode.addChild(add);
                }
            }
        } else {
            ASTNode lastArgNode = afterThis.getNode();
            ASTNode comma = this.createComma();
            ASTNode parent = lastArgNode.getTreeParent();
            ASTNode afterLast = lastArgNode.getTreeNext();
            if (afterLast == null) {
                parent.addChild(add);
            } else {
                parent.addChild(add, afterLast);
            }
            parent.addChild(comma, add);
        }
        return add.getPsi();
    }

    public PyBinaryExpression createBinaryExpression(@NotNull String operator, @NotNull PyExpression leftOperand, @NotNull PyExpression rightOperand) {
        if (operator == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(8);
        }
        if (leftOperand == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(9);
        }
        if (rightOperand == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(10);
        }
        PsiFile dummyFile = this.createDummyFile(LanguageLevel.getDefault(), "a " + operator + " b");
        PyExpressionStatement expressionStatement = (PyExpressionStatement)dummyFile.getFirstChild();
        PyBinaryExpression binExpr = (PyBinaryExpression)expressionStatement.getExpression();
        ASTNode binnode = binExpr.getNode();
        binnode.replaceChild(binExpr.getLeftExpression().getNode(), leftOperand.getNode().copyElement());
        binnode.replaceChild(binExpr.getRightExpression().getNode(), rightOperand.getNode().copyElement());
        return binExpr;
    }

    @NotNull
    public PyPattern createPatternFromText(@NotNull LanguageLevel languageLevel, @NotNull String text) throws IncorrectOperationException {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(11);
        }
        if (text == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(12);
        }
        String matchStatement = "match x:\n    case C(" + text + "):\n        pass ";
        int[] pathToAttrPattern = new int[]{0, 5, 2, 1, 1};
        PyPattern pyPattern = (PyPattern)this.createFromText(languageLevel, PyPattern.class, matchStatement, pathToAttrPattern);
        if (pyPattern == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(13);
        }
        return pyPattern;
    }

    @NotNull
    public PyCallExpression createCallExpression(LanguageLevel langLevel, String functionName) {
        PsiElement element;
        PsiFile dummyFile = this.createDummyFile(langLevel, functionName + "()");
        PsiElement child = dummyFile.getFirstChild();
        if (child != null && (element = child.getFirstChild()) instanceof PyCallExpression) {
            PyCallExpression pyCallExpression = (PyCallExpression)element;
            if (pyCallExpression == null) {
                PyElementGeneratorImpl.$$$reportNull$$$0(14);
            }
            return pyCallExpression;
        }
        throw new IllegalArgumentException("Invalid call expression text " + functionName);
    }

    public PyImportElement createImportElement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(15);
        }
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(16);
        }
        String importStatement = "from foo import " + name + (String)(alias != null ? " as " + alias : "");
        return (PyImportElement)this.createFromText(languageLevel, PyImportElement.class, importStatement, new int[]{0, 6});
    }

    public PyFunction createProperty(LanguageLevel languageLevel, String propertyName, String fieldName, AccessDirection accessDirection) {
        String propertyText = accessDirection == AccessDirection.DELETE ? "@" + propertyName + ".deleter\ndef " + propertyName + "(self):\n  del self." + fieldName : (accessDirection == AccessDirection.WRITE ? "@" + propertyName + ".setter\ndef " + propertyName + "(self, value):\n  self." + fieldName + " = value" : "@property\ndef " + propertyName + "(self):\n  return self." + fieldName);
        return (PyFunction)this.createFromText(languageLevel, PyFunction.class, propertyText);
    }

    public PyNamedParameter createParameter(@NotNull String name) {
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(17);
        }
        return this.createParameter(name, null, null, LanguageLevel.getDefault());
    }

    @NotNull
    public PyParameterList createParameterList(@NotNull LanguageLevel languageLevel, @NotNull String text) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(18);
        }
        if (text == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(19);
        }
        PyParameterList pyParameterList = (PyParameterList)this.createFromText(languageLevel, PyParameterList.class, "def f" + text + ": pass", new int[]{0, 3});
        if (pyParameterList == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(20);
        }
        return pyParameterList;
    }

    @NotNull
    public PyArgumentList createArgumentList(@NotNull LanguageLevel languageLevel, @NotNull String text) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(21);
        }
        if (text == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(22);
        }
        PyArgumentList pyArgumentList = (PyArgumentList)this.createFromText(languageLevel, PyArgumentList.class, "f" + text, new int[]{0, 0, 1});
        if (pyArgumentList == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(23);
        }
        return pyArgumentList;
    }

    public PyNamedParameter createParameter(@NotNull String name, @Nullable String defaultValue, @Nullable String annotation, @NotNull LanguageLevel languageLevel) {
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(24);
        }
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(25);
        }
        Object parameterText = name;
        if (annotation != null) {
            parameterText = (String)parameterText + ": " + annotation;
        }
        if (defaultValue != null) {
            parameterText = (String)parameterText + " = " + defaultValue;
        }
        return (PyNamedParameter)this.createFromText(languageLevel, PyNamedParameter.class, "def f(" + (String)parameterText + "): pass", PATH_PARAMETER);
    }

    public PyKeywordArgument createKeywordArgument(LanguageLevel languageLevel, String keyword, String value) {
        PyCallExpression callExpression = (PyCallExpression)this.createExpressionFromText(languageLevel, "foo(" + keyword + "=" + value + ")");
        return (PyKeywordArgument)callExpression.getArguments()[0];
    }

    @NotNull
    public PyDecoratorList createDecoratorList(String ... decoratorTexts) {
        if (decoratorTexts == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(26);
        }
        assert (decoratorTexts.length > 0);
        StringBuilder functionText = new StringBuilder();
        for (String decoText : decoratorTexts) {
            functionText.append(decoText).append("\n");
        }
        functionText.append("def foo():\n\tpass");
        PyFunction function = (PyFunction)this.createFromText(LanguageLevel.getDefault(), PyFunction.class, functionText.toString());
        PyDecoratorList decoratorList = function.getDecoratorList();
        assert (decoratorList != null);
        PyDecoratorList pyDecoratorList = decoratorList;
        if (pyDecoratorList == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(27);
        }
        return pyDecoratorList;
    }

    @NotNull
    public PsiElement createNewLine() {
        PsiElement psiElement = (PsiElement)this.createFromText(LanguageLevel.getDefault(), PsiWhiteSpace.class, " \n\n ");
        if (psiElement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    @NotNull
    public PyFromImportStatement createFromImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String qualifier, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(29);
        }
        if (qualifier == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(30);
        }
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(31);
        }
        Object asClause = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String statement = "from " + qualifier + " import " + name + (String)asClause;
        PyFromImportStatement pyFromImportStatement = (PyFromImportStatement)this.createFromText(languageLevel, PyFromImportStatement.class, statement);
        if (pyFromImportStatement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(32);
        }
        return pyFromImportStatement;
    }

    @NotNull
    public PyImportStatement createImportStatement(@NotNull LanguageLevel languageLevel, @NotNull String name, @Nullable String alias) {
        if (languageLevel == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(33);
        }
        if (name == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(34);
        }
        Object asClause = StringUtil.isNotEmpty((String)alias) ? " as " + alias : "";
        String statement = "import " + name + (String)asClause;
        PyImportStatement pyImportStatement = (PyImportStatement)this.createFromText(languageLevel, PyImportStatement.class, statement);
        if (pyImportStatement == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(35);
        }
        return pyImportStatement;
    }

    @NotNull
    public PyEllipsisLiteralExpression createEllipsis() {
        PyEllipsisLiteralExpression pyEllipsisLiteralExpression = (PyEllipsisLiteralExpression)this.createFromText(LanguageLevel.PYTHON30, PyEllipsisLiteralExpression.class, "...", new int[]{0, 0});
        if (pyEllipsisLiteralExpression == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(36);
        }
        return pyEllipsisLiteralExpression;
    }

    @NotNull
    public PySingleStarParameter createSingleStarParameter() {
        PySingleStarParameter pySingleStarParameter = (PySingleStarParameter)this.createFromText(LanguageLevel.PYTHON30, PySingleStarParameter.class, "def foo(*): pass", new int[]{0, 3, 1});
        if (pySingleStarParameter == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(37);
        }
        return pySingleStarParameter;
    }

    @NotNull
    public PySlashParameter createSlashParameter() {
        PySlashParameter pySlashParameter = (PySlashParameter)this.createFromText(LanguageLevel.PYTHON30, PySlashParameter.class, "def foo(/): pass", new int[]{0, 3, 1});
        if (pySlashParameter == null) {
            PyElementGeneratorImpl.$$$reportNull$$$0(38);
        }
        return pySlashParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13, 14, 20, 23, 27, 28, 32, 35, 36, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unescaped";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toInsert";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyElementGeneratorImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 11: 
            case 15: 
            case 18: 
            case 21: 
            case 25: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 12: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: 
            case 17: 
            case 24: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorTexts";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyElementGeneratorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "insertItemIntoListRemoveRedundantCommas";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternFromText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCallExpression";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterList";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentList";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecoratorList";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createFromImportStatement";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportStatement";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createEllipsis";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSingleStarParameter";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createSlashParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteralFromString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStringLiteral";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertItemIntoListRemoveRedundantCommas";
                break;
            }
            case 7: 
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createPatternFromText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createImportElement";
                break;
            }
            case 17: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createParameter";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createParameterList";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentList";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createDecoratorList";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createFromImportStatement";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createImportStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13, 14, 20, 23, 27, 28, 32, 35, 36, 37, 38 -> new IllegalStateException(string);
        };
    }

    private static class CommasOnly
    extends NotNullPredicate<LeafPsiElement> {
        private CommasOnly() {
        }

        @Override
        protected boolean applyNotNull(@NotNull LeafPsiElement input) {
            if (input == null) {
                CommasOnly.$$$reportNull$$$0(0);
            }
            return input.getNode().getElementType().equals(PyTokenTypes.COMMA);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/psi/impl/PyElementGeneratorImpl$CommasOnly", "applyNotNull"));
        }
    }
}

