/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class PythonSdkPathCache
extends PythonPathCache
implements Disposable {
    private static final Key<Map<Project, PythonSdkPathCache>> KEY = Key.create((String)"PythonPathCache");
    private final Project myProject;
    private final Sdk mySdk;
    private final AtomicReference<PyBuiltinCache> myBuiltins;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonSdkPathCache getInstance(@NotNull Project project, @NotNull Sdk sdk) {
        if (project == null) {
            PythonSdkPathCache.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            PythonSdkPathCache.$$$reportNull$$$0(1);
        }
        Key<Map<Project, PythonSdkPathCache>> key = KEY;
        synchronized (key) {
            PythonSdkPathCache cache;
            WeakHashMap<Project, PythonSdkPathCache> cacheMap = (WeakHashMap<Project, PythonSdkPathCache>)sdk.getUserData(KEY);
            if (cacheMap == null) {
                cacheMap = new WeakHashMap<Project, PythonSdkPathCache>();
                sdk.putUserData(KEY, cacheMap);
            }
            if ((cache = (PythonSdkPathCache)cacheMap.get(project)) == null) {
                cache = new PythonSdkPathCache(project, sdk);
                cacheMap.put(project, cache);
            }
            return cache;
        }
    }

    public PythonSdkPathCache(@NotNull Project project, final @NotNull Sdk sdk) {
        if (project == null) {
            PythonSdkPathCache.$$$reportNull$$$0(2);
        }
        if (sdk == null) {
            PythonSdkPathCache.$$$reportNull$$$0(3);
        }
        this.myBuiltins = new AtomicReference();
        this.myProject = project;
        this.mySdk = sdk;
        if (project.isDisposed()) {
            return;
        }
        Disposer.register((Disposable)PythonPluginDisposable.getInstance((Project)project), (Disposable)this);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)new ProjectJdkTable.Listener(){

            public void jdkRemoved(@NotNull Sdk jdk) {
                if (jdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (jdk == sdk) {
                    Disposer.dispose((Disposable)PythonSdkPathCache.this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdk", "com/jetbrains/python/psi/resolve/PythonSdkPathCache$1", "jdkRemoved"));
            }
        });
        connection.subscribe(PyPackageManager.PACKAGE_MANAGER_TOPIC, eventSdk -> {
            if (eventSdk == sdk) {
                this.clearCache();
            }
        });
        sdk.getRootProvider().addRootSetChangedListener(wrapper2 -> {
            this.clearCache();
            if (!project.isDisposed()) {
                Module[] modules;
                for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
                    PythonModulePathCache.getInstance(module).clearCache();
                }
            }
            this.myBuiltins.set(null);
        }, (Disposable)this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new PythonPathCache.MyVirtualFileListener(), (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.mySdk != null) {
            Key<Map<Project, PythonSdkPathCache>> key = KEY;
            synchronized (key) {
                Map cacheMap = (Map)this.mySdk.getUserData(KEY);
                if (cacheMap != null) {
                    cacheMap.remove(this.myProject);
                }
            }
        }
    }

    @NotNull
    public PyBuiltinCache getBuiltins() {
        PyBuiltinCache pyBuiltinCache;
        while ((pyBuiltinCache = this.myBuiltins.get()) == null || !pyBuiltinCache.isValid()) {
            PyBuiltinCache newCache = new PyBuiltinCache(this.myProject, this.mySdk);
            if (!this.myBuiltins.compareAndSet(pyBuiltinCache, newCache)) continue;
            PyBuiltinCache pyBuiltinCache2 = newCache;
            if (pyBuiltinCache2 == null) {
                PythonSdkPathCache.$$$reportNull$$$0(4);
            }
            return pyBuiltinCache2;
        }
        PyBuiltinCache pyBuiltinCache3 = pyBuiltinCache;
        if (pyBuiltinCache3 == null) {
            PythonSdkPathCache.$$$reportNull$$$0(5);
        }
        return pyBuiltinCache3;
    }

    public void clearBuiltins() {
        this.myBuiltins.set(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/resolve/PythonSdkPathCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/resolve/PythonSdkPathCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

