/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.extractmethod;

import com.intellij.codeInsight.codeFragment.CannotCreateCodeFragmentException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragmentUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.refactoring.extractmethod.PyExtractMethodUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExtractMethodHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PyExtractMethodHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            int caretOffset = editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(caretOffset);
            if (element != null) {
                PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (boolean)false, (Class[])new Class[]{PyCallExpression.class});
                if (callExpression != null) {
                    int startOffset = callExpression.getTextRange().getStartOffset();
                    int endOffset = callExpression.getTextRange().getEndOffset();
                    editor.getSelectionModel().setSelection(startOffset, endOffset);
                }
            } else {
                editor.getSelectionModel().selectLineAtCaret();
            }
        }
        PyExtractMethodHandler.invokeOnEditor(project, editor, file);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PyExtractMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PyExtractMethodHandler.$$$reportNull$$$0(2);
        }
    }

    private static void invokeOnEditor(Project project, Editor editor, PsiFile file) {
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        PsiElement element1 = null;
        PsiElement element2 = null;
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasSelection()) {
            element1 = file.findElementAt(selectionModel.getSelectionStart());
            element2 = file.findElementAt(selectionModel.getSelectionEnd() - 1);
        } else {
            CaretModel caretModel = editor.getCaretModel();
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(caretModel.getOffset());
            if (lineNumber >= 0 && lineNumber < document.getLineCount()) {
                element1 = file.findElementAt(document.getLineStartOffset(lineNumber));
                element2 = file.findElementAt(document.getLineEndOffset(lineNumber) - 1);
            }
        }
        element1 = PyPsiUtils.getNextSignificantLeaf((PsiElement)element1, (boolean)false);
        element2 = PyPsiUtils.getPrevSignificantLeaf((PsiElement)element2, (boolean)false);
        if (element1 == null || element2 == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.bad.selection", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return;
        }
        if (PyExtractMethodHandler.rangeBelongsToSameClassBody(element1, element2)) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.class.level", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
            return;
        }
        Couple<PsiElement> statements = PyExtractMethodHandler.getStatementsRange(element1, element2);
        if (statements != null) {
            PyCodeFragment fragment;
            ScopeOwner owner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)statements.getFirst()), ScopeOwner.class);
            if (owner == null) {
                return;
            }
            try {
                fragment = PyCodeFragmentUtil.createCodeFragment(owner, element1, element2, null);
            }
            catch (CannotCreateCodeFragmentException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
                return;
            }
            PyExtractMethodUtil.extractFromStatements(project, editor, fragment, (PsiElement)statements.getFirst(), (PsiElement)statements.getSecond());
            return;
        }
        PyExpression expression = PyRefactoringUtil.getSelectedExpression(project, file, element1, element2);
        if (expression != null) {
            PyCodeFragment fragment;
            ScopeOwner owner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element1, ScopeOwner.class);
            if (owner == null) {
                return;
            }
            try {
                fragment = PyCodeFragmentUtil.createCodeFragment(owner, element1, element2, (PsiElement)expression);
            }
            catch (CannotCreateCodeFragmentException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
                return;
            }
            PyExtractMethodUtil.extractFromExpression(project, editor, fragment, (PsiElement)expression);
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PyPsiBundle.message("refactoring.extract.method.error.bad.selection", new Object[0]), (String)RefactoringBundle.message((String)"extract.method.title"), (String)"refactoring.extractMethod");
    }

    private static boolean rangeBelongsToSameClassBody(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (element1 == null) {
            PyExtractMethodHandler.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            PyExtractMethodHandler.$$$reportNull$$$0(4);
        }
        PyClass firstScopeOwner = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element1, PyClass.class, (boolean)false, (Class[])new Class[]{ScopeOwner.class});
        PyClass secondScopeOwner = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element2, PyClass.class, (boolean)false, (Class[])new Class[]{ScopeOwner.class});
        return firstScopeOwner != null && firstScopeOwner == secondScopeOwner;
    }

    @Nullable
    private static Couple<PsiElement> getStatementsRange(PsiElement element1, PsiElement element2) {
        boolean isRightParen;
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            return null;
        }
        PyElement statementList = PyPsiUtils.getStatementList((PsiElement)parent);
        if (statementList == null) {
            return null;
        }
        PsiElement statement1 = PyPsiUtils.getParentRightBefore((PsiElement)element1, (PsiElement)statementList);
        PsiElement statement2 = PyPsiUtils.getParentRightBefore((PsiElement)element2, (PsiElement)statementList);
        if (statement1 == null || statement2 == null) {
            return null;
        }
        if (element1 == PsiTreeUtil.getDeepestFirst((PsiElement)statement1) && element2 == PyPsiUtils.getPrevSignificantLeaf((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)statement2), (!(element2 instanceof PsiComment) ? 1 : 0) != 0)) {
            return Couple.of((Object)statement1, (Object)statement2);
        }
        boolean isLeftParen = "(".equals(element2.getText());
        PsiElement prevSignificantLeaf = PyPsiUtils.getPrevSignificantLeaf((PsiElement)PsiTreeUtil.getDeepestLast((PsiElement)statement2), (!(statement2 instanceof PsiComment) ? 1 : 0) != 0);
        boolean bl = isRightParen = prevSignificantLeaf != null && ")".equals(prevSignificantLeaf.getText());
        if (isLeftParen && isRightParen) {
            return Couple.of((Object)statement1, (Object)statement2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/extractmethod/PyExtractMethodHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "rangeBelongsToSameClassBody";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

