/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.validation.PyAnnotationHolder;
import com.jetbrains.python.validation.PyImplicitAsyncContextProvider;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class PyAsyncAwaitAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    public PyAsyncAwaitAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    private static boolean isAsyncAllowed(ScopeOwner scopeOwner) {
        PyFunction pyFunction;
        if (scopeOwner instanceof PyFunction && (pyFunction = (PyFunction)scopeOwner).isAsync()) {
            return true;
        }
        for (PyImplicitAsyncContextProvider provider : PyImplicitAsyncContextProvider.EP_NAME.getExtensionList()) {
            if (!provider.isImplicitAsyncContext(scopeOwner)) continue;
            return true;
        }
        return false;
    }

    private void createError(@NotNull PsiElement node, ScopeOwner scopeOwner, @InspectionMessage @NotNull String message) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (message == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        AnnotationBuilder annotation = this.myHolder.newAnnotation(HighlightSeverity.ERROR, message).range(node);
        if (scopeOwner instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)scopeOwner;
            annotation = annotation.newFix((CommonIntentionAction)new ConvertIntoAsyncFunctionFix(pyFunction)).registerFix();
        }
        annotation.create();
    }

    private void checkComprehension(@NotNull PyComprehensionElement node) {
        ASTNode asyncNode;
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if ((asyncNode = node.getNode().findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)) == null) {
            return;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
        if (PyAsyncAwaitAnnotatorVisitor.isAsyncAllowed(scopeOwner)) {
            return;
        }
        this.createError((PsiElement)asyncNode, scopeOwner, PyPsiBundle.message("ANN.async.for.outside.function", new Object[0]));
    }

    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        super.visitPyPrefixExpression(node);
        if (node.getOperator() == PyTokenTypes.AWAIT_KEYWORD) {
            ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (PyAsyncAwaitAnnotatorVisitor.isAsyncAllowed(scopeOwner)) {
                return;
            }
            this.createError(node.getFirstChild(), scopeOwner, PyPsiBundle.message("ANN.await.outside.async.function", new Object[0]));
        }
    }

    public void visitPyForStatement(@NotNull PyForStatement node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        super.visitPyForStatement(node);
        if (!node.isAsync()) {
            return;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
        if (PyAsyncAwaitAnnotatorVisitor.isAsyncAllowed(scopeOwner)) {
            return;
        }
        this.createError(node.getFirstChild(), scopeOwner, PyPsiBundle.message("ANN.async.for.outside.function", new Object[0]));
    }

    public void visitPyWithStatement(@NotNull PyWithStatement node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        super.visitPyWithStatement(node);
        if (!node.isAsync()) {
            return;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node);
        if (PyAsyncAwaitAnnotatorVisitor.isAsyncAllowed(scopeOwner)) {
            return;
        }
        this.createError(node.getFirstChild(), scopeOwner, PyPsiBundle.message("ANN.async.with.outside.function", new Object[0]));
    }

    public void visitPyListCompExpression(@NotNull PyListCompExpression node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        super.visitPyListCompExpression(node);
        this.checkComprehension((PyComprehensionElement)node);
    }

    public void visitPyDictCompExpression(@NotNull PyDictCompExpression node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        super.visitPyDictCompExpression(node);
        this.checkComprehension((PyComprehensionElement)node);
    }

    public void visitPySetCompExpression(@NotNull PySetCompExpression node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        super.visitPySetCompExpression(node);
        this.checkComprehension((PyComprehensionElement)node);
    }

    public void visitPyFunction(@NotNull PyFunction node) {
        if (node == null) {
            PyAsyncAwaitAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        if (!node.isAsyncAllowed()) {
            Optional.ofNullable(node.getNode()).map(astNode -> astNode.findChildByType((IElementType)PyTokenTypes.ASYNC_KEYWORD)).ifPresent(asyncNode -> this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.function.cannot.be.async", node.getName())).range(asyncNode).create());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyAsyncAwaitAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createError";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkComprehension";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyPrefixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyForStatement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyWithStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyListCompExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyDictCompExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPySetCompExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyFunction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConvertIntoAsyncFunctionFix
    extends PsiUpdateModCommandAction<PyFunction> {
        protected ConvertIntoAsyncFunctionFix(@NotNull PyFunction element) {
            if (element == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PyFunction element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(3);
            }
            ASTNode defKeyword = element.getNode().findChildByType((IElementType)PyTokenTypes.DEF_KEYWORD);
            element.getNode().addLeaf((IElementType)PyTokenTypes.ASYNC_KEYWORD, (CharSequence)"async ", defKeyword);
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.convert.into.async.function", new Object[0]);
            if (string == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/PyAsyncAwaitAnnotatorVisitor$ConvertIntoAsyncFunctionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/PyAsyncAwaitAnnotatorVisitor$ConvertIntoAsyncFunctionFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

