/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.terminal.backend.TerminalDisplayListener;
import com.intellij.util.EventDispatcher;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.ui.settings.DefaultSettingsProvider;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 J\u0018\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J\u0012\u0010)\u001a\u00020$2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020\u001aH\u0016J\u0010\u0010.\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010/\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\nH\u0016J\b\u00102\u001a\u00020$H\u0016J\u0010\u00103\u001a\u00020$2\u0006\u00103\u001a\u00020\nH\u0016J \u00104\u001a\u00020$2\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007H\u0016J\n\u00108\u001a\u0004\u0018\u000109H\u0016J\b\u0010:\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\t\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR!\u0010\u001e\u001a\u0015\u0012\f\u0012\n !*\u0004\u0018\u00010 0 0\u001f\u00a2\u0006\u0002\b\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/terminal/backend/TerminalDisplayImpl;", "Lcom/jediterm/terminal/TerminalDisplay;", "settings", "Lcom/jediterm/terminal/ui/settings/DefaultSettingsProvider;", "<init>", "(Lcom/jediterm/terminal/ui/settings/DefaultSettingsProvider;)V", "cursorX", "", "cursorY", "value", "", "isCursorVisible", "()Z", "Lcom/jediterm/terminal/CursorShape;", "cursorShape", "getCursorShape", "()Lcom/jediterm/terminal/CursorShape;", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "mouseMode", "getMouseMode", "()Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "mouseFormat", "getMouseFormat", "()Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "isBracketedPasteMode", "", "windowTitleText", "getWindowTitleText", "()Ljava/lang/String;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/terminal/backend/TerminalDisplayListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addListener", "", "listener", "setCursor", "x", "y", "setCursorShape", "setCursorVisible", "getWindowTitle", "setWindowTitle", "windowTitle", "terminalMouseModeSet", "setMouseFormat", "setBracketedPasteMode", "bracketedPasteModeEnabled", "beep", "useAlternateScreenBuffer", "scrollArea", "scrollRegionTop", "scrollRegionSize", "dy", "getSelection", "Lcom/jediterm/terminal/model/TerminalSelection;", "ambiguousCharsAreDoubleWidth", "intellij.terminal.backend"})
@ApiStatus.Internal
public final class TerminalDisplayImpl
implements TerminalDisplay {
    @NotNull
    private final DefaultSettingsProvider settings;
    private int cursorX;
    private int cursorY;
    private boolean isCursorVisible;
    @Nullable
    private CursorShape cursorShape;
    @NotNull
    private MouseMode mouseMode;
    @NotNull
    private MouseFormat mouseFormat;
    private boolean isBracketedPasteMode;
    @NotNull
    private String windowTitleText;
    @NotNull
    private final EventDispatcher<TerminalDisplayListener> dispatcher;

    public TerminalDisplayImpl(@NotNull DefaultSettingsProvider settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.isCursorVisible = true;
        this.mouseMode = MouseMode.MOUSE_REPORTING_NONE;
        this.mouseFormat = MouseFormat.MOUSE_FORMAT_XTERM;
        this.windowTitleText = "";
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalDisplayListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.dispatcher = eventDispatcher2;
    }

    public final boolean isCursorVisible() {
        return this.isCursorVisible;
    }

    @Nullable
    public final CursorShape getCursorShape() {
        return this.cursorShape;
    }

    @NotNull
    public final MouseMode getMouseMode() {
        return this.mouseMode;
    }

    @NotNull
    public final MouseFormat getMouseFormat() {
        return this.mouseFormat;
    }

    public final boolean isBracketedPasteMode() {
        return this.isBracketedPasteMode;
    }

    @NotNull
    public final String getWindowTitleText() {
        return this.windowTitleText;
    }

    public final void addListener(@NotNull TerminalDisplayListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.dispatcher.addListener((EventListener)listener2);
    }

    public void setCursor(int x, int y) {
        int zeroBasedY = y - 1;
        if (x != this.cursorX || zeroBasedY != this.cursorY) {
            this.cursorX = x;
            this.cursorY = zeroBasedY;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).cursorPositionChanged(x, zeroBasedY);
        }
    }

    public void setCursorShape(@Nullable CursorShape cursorShape) {
        if (this.cursorShape != cursorShape) {
            this.cursorShape = cursorShape;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).cursorShapeChanged(cursorShape);
        }
    }

    public void setCursorVisible(boolean isCursorVisible) {
        if (this.isCursorVisible != isCursorVisible) {
            this.isCursorVisible = isCursorVisible;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).cursorVisibilityChanged(isCursorVisible);
        }
    }

    @Nullable
    public String getWindowTitle() {
        return this.windowTitleText;
    }

    public void setWindowTitle(@NotNull String windowTitle) {
        Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
        if (!Intrinsics.areEqual((Object)this.windowTitleText, (Object)windowTitle)) {
            this.windowTitleText = windowTitle;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).windowTitleChanged(windowTitle);
        }
    }

    public void terminalMouseModeSet(@NotNull MouseMode mouseMode) {
        Intrinsics.checkNotNullParameter((Object)mouseMode, (String)"mouseMode");
        if (this.mouseMode != mouseMode) {
            this.mouseMode = mouseMode;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).mouseModeChanged(mouseMode);
        }
    }

    public void setMouseFormat(@NotNull MouseFormat mouseFormat) {
        Intrinsics.checkNotNullParameter((Object)mouseFormat, (String)"mouseFormat");
        if (this.mouseFormat != mouseFormat) {
            this.mouseFormat = mouseFormat;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).mouseFormatChanged(mouseFormat);
        }
    }

    public void setBracketedPasteMode(boolean bracketedPasteModeEnabled) {
        if (this.isBracketedPasteMode != bracketedPasteModeEnabled) {
            this.isBracketedPasteMode = bracketedPasteModeEnabled;
            ((TerminalDisplayListener)this.dispatcher.getMulticaster()).bracketedPasteModeChanged(bracketedPasteModeEnabled);
        }
    }

    public void beep() {
        ((TerminalDisplayListener)this.dispatcher.getMulticaster()).beep();
    }

    public void useAlternateScreenBuffer(boolean useAlternateScreenBuffer) {
    }

    public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
    }

    @Nullable
    public TerminalSelection getSelection() {
        return null;
    }

    public boolean ambiguousCharsAreDoubleWidth() {
        return this.settings.ambiguousCharsAreDoubleWidth();
    }
}

