/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.toolwindow.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.frontend.toolwindow.impl.TerminalInternalUtilsKt;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"installDirectoryDnD", "", "window", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getDirectory", "Lcom/intellij/psi/PsiDirectory;", "item", "Lcom/intellij/psi/PsiElement;", "findNearestContentManager", "Lcom/intellij/ui/content/ContentManager;", "event", "Lcom/intellij/ide/dnd/DnDEvent;", "intellij.terminal.frontend"})
public final class TerminalDirectoryDnDKt {
    public static final void installDirectoryDnD(@NotNull ToolWindowEx window, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        DnDDropHandler handler = arg_0 -> TerminalDirectoryDnDKt.installDirectoryDnD$lambda$0(window, arg_0);
        DnDSupport.createBuilder((JComponent)((JComponent)window.getDecorator())).setDropHandler(handler).setDisposableParent(parentDisposable).disableAsSource().install();
    }

    private static final PsiDirectory getDirectory(PsiElement item) {
        if (item instanceof PsiFile) {
            return ((PsiFile)item).getParent();
        }
        return item instanceof PsiDirectory ? (PsiDirectory)item : null;
    }

    private static final ContentManager findNearestContentManager(DnDEvent event) {
        Component handlerComponent = event.getHandlerComponent();
        Point point = event.getPoint();
        if (handlerComponent == null || point == null) {
            return null;
        }
        Component component2 = UIUtil.getDeepestComponentAt((Component)handlerComponent, (int)point.x, (int)point.y);
        if (component2 == null) {
            return null;
        }
        Component deepestComponent = component2;
        DataContext dataContext = DataManager.getInstance().getDataContext(deepestComponent);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        return (ContentManager)dataContext2.getData(PlatformDataKeys.TOOL_WINDOW_CONTENT_MANAGER);
    }

    private static final void installDirectoryDnD$lambda$0(ToolWindowEx $window, DnDEvent event) {
        Object object = event.getAttachedObject();
        TransferableWrapper transferableWrapper = object instanceof TransferableWrapper ? (TransferableWrapper)object : null;
        if (transferableWrapper == null) {
            return;
        }
        TransferableWrapper tw = transferableWrapper;
        Object[] objectArray = tw.getPsiElements();
        PsiDirectory psiDirectory = TerminalDirectoryDnDKt.getDirectory((PsiElement)(objectArray != null ? (PsiElement)ArraysKt.singleOrNull((Object[])objectArray) : null));
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory dir = psiDirectory;
        Intrinsics.checkNotNull((Object)event);
        ContentManager nearestManager = TerminalDirectoryDnDKt.findNearestContentManager(event);
        Project project = $window.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TerminalInternalUtilsKt.createTerminalTab$default(project, null, dir.getVirtualFile().getPath(), null, nearestManager, null, 42, null);
    }
}

