/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.terminal.frontend.view.impl.TerminalOutputEventsHandler;
import com.intellij.terminal.frontend.view.impl.TerminalOutputModelController;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalAliasesStorage;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.session.impl.TerminalAliasesReceivedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalCommandFinishedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalCommandStartedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalInitialStateEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalOutputEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalPromptFinishedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalPromptStartedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalStateChangedEvent;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalBlocksModelStateDtoKt;
import org.jetbrains.plugins.terminal.util.TerminalCoroutineKt;
import org.jetbrains.plugins.terminal.view.shellIntegration.TerminalShellIntegration;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalBlocksModelImpl;
import org.jetbrains.plugins.terminal.view.shellIntegration.impl.TerminalShellIntegrationImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/terminal/frontend/view/impl/TerminalShellIntegrationEventsHandler;", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputEventsHandler;", "outputModelController", "Lcom/intellij/terminal/frontend/view/impl/TerminalOutputModelController;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "shellIntegrationDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/TerminalShellIntegration;", "aliasesStorage", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalAliasesStorage;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/terminal/frontend/view/impl/TerminalOutputModelController;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lkotlinx/coroutines/CompletableDeferred;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalAliasesStorage;Lkotlinx/coroutines/CoroutineScope;)V", "edtContext", "Lkotlin/coroutines/CoroutineContext;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalShellIntegrationImpl;", "getShellIntegration", "()Lorg/jetbrains/plugins/terminal/view/shellIntegration/impl/TerminalShellIntegrationImpl;", "getIntegrationOrThrow", "handleEvent", "", "event", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalOutputEvent;", "(Lorg/jetbrains/plugins/terminal/session/impl/TerminalOutputEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "initShellIntegration", "intellij.terminal.frontend"})
public final class TerminalShellIntegrationEventsHandler
implements TerminalOutputEventsHandler {
    @NotNull
    private final TerminalOutputModelController outputModelController;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final CompletableDeferred<TerminalShellIntegration> shellIntegrationDeferred;
    @NotNull
    private final TerminalAliasesStorage aliasesStorage;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final CoroutineContext edtContext;

    public TerminalShellIntegrationEventsHandler(@NotNull TerminalOutputModelController outputModelController, @NotNull TerminalSessionModel sessionModel, @NotNull CompletableDeferred<TerminalShellIntegration> shellIntegrationDeferred, @NotNull TerminalAliasesStorage aliasesStorage, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)outputModelController, (String)"outputModelController");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter(shellIntegrationDeferred, (String)"shellIntegrationDeferred");
        Intrinsics.checkNotNullParameter((Object)aliasesStorage, (String)"aliasesStorage");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.outputModelController = outputModelController;
        this.sessionModel = sessionModel;
        this.shellIntegrationDeferred = shellIntegrationDeferred;
        this.aliasesStorage = aliasesStorage;
        this.coroutineScope = coroutineScope;
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        this.edtContext = coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState));
    }

    private final TerminalShellIntegrationImpl getShellIntegration() {
        Object t = TerminalCoroutineKt.getNow((Deferred)this.shellIntegrationDeferred);
        return t instanceof TerminalShellIntegrationImpl ? (TerminalShellIntegrationImpl)t : null;
    }

    private final TerminalShellIntegrationImpl getIntegrationOrThrow() {
        TerminalShellIntegrationImpl terminalShellIntegrationImpl = this.getShellIntegration();
        if (terminalShellIntegrationImpl == null) {
            throw new IllegalStateException("Shell integration is not initialized yet".toString());
        }
        return terminalShellIntegrationImpl;
    }

    @Override
    @Nullable
    public Object handleEvent(@NotNull TerminalOutputEvent event, @NotNull Continuation<? super Unit> $completion) {
        TerminalOutputEvent terminalOutputEvent = event;
        if (terminalOutputEvent instanceof TerminalInitialStateEvent) {
            return BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                int label;
                final /* synthetic */ TerminalShellIntegrationEventsHandler this$0;
                final /* synthetic */ TerminalOutputEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Unit unit;
                            Object object;
                            ResultKt.throwOnFailure((Object)$result);
                            if (TerminalShellIntegrationEventsHandler.access$getShellIntegration(this.this$0) == null && ((TerminalInitialStateEvent)this.$event).getSessionState().isShellIntegrationEnabled()) {
                                TerminalShellIntegrationEventsHandler.access$initShellIntegration(this.this$0);
                            }
                            if ((object = TerminalShellIntegrationEventsHandler.access$getShellIntegration(this.this$0)) != null && (object = ((TerminalShellIntegrationImpl)object).getBlocksModel()) != null) {
                                ((TerminalBlocksModelImpl)object).restoreFromState(TerminalBlocksModelStateDtoKt.toState(((TerminalInitialStateEvent)this.$event).getBlocksModelState()));
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                            return unit;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }
        if (terminalOutputEvent instanceof TerminalStateChangedEvent) {
            if (this.getShellIntegration() == null && ((TerminalStateChangedEvent)event).getState().isShellIntegrationEnabled()) {
                this.initShellIntegration();
            }
        } else {
            if (Intrinsics.areEqual((Object)terminalOutputEvent, (Object)TerminalPromptStartedEvent.INSTANCE)) {
                Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ TerminalShellIntegrationEventsHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).applyPendingUpdates();
                                TerminalShellIntegrationEventsHandler.access$getIntegrationOrThrow(this.this$0).onPromptStarted(TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).getModel().getCursorOffset());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (Intrinsics.areEqual((Object)terminalOutputEvent, (Object)TerminalPromptFinishedEvent.INSTANCE)) {
                Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ TerminalShellIntegrationEventsHandler this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).applyPendingUpdates();
                                TerminalShellIntegrationEventsHandler.access$getIntegrationOrThrow(this.this$0).onPromptFinished(TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).getModel().getCursorOffset());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (terminalOutputEvent instanceof TerminalCommandStartedEvent) {
                Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                    int label;
                    final /* synthetic */ TerminalShellIntegrationEventsHandler this$0;
                    final /* synthetic */ TerminalOutputEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).applyPendingUpdates();
                                TerminalShellIntegrationEventsHandler.access$getIntegrationOrThrow(this.this$0).onCommandStarted(TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).getModel().getCursorOffset(), ((TerminalCommandStartedEvent)this.$event).getCommand());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (terminalOutputEvent instanceof TerminalCommandFinishedEvent) {
                Object object = BuildersKt.withContext((CoroutineContext)this.edtContext, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                    int label;
                    final /* synthetic */ TerminalShellIntegrationEventsHandler this$0;
                    final /* synthetic */ TerminalOutputEvent $event;
                    {
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                TerminalShellIntegrationEventsHandler.access$getOutputModelController$p(this.this$0).applyPendingUpdates();
                                TerminalShellIntegrationEventsHandler.access$getIntegrationOrThrow(this.this$0).onCommandFinished(((TerminalCommandFinishedEvent)this.$event).getExitCode());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (terminalOutputEvent instanceof TerminalAliasesReceivedEvent) {
                this.aliasesStorage.setAliasesInfo(((TerminalAliasesReceivedEvent)event).getAliases());
            }
        }
        return Unit.INSTANCE;
    }

    private final void initShellIntegration() {
        TerminalShellIntegrationImpl integration = new TerminalShellIntegrationImpl(this.outputModelController.getModel(), this.sessionModel, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)"TerminalShellIntegration", null, (boolean)false, (int)6, null));
        this.shellIntegrationDeferred.complete((Object)integration);
    }

    public static final /* synthetic */ TerminalShellIntegrationImpl access$getShellIntegration(TerminalShellIntegrationEventsHandler $this) {
        return $this.getShellIntegration();
    }

    public static final /* synthetic */ void access$initShellIntegration(TerminalShellIntegrationEventsHandler $this) {
        $this.initShellIntegration();
    }

    public static final /* synthetic */ TerminalOutputModelController access$getOutputModelController$p(TerminalShellIntegrationEventsHandler $this) {
        return $this.outputModelController;
    }

    public static final /* synthetic */ TerminalShellIntegrationImpl access$getIntegrationOrThrow(TerminalShellIntegrationEventsHandler $this) {
        return $this.getIntegrationOrThrow();
    }
}

