/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpersKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.text.StringKt;
import com.intellij.util.xmlb.annotations.Property;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.EnvironmentVariablesDataOptions;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalStartupKt;
import org.jetbrains.plugins.terminal.ValueWithDefault;
import org.jetbrains.plugins.terminal.settings.TerminalLocalOptions;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="TerminalProjectNonSharedOptionsProvider", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000289B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010(\u001a\u00020)2\b\u0010'\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010*\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010+J\u001e\u0010,\u001a\u00020\u00132\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130-H\u0082@\u00a2\u0006\u0002\u0010.J\u0014\u0010/\u001a\u0004\u0018\u00010\u00132\b\u00100\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010,\u001a\u00020\u00132\u0006\u00101\u001a\u00020)H\u0082@\u00a2\u0006\u0002\u00102J\u001e\u00103\u001a\u00020&2\u0006\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u000206H\u0082@\u00a2\u0006\u0002\u00107R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u00138F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R$\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R(\u0010\"\u001a\u0004\u0018\u00010\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u00138@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010\u0016\"\u0004\b$\u0010\u0018\u00a8\u0006:"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "getState", "loadState", "", "newState", "getEnvData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "envData", "<set-?>", "", "startingDirectory", "getStartingDirectory", "()Ljava/lang/String;", "setStartingDirectory", "(Ljava/lang/String;)V", "startingDirectory$delegate", "Lorg/jetbrains/plugins/terminal/ValueWithDefault;", "defaultStartingDirectory", "getDefaultStartingDirectory", "getDefaultWorkingDirectory", "value", "shellPath", "getShellPath", "setShellPath", "shellPathWithoutDefault", "getShellPathWithoutDefault$intellij_terminal", "setShellPathWithoutDefault$intellij_terminal", "isProjectLevelShellPath", "", "workingDirectory", "toEelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "defaultShellPath", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findDefaultShellPath", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findWslDistributionName", "directory", "eelDescriptor", "(Lcom/intellij/platform/eel/EelDescriptor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isFile", "absoluteFilePath", "eelApi", "Lcom/intellij/platform/eel/EelApi;", "(Ljava/lang/String;Lcom/intellij/platform/eel/EelApi;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "State", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalProjectOptionsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalProjectOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1#2:219\n295#3,2:220\n*S KotlinDebug\n*F\n+ 1 TerminalProjectOptionsProvider.kt\norg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider\n*L\n177#1:220,2\n*E\n"})
public final class TerminalProjectOptionsProvider
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final State state;
    @NotNull
    private final ValueWithDefault startingDirectory$delegate;
    @NotNull
    private static final Logger LOG;

    public TerminalProjectOptionsProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = new State();
        this.startingDirectory$delegate = new ValueWithDefault((KMutableProperty0)new MutablePropertyReference0Impl(this.state){

            public Object get() {
                return ((State)this.receiver).getStartingDirectory();
            }

            public void set(Object value) {
                ((State)this.receiver).setStartingDirectory((String)value);
            }
        }, () -> TerminalProjectOptionsProvider.startingDirectory_delegate$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.state.setStartingDirectory(newState.getStartingDirectory());
        this.state.setShellPath(newState.getShellPath());
        this.state.setEnvDataOptions(newState.getEnvDataOptions());
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.state.getEnvDataOptions().get();
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData envData) {
        Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
        this.state.getEnvDataOptions().set(envData);
    }

    @Nullable
    public final String getStartingDirectory() {
        return this.startingDirectory$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setStartingDirectory(@Nullable String string) {
        this.startingDirectory$delegate.setValue(this, $$delegatedProperties[0], string);
    }

    @Nullable
    public final String getDefaultStartingDirectory() {
        String directory = null;
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                directory = customizer.getDefaultFolder(this.project);
                if (directory == null) continue;
                break;
            }
            catch (Exception e) {
                LOG.error("Exception during getting default folder", (Throwable)e);
            }
        }
        if (directory == null) {
            directory = this.getDefaultWorkingDirectory();
        }
        String string = directory;
        return string != null ? FileUtil.toSystemDependentName((String)string) : null;
    }

    private final String getDefaultWorkingDirectory() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        return virtualFile != null ? virtualFile.getCanonicalPath() : null;
    }

    @NotNull
    public final String getShellPath() {
        return (String)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalProjectOptionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.this$0.getShellPathWithoutDefault$intellij_terminal();
                        if (v0 != null) ** GOTO lbl16
                        this.label = 1;
                        v1 = this.this$0.defaultShellPath((Continuation<? super String>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        v0 = (String)v1;
lbl16:
                        // 2 sources

                        return v0;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public final void setShellPath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ TerminalProjectOptionsProvider this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_3 = this.$value;
                        var2_4 = this.this$0;
                        this.L$0 = var2_4;
                        this.L$1 = var3_3;
                        this.label = 1;
                        v0 = this.this$0.defaultShellPath((Continuation<? super String>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        var3_3 = (String)this.L$1;
                        var2_4 = (TerminalProjectOptionsProvider)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        var4_5 = v0;
                        var2_4.setShellPathWithoutDefault$intellij_terminal(Strings.nullize((String)var3_3, (String)((String)var4_5)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public final String getShellPathWithoutDefault$intellij_terminal() {
        String workingDirectory = this.getStartingDirectory();
        String shellPath2 = this.isProjectLevelShellPath(workingDirectory) && TrustedProjects.isProjectTrusted((Project)this.project) ? this.state.getShellPath() : TerminalLocalOptions.Companion.getInstance().getShellPath();
        return StringKt.nullize((String)shellPath2, (boolean)true);
    }

    public final void setShellPathWithoutDefault$intellij_terminal(@Nullable String value) {
        String valueToStore = StringKt.nullize((String)value, (boolean)true);
        String workingDirectory = this.getStartingDirectory();
        if (this.isProjectLevelShellPath(workingDirectory)) {
            this.state.setShellPath(valueToStore);
        } else {
            TerminalLocalOptions.Companion.getInstance().setShellPath(valueToStore);
        }
    }

    private final boolean isProjectLevelShellPath(String workingDirectory) {
        EelDescriptor eelDescriptor = this.toEelDescriptor(workingDirectory);
        return eelDescriptor != LocalEelDescriptor.INSTANCE;
    }

    private final EelDescriptor toEelDescriptor(String workingDirectory) {
        Path path;
        Path path2;
        Path path3;
        String string = workingDirectory;
        if (string != null) {
            String it = string;
            boolean bl = false;
            path3 = NioFiles.toPath((String)it);
        } else {
            path3 = null;
        }
        if ((path2 = (path = path3)) == null || (path2 = EelProviderUtil.getEelDescriptor((Path)path2)) == null) {
            path2 = (EelDescriptor)LocalEelDescriptor.INSTANCE;
        }
        return path2;
    }

    @Nullable
    public final Object defaultShellPath(@NotNull Continuation<? super String> $completion) {
        return this.findDefaultShellPath((Function0<String>)((Function0)() -> TerminalProjectOptionsProvider.defaultShellPath$lambda$0(this)), $completion);
    }

    private final Object findDefaultShellPath(Function0<String> workingDirectory, Continuation<? super String> $completion) {
        Path shell;
        String wslDistributionName;
        if (TerminalStartupKt.shouldUseEelApi()) {
            return this.findDefaultShellPath(this.toEelDescriptor((String)workingDirectory.invoke()), $completion);
        }
        if (SystemInfo.isWindows && (wslDistributionName = this.findWslDistributionName((String)workingDirectory.invoke())) != null) {
            return "wsl.exe --distribution " + wslDistributionName;
        }
        String string = System.getenv("SHELL");
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = NioFiles.toPath((String)it);
        } else {
            v1 = shell = null;
        }
        if (shell != null && Files.exists(shell, new LinkOption[0])) {
            return ((Object)shell).toString();
        }
        if (SystemInfo.isUnix) {
            Path bashPath = NioFiles.toPath((String)"/bin/bash");
            if (bashPath != null && Files.exists(bashPath, new LinkOption[0])) {
                return ((Object)bashPath).toString();
            }
            return "/bin/sh";
        }
        return "powershell.exe";
    }

    private final String findWslDistributionName(String directory) {
        String string;
        String string2 = directory;
        if (string2 == null) {
            string = null;
        } else {
            WslPath wslPath = WslPath.Companion.parseWindowsUncPath(string2);
            string = wslPath != null ? wslPath.getDistributionId() : null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final Object findDefaultShellPath(EelDescriptor eelDescriptor, Continuation<? super String> $completion) {
        block14: {
            if (!($completion instanceof findDefaultShellPath.2)) ** GOTO lbl-1000
            var17_3 = $completion;
            if ((var17_3.label & -2147483648) != 0) {
                var17_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    int I$0;
                    int I$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ TerminalProjectOptionsProvider this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TerminalProjectOptionsProvider.access$findDefaultShellPath(this.this$0, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    if (EelPlatformKt.isWindows((EelOsFamily)eelDescriptor.getOsFamily())) {
                        return "powershell.exe";
                    }
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                    $continuation.label = 1;
                    v0 = eelDescriptor.toEelApi((Continuation)$continuation);
                    if (v0 == var18_5) {
                        return var18_5;
                    }
                    ** GOTO lbl24
                }
                case 1: {
                    eelDescriptor = (EelDescriptor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    eelApi = (EelApi)v0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                    $continuation.L$1 = eelApi;
                    $continuation.label = 2;
                    v1 = TerminalStartupKt.fetchMinimalEnvironmentVariables(eelApi, (Continuation<? super Map<String, String>>)$continuation);
                    if (v1 == var18_5) {
                        return var18_5;
                    }
                    ** GOTO lbl37
                }
                case 2: {
                    eelApi = (EelApi)$continuation.L$1;
                    eelDescriptor = (EelDescriptor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl37:
                    // 2 sources

                    envs = (Map)v1;
                    var6_8 = new String[3];
                    var6_8[0] = envs.get("SHELL");
                    var8_10 = var7_9 = "/bin/zsh";
                    var14_12 = 1;
                    var13_13 = var6_8;
                    $i$a$-takeIf-TerminalProjectOptionsProvider$findDefaultShellPath$candidates$1 = false;
                    var15_16 = EelPlatformKt.isMac((EelPlatform)eelApi.getPlatform());
                    var13_13[var14_12] = var15_16 != false ? var7_9 : null;
                    var6_8[2] = "/bin/bash";
                    candidates = CollectionsKt.distinct((Iterable)CollectionsKt.listOfNotNull((Object[])var6_8));
                    $this$firstOrNull$iv = candidates;
                    $i$f$firstOrNull = 0;
                    var9_15 = $this$firstOrNull$iv.iterator();
lbl51:
                    // 2 sources

                    while (var9_15.hasNext()) {
                        element$iv = var9_15.next();
                        it = (String)element$iv;
                        $i$a$-firstOrNull-TerminalProjectOptionsProvider$findDefaultShellPath$3 = 0;
                        $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)eelDescriptor);
                        $continuation.L$1 = eelApi;
                        $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)envs);
                        $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)candidates);
                        $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$firstOrNull$iv);
                        $continuation.L$5 = var9_15;
                        $continuation.L$6 = element$iv;
                        $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)it);
                        $continuation.I$0 = $i$f$firstOrNull;
                        $continuation.I$1 = $i$a$-firstOrNull-TerminalProjectOptionsProvider$findDefaultShellPath$3;
                        $continuation.label = 3;
                        v2 = this.isFile(it, eelApi, (Continuation<? super Boolean>)$continuation);
                        if (v2 == var18_5) {
                            return var18_5;
                        }
                        ** GOTO lbl84
                    }
                    break;
                }
                case 3: {
                    $i$a$-firstOrNull-TerminalProjectOptionsProvider$findDefaultShellPath$3 = $continuation.I$1;
                    $i$f$firstOrNull = $continuation.I$0;
                    it = (String)$continuation.L$7;
                    element$iv = $continuation.L$6;
                    var9_15 = (Iterator<T>)$continuation.L$5;
                    $this$firstOrNull$iv = (Iterable)$continuation.L$4;
                    candidates = (List)$continuation.L$3;
                    envs = (Map)$continuation.L$2;
                    eelApi = (EelApi)$continuation.L$1;
                    eelDescriptor = (EelDescriptor)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl84:
                    // 2 sources

                    if (!((Boolean)v2).booleanValue()) ** GOTO lbl51
                    v3 = element$iv;
                    break block14;
                }
            }
            v3 = null;
        }
        if ((v4 = (String)v3) == null) {
            v4 = "/bin/sh";
        }
        return v4;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object isFile(String absoluteFilePath, EelApi eelApi, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof isFile.1)) ** GOTO lbl-1000
        var8_4 = $completion;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ TerminalProjectOptionsProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TerminalProjectOptionsProvider.access$isFile(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    var5_7 = EelPath.Companion.parse(absoluteFilePath, eelApi.getDescriptor());
                }
                catch (EelPathException <unused var>) {
                    return Boxing.boxBoolean((boolean)false);
                }
                path = var5_7;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)absoluteFilePath);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)eelApi);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)path);
                $continuation.label = 1;
                v0 = EelFileSystemApiHelpersKt.stat((EelFileSystemApi)eelApi.getFs(), (EelPath)path).resolveAndFollow().eelIt((Continuation)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl33
            }
            case 1: {
                path = (EelPath)$continuation.L$2;
                eelApi = (EelApi)$continuation.L$1;
                absoluteFilePath = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                if ((result = (EelResult)v0) instanceof EelResult.Ok) {
                    v1 = ((EelFileInfo)((EelResult.Ok)result).getValue()).getType() instanceof EelFileInfo.Type.Regular;
                } else if (result instanceof EelResult.Error) {
                    v1 = false;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return Boxing.boxBoolean((boolean)v1);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String startingDirectory_delegate$lambda$0(TerminalProjectOptionsProvider this$0) {
        return this$0.getDefaultStartingDirectory();
    }

    private static final String defaultShellPath$lambda$0(TerminalProjectOptionsProvider this$0) {
        return this$0.getStartingDirectory();
    }

    @JvmStatic
    @NotNull
    public static final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Object access$findDefaultShellPath(TerminalProjectOptionsProvider $this, Function0 workingDirectory, Continuation $completion) {
        return $this.findDefaultShellPath((Function0<String>)workingDirectory, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$findDefaultShellPath(TerminalProjectOptionsProvider $this, EelDescriptor eelDescriptor, Continuation $completion) {
        return $this.findDefaultShellPath(eelDescriptor, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$isFile(TerminalProjectOptionsProvider $this, String absoluteFilePath, EelApi eelApi, Continuation $completion) {
        return $this.isFile(absoluteFilePath, eelApi, (Continuation<? super Boolean>)$completion);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TerminalProjectOptionsProvider.class, "startingDirectory", "getStartingDirectory()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(TerminalProjectOptionsProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalProjectOptionsProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TerminalProjectOptionsProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TerminalProjectOptionsProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u00020\u000e8\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalProjectOptionsProvider$State;", "", "<init>", "()V", "startingDirectory", "", "getStartingDirectory", "()Ljava/lang/String;", "setStartingDirectory", "(Ljava/lang/String;)V", "shellPath", "getShellPath", "setShellPath", "envDataOptions", "Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;", "getEnvDataOptions", "()Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;", "setEnvDataOptions", "(Lorg/jetbrains/plugins/terminal/EnvironmentVariablesDataOptions;)V", "intellij.terminal"})
    public static final class State {
        @Nullable
        private String startingDirectory;
        @Nullable
        private String shellPath;
        @NotNull
        private EnvironmentVariablesDataOptions envDataOptions = new EnvironmentVariablesDataOptions();

        @Nullable
        public final String getStartingDirectory() {
            return this.startingDirectory;
        }

        public final void setStartingDirectory(@Nullable String string) {
            this.startingDirectory = string;
        }

        @Nullable
        public final String getShellPath() {
            return this.shellPath;
        }

        public final void setShellPath(@Nullable String string) {
            this.shellPath = string;
        }

        @Property(surroundWithTag=false, flat=true)
        @NotNull
        public final EnvironmentVariablesDataOptions getEnvDataOptions() {
            return this.envDataOptions;
        }

        public final void setEnvDataOptions(@NotNull EnvironmentVariablesDataOptions environmentVariablesDataOptions) {
            Intrinsics.checkNotNullParameter((Object)((Object)environmentVariablesDataOptions), (String)"<set-?>");
            this.envDataOptions = environmentVariablesDataOptions;
        }
    }
}

