/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jediterm.core.util.TermSize;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptionsListener;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.prompt.RightPromptManager;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptStyle;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorDescription;
import org.jetbrains.plugins.terminal.block.prompt.error.TerminalPromptErrorStateListener;
import org.jetbrains.plugins.terminal.block.prompt.renderer.BuiltInPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.renderer.PlaceholderPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.renderer.ShellPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.renderer.TerminalPromptRenderer;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u00029:B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010*\u001a\u00020+H\u0017J\u0012\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010.\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u0019H\u0003J\b\u0010/\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020\u0010H\u0002J\b\u00101\u001a\u00020\u0010H\u0002J\u0012\u00102\u001a\u00020+2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0018\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020\u0002H\u0016J\b\u00108\u001a\u00020+H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0019@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "getDocument", "()Lcom/intellij/openapi/editor/ex/DocumentEx;", "renderer", "Lorg/jetbrains/plugins/terminal/block/prompt/renderer/TerminalPromptRenderer;", "placeholderPromptRenderer", "rightPromptManager", "Lorg/jetbrains/plugins/terminal/block/prompt/RightPromptManager;", "value", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "promptState", "getPromptState", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "renderingInfo", "getRenderingInfo", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "commandStartOffset", "", "getCommandStartOffset", "()I", "", "commandText", "getCommandText", "()Ljava/lang/String;", "setCommandText", "(Ljava/lang/String;)V", "errorStateDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorStateListener;", "resetChangesHistory", "", "updatePrompt", "state", "doUpdatePrompt", "getOrCreateRightPromptManager", "createPromptRenderer", "createPlaceholderPromptRenderer", "setErrorDescription", "errorDescription", "Lorg/jetbrains/plugins/terminal/block/prompt/error/TerminalPromptErrorDescription;", "addErrorStateListener", "listener", "parentDisposable", "dispose", "PreventMoveToPromptListener", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalPromptModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptModelImpl.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TerminalModel.kt\norg/jetbrains/plugins/terminal/block/session/TerminalModel\n*L\n1#1,222:1\n1#2:223\n158#3,7:224\n*S KotlinDebug\n*F\n+ 1 TerminalPromptModelImpl.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl\n*L\n159#1:224,7\n*E\n"})
public final class TerminalPromptModelImpl
implements TerminalPromptModel,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private TerminalPromptRenderer renderer;
    @NotNull
    private TerminalPromptRenderer placeholderPromptRenderer;
    @Nullable
    private RightPromptManager rightPromptManager;
    @Nullable
    private TerminalPromptState promptState;
    @NotNull
    private TerminalPromptRenderingInfo renderingInfo;
    @NotNull
    private final EventDispatcher<TerminalPromptErrorStateListener> errorStateDispatcher;

    public TerminalPromptModelImpl(@NotNull EditorEx editor, @NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.editor = editor;
        this.session = session2;
        this.renderer = this.createPromptRenderer();
        this.placeholderPromptRenderer = this.createPlaceholderPromptRenderer();
        this.promptState = TerminalPromptState.Companion.getEMPTY();
        this.renderingInfo = new TerminalPromptRenderingInfo("", CollectionsKt.emptyList(), null, null, 12, null);
        EventDispatcher eventDispatcher2 = EventDispatcher.create(TerminalPromptErrorStateListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.errorStateDispatcher = eventDispatcher2;
        this.getEditor().getCaretModel().addCaretListener((CaretListener)new PreventMoveToPromptListener(), (Disposable)this);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler((Document)this.getDocument(), TerminalPromptModelImpl::_init_$lambda$0);
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void promptStateUpdated(TerminalPromptState newState) {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                this.updatePrompt(newState);
            }

            @Override
            public void commandStarted(String command2) {
                Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                this.updatePrompt(null);
            }
        }, null, 2, null);
        Project project = this.getEditor().getProject();
        Intrinsics.checkNotNull((Object)project);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> TerminalPromptModelImpl._init_$lambda$1(this, arg_0));
        BlockTerminalOptions.Companion.getInstance().addListener(this, new BlockTerminalOptionsListener(){

            @Override
            public void promptStyleChanged(TerminalPromptStyle promptStyle) {
                Intrinsics.checkNotNullParameter((Object)((Object)promptStyle), (String)"promptStyle");
                renderer = this.createPromptRenderer();
                placeholderPromptRenderer = this.createPlaceholderPromptRenderer();
                this.updatePrompt(this.getPromptState());
            }
        });
    }

    @Override
    @NotNull
    public EditorEx getEditor() {
        return this.editor;
    }

    private final DocumentEx getDocument() {
        DocumentEx documentEx = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        return documentEx;
    }

    @Override
    @Nullable
    public TerminalPromptState getPromptState() {
        return this.promptState;
    }

    @Override
    @NotNull
    public TerminalPromptRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    @Override
    public int getCommandStartOffset() {
        return this.getRenderingInfo().getText().length();
    }

    @Override
    @NotNull
    public String getCommandText() {
        String string = this.getDocument().getText(new TextRange(this.getCommandStartOffset(), this.getDocument().getTextLength()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    public void setCommandText(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DocumentUtil.writeInRunUndoTransparentAction(() -> TerminalPromptModelImpl._set_commandText_$lambda$0(this, value));
    }

    @Override
    @RequiresEdt
    public void resetChangesHistory() {
        WriteIntentReadAction.run(() -> TerminalPromptModelImpl.resetChangesHistory$lambda$0(this));
    }

    private final void updatePrompt(TerminalPromptState state) {
        TerminalPromptRenderingInfo updatedInfo = state == null ? this.placeholderPromptRenderer.calculateRenderingInfo(TerminalPromptState.Companion.getEMPTY()) : this.renderer.calculateRenderingInfo(state);
        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)this.getEditor());
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> TerminalPromptModelImpl.updatePrompt$lambda$0(this, updatedInfo, state));
    }

    @RequiresEdt
    private final void doUpdatePrompt(TerminalPromptRenderingInfo renderingInfo) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> TerminalPromptModelImpl.doUpdatePrompt$lambda$0(this, renderingInfo));
        MarkupModelEx markupModelEx = this.getEditor().getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        Companion.replaceHighlighters$intellij_terminal((MarkupModel)markupModelEx, renderingInfo.getHighlightings());
        String rightPrompt = renderingInfo.getRightText();
        if (((CharSequence)rightPrompt).length() > 0) {
            RightPromptManager manager = this.getOrCreateRightPromptManager();
            manager.update(renderingInfo.getText().length(), rightPrompt, renderingInfo.getRightHighlightings());
        } else {
            RightPromptManager rightPromptManager = this.rightPromptManager;
            if (rightPromptManager != null) {
                RightPromptManager it = rightPromptManager;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.rightPromptManager = null;
        }
    }

    private final RightPromptManager getOrCreateRightPromptManager() {
        RightPromptManager rightPromptManager = this.rightPromptManager;
        if (rightPromptManager != null) {
            RightPromptManager it = rightPromptManager;
            boolean bl = false;
            return it;
        }
        RightPromptManager manager = new RightPromptManager((Editor)this.getEditor(), this.session.getSettings());
        Disposer.register((Disposable)this, (Disposable)manager);
        this.rightPromptManager = manager;
        return manager;
    }

    private final TerminalPromptRenderer createPromptRenderer() {
        return switch (WhenMappings.$EnumSwitchMapping$0[BlockTerminalOptions.Companion.getInstance().getPromptStyle().ordinal()]) {
            case 1 -> new BuiltInPromptRenderer(this.session.getColorPalette(), true);
            case 2 -> new BuiltInPromptRenderer(this.session.getColorPalette(), false);
            case 3 -> {
                Function0 sizeProvider = () -> TerminalPromptModelImpl.createPromptRenderer$lambda$0(this);
                yield new ShellPromptRenderer(this.session.getColorPalette(), this.session.getSettings(), (Function0<TermSize>)sizeProvider);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final TerminalPromptRenderer createPlaceholderPromptRenderer() {
        return switch (WhenMappings.$EnumSwitchMapping$0[BlockTerminalOptions.Companion.getInstance().getPromptStyle().ordinal()]) {
            case 1 -> new PlaceholderPromptRenderer(true);
            case 2 -> new PlaceholderPromptRenderer(false);
            case 3 -> new PlaceholderPromptRenderer(true);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public void setErrorDescription(@Nullable TerminalPromptErrorDescription errorDescription) {
        ((TerminalPromptErrorStateListener)this.errorStateDispatcher.getMulticaster()).errorStateChanged(errorDescription);
    }

    @Override
    public void addErrorStateListener(@NotNull TerminalPromptErrorStateListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.errorStateDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    public void dispose() {
    }

    private static final void _set_commandText_$lambda$0(TerminalPromptModelImpl this$0, String $value) {
        this$0.getDocument().replaceString(this$0.getCommandStartOffset(), this$0.getDocument().getTextLength(), (CharSequence)$value);
    }

    private static final void _init_$lambda$0(ReadOnlyFragmentModificationException it) {
    }

    private static final void _init_$lambda$1(TerminalPromptModelImpl this$0, EditorColorsScheme it) {
        this$0.doUpdatePrompt(this$0.getRenderingInfo());
    }

    private static final void resetChangesHistory$lambda$0(TerminalPromptModelImpl this$0) {
        Project project = this$0.getEditor().getProject();
        Intrinsics.checkNotNull((Object)project);
        UndoManager undoManager = UndoManager.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)undoManager, (String)"null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        UndoManagerImpl undoManager2 = (UndoManagerImpl)undoManager;
        undoManager2.invalidateActionsFor(DocumentReferenceManager.getInstance().create((Document)this$0.getDocument()));
    }

    private static final void updatePrompt$lambda$0(TerminalPromptModelImpl this$0, TerminalPromptRenderingInfo $updatedInfo, TerminalPromptState $state) {
        this$0.doUpdatePrompt($updatedInfo);
        this$0.promptState = $state;
        this$0.renderingInfo = $updatedInfo;
    }

    private static final void doUpdatePrompt$lambda$0(TerminalPromptModelImpl this$0, TerminalPromptRenderingInfo $renderingInfo) {
        TerminalPromptModelImpl.Companion.clearGuardedBlocks(this$0.getDocument());
        this$0.getDocument().replaceString(0, this$0.getCommandStartOffset(), (CharSequence)$renderingInfo.getText());
        this$0.getDocument().createGuardedBlock(0, $renderingInfo.getText().length());
        this$0.getEditor().getCaretModel().moveToOffset(this$0.getEditor().getCaretModel().getOffset() - this$0.getCommandStartOffset() + $renderingInfo.getText().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TermSize createPromptRenderer$lambda$0(TerminalPromptModelImpl this$0) {
        TermSize termSize;
        TerminalModel this_$iv = this$0.session.getModel();
        boolean $i$f$withContentLock = false;
        this_$iv.lockContent();
        try {
            boolean bl = false;
            termSize = new TermSize(this$0.session.getModel().getWidth(), this$0.session.getModel().getHeight());
        }
        finally {
            this_$iv.unlockContent();
        }
        return termSize;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0000\u00a2\u0006\u0002\b\nJ\u0019\u0010\u000b\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\rJ\f\u0010\u000e\u001a\u00020\u0005*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl$Companion;", "", "<init>", "()V", "replaceHighlighters", "", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "replaceHighlighters$intellij_terminal", "applyHighlighting", "highlighting", "applyHighlighting$intellij_terminal", "clearGuardedBlocks", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalPromptModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPromptModelImpl.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1869#2,2:223\n1869#2,2:225\n*S KotlinDebug\n*F\n+ 1 TerminalPromptModelImpl.kt\norg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl$Companion\n*L\n208#1:223,2\n219#1:225,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void replaceHighlighters$intellij_terminal(@NotNull MarkupModel $this$replaceHighlighters, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)$this$replaceHighlighters, (String)"<this>");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            $this$replaceHighlighters.removeAllHighlighters();
            Iterable $this$forEach$iv = highlightings;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HighlightingInfo it = (HighlightingInfo)element$iv;
                boolean bl = false;
                Companion.applyHighlighting$intellij_terminal($this$replaceHighlighters, it);
            }
        }

        public final void applyHighlighting$intellij_terminal(@NotNull MarkupModel $this$applyHighlighting, @NotNull HighlightingInfo highlighting) {
            Intrinsics.checkNotNullParameter((Object)$this$applyHighlighting, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)highlighting, (String)"highlighting");
            $this$applyHighlighting.addRangeHighlighter(highlighting.getStartOffset(), highlighting.getEndOffset(), 1000, highlighting.getTextAttributesProvider().getTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }

        private final void clearGuardedBlocks(DocumentEx $this$clearGuardedBlocks) {
            List list = $this$clearGuardedBlocks.getGuardedBlocks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getGuardedBlocks(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeMarker it = (RangeMarker)element$iv;
                boolean bl = false;
                $this$clearGuardedBlocks.removeGuardedBlock(it);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl$PreventMoveToPromptListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModelImpl;)V", "preventRecursion", "", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "intellij.terminal"})
    private final class PreventMoveToPromptListener
    implements CaretListener {
        private boolean preventRecursion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (this.preventRecursion) {
                return;
            }
            int newOffset = TerminalPromptModelImpl.this.getEditor().logicalPositionToOffset(event.getNewPosition());
            if (newOffset < TerminalPromptModelImpl.this.getCommandStartOffset()) {
                this.preventRecursion = true;
                try {
                    TerminalPromptModelImpl.this.getEditor().getCaretModel().moveToOffset(TerminalPromptModelImpl.this.getCommandStartOffset());
                }
                finally {
                    this.preventRecursion = false;
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TerminalPromptStyle.values().length];
            try {
                nArray[TerminalPromptStyle.SINGLE_LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalPromptStyle.DOUBLE_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TerminalPromptStyle.SHELL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

