/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ngram.slp.counting.trie;

import com.intellij.completion.ngram.slp.counting.trie.AbstractTrie;
import com.intellij.completion.ngram.slp.counting.trie.ArrayTrieCounter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapTrieCounter
extends AbstractTrie {
    private HashMap<Integer, Object> map;
    private ArrayList<Integer> pseudoOrdering;
    private static final int MAX_DEPTH_MAP_TRIE = 1;
    private static Map<Integer, Integer> cache = new HashMap<Integer, Integer>();

    public MapTrieCounter() {
        this(1);
    }

    public MapTrieCounter(int initSize) {
        this.map = new HashMap(initSize);
        this.pseudoOrdering = new ArrayList();
    }

    @Override
    public List<Integer> getSuccessors() {
        return new ArrayList<Integer>(this.map.keySet());
    }

    @Override
    public List<Integer> getTopSuccessorsInternal(int limit) {
        int classKey = this.hashCode();
        int countsKey = this.keyCode();
        Integer cached = cache.get(classKey);
        if (cached == null || cached != countsKey) {
            this.pseudoOrdering.sort(this::compareCounts);
        }
        int end = Math.min(this.pseudoOrdering.size(), limit);
        ArrayList<Integer> topSuccessors = new ArrayList<Integer>(this.pseudoOrdering.subList(0, end));
        if (this.getSuccessorCount() > 10) {
            cache.put(classKey, countsKey);
        }
        return topSuccessors;
    }

    private int keyCode() {
        return 31 * (this.getSuccessorCount() + 31 * this.getCount());
    }

    @Override
    AbstractTrie makeNext(int depth) {
        AbstractTrie newNext = depth <= 1 ? new MapTrieCounter(1) : new ArrayTrieCounter();
        return newNext;
    }

    @Override
    public Object getSuccessor(int next) {
        return this.map.get(next);
    }

    @Override
    void putSuccessor(int next, Object o) {
        Object curr = this.map.put(next, o);
        if (curr == null) {
            this.pseudoOrdering.add(next);
        }
    }

    private int compareCounts(Integer i1, Integer i2) {
        int base = -Integer.compare(this.getCount(this.map.get((int)i1)), this.getCount(this.map.get((int)i2)));
        if (base != 0) {
            return base;
        }
        return Integer.compare(i1, i2);
    }

    @Override
    void removeSuccessor(int next) {
        Object removed = this.map.remove(next);
        this.pseudoOrdering.remove(this.pseudoOrdering.indexOf(next));
        if (removed instanceof MapTrieCounter) {
            cache.remove(removed.hashCode());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.counts = new int[2 + COUNT_OF_COUNTS_CUTOFF];
        this.counts[0] = in.readInt();
        this.counts[1] = in.readInt();
        int successors = in.readInt();
        this.map = new HashMap(successors, 0.9f);
        for (int pos = 0; pos < successors; ++pos) {
            Object value;
            int key = in.readInt();
            int code = in.readInt();
            if (code < 0) {
                value = code < -1 ? (Object)new ArrayTrieCounter() : (Object)new MapTrieCounter();
                ((AbstractTrie)value).readExternal(in);
                int n = 1 + Math.min(((AbstractTrie)value).getCount(), COUNT_OF_COUNTS_CUTOFF);
                this.counts[n] = this.counts[n] + 1;
            } else {
                value = new int[code];
                for (int j = 0; j < code; ++j) {
                    value[j] = in.readInt();
                }
                int n = 1 + Math.min(value[0], COUNT_OF_COUNTS_CUTOFF);
                this.counts[n] = this.counts[n] + 1;
            }
            this.putSuccessor(key, value);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.counts[0]);
        out.writeInt(this.counts[1]);
        out.writeInt(this.map.size());
        for (Map.Entry<Integer, Object> entry : this.map.entrySet()) {
            int key = entry.getKey();
            Object value = entry.getValue();
            out.writeInt(key);
            if (value instanceof int[]) {
                int[] arr = (int[])value;
                out.writeInt(arr.length);
                for (int i : arr) {
                    out.writeInt(i);
                }
                continue;
            }
            if (value instanceof ArrayTrieCounter) {
                out.writeInt(-2);
            } else {
                out.writeInt(-1);
            }
            ((AbstractTrie)value).writeExternal(out);
        }
    }
}

