/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.foundation.shape.CornerSizeKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.unit.DpSize;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.theme.IntUiBridgeKt;
import org.jetbrains.jewel.ui.component.styling.DropdownColors;
import org.jetbrains.jewel.ui.component.styling.DropdownIcons;
import org.jetbrains.jewel.ui.component.styling.DropdownMetrics;
import org.jetbrains.jewel.ui.component.styling.DropdownStyle;
import org.jetbrains.jewel.ui.component.styling.MenuStyle;
import org.jetbrains.jewel.ui.icon.IconKey;
import org.jetbrains.jewel.ui.icon.IntelliJIconKey;
import org.jetbrains.jewel.ui.icons.AllIconsKeys;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0005"}, d2={"readDefaultDropdownStyle", "Lorg/jetbrains/jewel/ui/component/styling/DropdownStyle;", "menuStyle", "Lorg/jetbrains/jewel/ui/component/styling/MenuStyle;", "readUndecoratedDropdownStyle", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridgeDropdown.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridgeDropdown.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeDropdownKt\n+ 2 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,119:1\n49#2:120\n49#2:122\n122#3:121\n122#3:123\n122#3:124\n*S KotlinDebug\n*F\n+ 1 IntUiBridgeDropdown.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeDropdownKt\n*L\n58#1:120\n109#1:122\n63#1:121\n111#1:123\n113#1:124\n*E\n"})
public final class IntUiBridgeDropdownKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DropdownStyle readDefaultDropdownStyle(@NotNull MenuStyle menuStyle) {
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)menuStyle, (String)"menuStyle");
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.background");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.foreground");
        long normalBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.borderColor");
        long focusedBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.focusedBorderColor");
        DropdownColors colors = new DropdownColors(normalBackground, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledBackground"), normalBackground, normalBackground, normalBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledForeground"), normalContent, normalContent, normalContent, normalBorder, BridgeUtilsKt.retrieveColorOrUnspecified("Component.disabledBorderColor"), focusedBorder, focusedBorder, normalBorder, Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), null);
        Dimension dimension = JBUI.CurrentTheme.ComboBox.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toNonNegativeDpSize(dimension);
        JBValue jBValue = JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"ARROW_AREA_WIDTH");
        float arrowWidth = BridgeUtilsKt.safeValue-YgX7TsA$default(BridgeUtilsKt.getDp(jBValue), 0.0f, 1, null);
        float f = DpSize.getWidth-D9Ej5fM((long)minimumSize);
        float other$iv = arrowWidth;
        boolean bl = false;
        int $this$dp$iv = 6;
        boolean $i$f$getDp = false;
        float f2 = Dp.constructor-impl((float)$this$dp$iv);
        $this$dp$iv = 3;
        $i$f$getDp = false;
        DropdownMetrics dropdownMetrics = new DropdownMetrics(DpKt.DpSize-YgX7TsA((float)arrowWidth, (float)DpSize.getHeight-D9Ej5fM((long)minimumSize)), DpKt.DpSize-YgX7TsA((float)Dp.constructor-impl((float)(arg0$iv + other$iv)), (float)DpSize.getHeight-D9Ej5fM((long)minimumSize)), IntUiBridgeKt.getComponentArc(), BridgeUtilsKt.retrieveInsetsAsPaddingValues("ComboBox.padding", PaddingKt.PaddingValues-YgX7TsA((float)f2, (float)Dp.constructor-impl((float)$this$dp$iv))), IntUiBridgeKt.getBorderWidth(), null);
        IntelliJIconKey intelliJIconKey = AllIconsKeys.General.ChevronDown;
        Intrinsics.checkNotNullExpressionValue((Object)intelliJIconKey, (String)"ChevronDown");
        return new DropdownStyle(colors, dropdownMetrics, new DropdownIcons((IconKey)intelliJIconKey), menuStyle);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DropdownStyle readUndecoratedDropdownStyle(@NotNull MenuStyle menuStyle) {
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)menuStyle, (String)"menuStyle");
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.background");
        long hoverBackground = BridgeUtilsKt.retrieveColorOrUnspecified("MainToolbar.Dropdown.transparentHoverBackground");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.foreground");
        DropdownColors colors = new DropdownColors(normalBackground, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledBackground"), normalBackground, normalBackground, hoverBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledForeground"), normalContent, normalContent, normalContent, Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), null);
        JBValue jBValue = JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"ARROW_AREA_WIDTH");
        float arrowWidth = BridgeUtilsKt.safeValue-YgX7TsA$default(BridgeUtilsKt.getDp(jBValue), 0.0f, 1, null);
        Dimension dimension = JBUI.CurrentTheme.Button.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toNonNegativeDpSize(dimension);
        long l = DpKt.DpSize-YgX7TsA((float)arrowWidth, (float)DpSize.getHeight-D9Ej5fM((long)minimumSize));
        float f = DpSize.getWidth-D9Ej5fM((long)minimumSize);
        float other$iv = arrowWidth;
        boolean bl = false;
        long l2 = DpKt.DpSize-YgX7TsA((float)Dp.constructor-impl((float)(arg0$iv + other$iv)), (float)DpSize.getHeight-D9Ej5fM((long)minimumSize));
        JBValue jBValue2 = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc();
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"hoverArc(...)");
        int $this$dp$iv = 3;
        boolean $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-0680j_4((float)Dp.constructor-impl((float)$this$dp$iv));
        $this$dp$iv = 0;
        $i$f$getDp = false;
        DropdownMetrics dropdownMetrics = new DropdownMetrics(l, l2, CornerSizeKt.CornerSize-0680j_4((float)BridgeUtilsKt.safeValue-YgX7TsA$default(BridgeUtilsKt.getDp(jBValue2), 0.0f, 1, null)), paddingValues, Dp.constructor-impl((float)$this$dp$iv), null);
        IntelliJIconKey intelliJIconKey = AllIconsKeys.General.ChevronDown;
        Intrinsics.checkNotNullExpressionValue((Object)intelliJIconKey, (String)"ChevronDown");
        return new DropdownStyle(colors, dropdownMetrics, new DropdownIcons((IconKey)intelliJIconKey), menuStyle);
    }
}

