/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.CLibrary;
import com.pty4j.unix.PTYInputStream;
import com.pty4j.unix.PTYOutputStream;
import com.pty4j.unix.Pollfd;
import com.pty4j.unix.PtyHelpers;
import com.pty4j.unix.UnixPtyException;
import com.pty4j.unix.fd_set;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pty {
    private final String mySlaveName;
    private final PTYInputStream myIn;
    private final PTYOutputStream myOut;
    private final Object myFDLock = new Object();
    private final Object mySelectLock = new Object();
    private final int[] myPipe = new int[2];
    private volatile int myMaster;
    private volatile int mySlaveFD;
    private static final boolean useSelect = Pty.isOSXLessThanOrEqualTo106();
    private static final Object PTSNAME_LOCK = new Object();

    private static boolean isOSXLessThanOrEqualTo106() {
        String version;
        String[] strings;
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("mac") && (strings = (version = System.getProperty("os.version").toLowerCase(Locale.US)).split("\\.")).length > 1 && strings[0].equals("10") && Integer.valueOf(strings[1]) <= 6;
    }

    public Pty() throws IOException {
        this(false, false);
    }

    @Deprecated(forRemoval=true)
    public Pty(boolean console) throws IOException {
        this(console, false);
    }

    Pty(boolean console, boolean openOpenTtyToPreserveOutputAfterTermination) throws IOException {
        Pair<Integer, String> masterSlave = this.openMaster();
        this.myMaster = (Integer)masterSlave.getFirst();
        this.mySlaveName = (String)masterSlave.getSecond();
        if (this.mySlaveName == null) {
            throw new IOException("Util.exception.cannotCreatePty");
        }
        this.mySlaveFD = openOpenTtyToPreserveOutputAfterTermination ? CLibrary.open(this.mySlaveName, 1) : -1;
        this.myIn = new PTYInputStream(this);
        this.myOut = new PTYOutputStream(this);
        CLibrary.pipe(this.myPipe);
    }

    public String getSlaveName() {
        return this.mySlaveName;
    }

    public int getMasterFD() {
        return this.myMaster;
    }

    @NotNull
    public OutputStream getOutputStream() {
        return this.myOut;
    }

    @NotNull
    public InputStream getInputStream() {
        return this.myIn;
    }

    public void setWindowSize(@NotNull WinSize winSize, @Nullable PtyProcess process) throws UnixPtyException {
        PtyHelpers.getPtyExecutor().setWindowSize(this.myMaster, winSize, process);
    }

    @NotNull
    public WinSize getWinSize(@Nullable PtyProcess process) throws UnixPtyException {
        return PtyHelpers.getPtyExecutor().getWindowSize(this.myMaster, process);
    }

    public static Pair<Integer, String> ptyMasterOpen() {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        String name = "/dev/ptmx";
        int fdm = m_jpty.getpt();
        if (fdm < 0) {
            return new Pair((Object)-1, (Object)name);
        }
        if (m_jpty.grantpt(fdm) < 0) {
            m_jpty.close(fdm);
            return new Pair((Object)-2, (Object)name);
        }
        if (m_jpty.unlockpt(fdm) < 0) {
            m_jpty.close(fdm);
            return new Pair((Object)-3, (Object)name);
        }
        String ptr = Pty.ptsname(m_jpty, fdm);
        if (ptr == null) {
            m_jpty.close(fdm);
            return new Pair((Object)-4, (Object)name);
        }
        return new Pair((Object)fdm, (Object)ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ptsname(PtyHelpers.OSFacade m_jpty, int fdm) {
        Object object = PTSNAME_LOCK;
        synchronized (object) {
            return m_jpty.ptsname(fdm);
        }
    }

    private Pair<Integer, String> openMaster() {
        return Pty.ptyMasterOpen();
    }

    static int raise(long pid, int sig) {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        int status = m_jpty.killpg((int)pid, sig);
        if (status == -1) {
            status = m_jpty.kill((int)pid, sig);
        }
        return status;
    }

    public boolean isClosed() {
        return this.myMaster == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        int status;
        int fd;
        Object object;
        if (this.myMaster != -1) {
            object = this.myFDLock;
            synchronized (object) {
                if (this.myMaster != -1) {
                    fd = this.myMaster;
                    this.myMaster = -1;
                    status = this.close0(fd);
                    if (status == -1) {
                        throw new IOException("Close error");
                    }
                }
            }
        }
        if (this.mySlaveFD != -1) {
            object = this.myFDLock;
            synchronized (object) {
                if (this.mySlaveFD != -1) {
                    fd = this.mySlaveFD;
                    this.mySlaveFD = -1;
                    status = CLibrary.close(fd);
                    if (status == -1) {
                        throw new IOException("Close error");
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int close0(int fd) throws IOException {
        int ret = CLibrary.close(fd);
        this.breakRead();
        Object object = this.mySelectLock;
        synchronized (object) {
            CLibrary.close(this.myPipe[0]);
            CLibrary.close(this.myPipe[1]);
            this.myPipe[0] = -1;
            this.myPipe[1] = -1;
        }
        return ret;
    }

    void breakRead() {
        CLibrary.write(this.myPipe[1], new byte[1], 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] buf, int len) throws IOException {
        boolean haveBytes;
        int fd = this.myMaster;
        if (fd == -1) {
            return -1;
        }
        Object object = this.mySelectLock;
        synchronized (object) {
            if (this.myPipe[0] == -1) {
                return -1;
            }
            haveBytes = useSelect ? Pty.select(this.myPipe[0], fd) : Pty.poll(this.myPipe[0], fd);
        }
        return haveBytes ? CLibrary.read(fd, buf, len) : -1;
    }

    private static boolean poll(int pipeFd, int fd) {
        Pollfd[] poll_fds = new Pollfd[]{new Pollfd(pipeFd, 1), new Pollfd(fd, 1)};
        while (CLibrary.poll(poll_fds, -1) <= 0) {
            int errno = CLibrary.errno();
            if (errno == CLibrary.EAGAIN || errno == 4) continue;
            return false;
        }
        return (poll_fds[1].getRevents() & 1) != 0;
    }

    private static boolean select(int pipeFd, int fd) {
        fd_set set = new fd_set();
        set.FD_SET(pipeFd);
        set.FD_SET(fd);
        CLibrary.select(Math.max(fd, pipeFd) + 1, set);
        return set.FD_ISSET(fd);
    }

    int write(byte[] buf, int len) {
        return CLibrary.write(this.myMaster, buf, len);
    }
}

