/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.common.highlighter;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.TextRangeUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\rH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/extensions/common/highlighter/HighlightedRange;", "", "range", "Lcom/intellij/openapi/util/TextRange;", "color", "Ljava/awt/Color;", "<init>", "(Lcom/intellij/openapi/util/TextRange;Ljava/awt/Color;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getColor", "()Ljava/awt/Color;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toString", "", "intellij.markdown"})
public final class HighlightedRange
implements Comparable<HighlightedRange> {
    @NotNull
    private final TextRange range;
    @NotNull
    private final Color color;

    public HighlightedRange(@NotNull TextRange range, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.range = range;
        this.color = color;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @Override
    public int compareTo(@NotNull HighlightedRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return TextRangeUtil.RANGE_COMPARATOR.compare(this.range, other.range);
    }

    @NotNull
    public final TextRange component1() {
        return this.range;
    }

    @NotNull
    public final Color component2() {
        return this.color;
    }

    @NotNull
    public final HighlightedRange copy(@NotNull TextRange range, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new HighlightedRange(range, color);
    }

    public static /* synthetic */ HighlightedRange copy$default(HighlightedRange highlightedRange, TextRange textRange, Color color, int n, Object object) {
        if ((n & 1) != 0) {
            textRange = highlightedRange.range;
        }
        if ((n & 2) != 0) {
            color = highlightedRange.color;
        }
        return highlightedRange.copy(textRange, color);
    }

    @NotNull
    public String toString() {
        return "HighlightedRange(range=" + this.range + ", color=" + this.color + ")";
    }

    public int hashCode() {
        int result = this.range.hashCode();
        result = result * 31 + this.color.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HighlightedRange)) {
            return false;
        }
        HighlightedRange highlightedRange = (HighlightedRange)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)highlightedRange.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.color, (Object)highlightedRange.color);
    }
}

