# Interface methods for submodule: SPSAOptimizer
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate
from ._proxies import SingleValuedNonLinearOptimizerProxy as _SingleValuedNonLinearOptimizerProxy


# Interface methods for class: SPSAOptimizer
class SPSAOptimizerProxy(_SingleValuedNonLinearOptimizerProxy):
	@staticmethod
	def New():
		""""""
		...

	def Clone(self):
		""""""
		...

	def GetNameOfClass(self):
		""""""
		...

	def AdvanceOneStep(self) -> None:
		""""""
		...

	def StartOptimization(self) -> None:
		""""""
		...

	def ResumeOptimization(self) -> None:
		""""""
		...

	def StopOptimization(self) -> None:
		""""""
		...

	@overload
	def GetValue(self) -> float:
		""""""
		...

	@overload
	def GetValue(self, parameters) -> float:
		""""""
		...

	def GuessParameters(self, numberOfGradientEstimates: int, initialStepSize: float) -> None:
		""""""
		...

	def GetCurrentIteration(self) -> int:
		""""""
		...

	def GetStopCondition(self):
		""""""
		...

	def GetLearningRate(self) -> float:
		""""""
		...

	def GetGradientMagnitude(self) -> float:
		""""""
		...

	def GetGradient(self) -> Sequence[float]:
		""""""
		...

	def SetSa(self, _arg: float) -> None:
		""""""
		...

	def GetSa(self) -> float:
		""""""
		...

	def Seta(self, a: float) -> None:
		""""""
		...

	def Geta(self) -> float:
		""""""
		...

	def SetSc(self, _arg: float) -> None:
		""""""
		...

	def GetSc(self) -> float:
		""""""
		...

	def Setc(self, c: float) -> None:
		""""""
		...

	def Getc(self) -> float:
		""""""
		...

	def SetA(self, _arg: float) -> None:
		""""""
		...

	def GetA(self) -> float:
		""""""
		...

	def SetAlpha(self, _arg: float) -> None:
		""""""
		...

	def GetAlpha(self) -> float:
		""""""
		...

	def SetGamma(self, _arg: float) -> None:
		""""""
		...

	def GetGamma(self) -> float:
		""""""
		...

	def GetMaximize(self) -> bool:
		""""""
		...

	def SetMaximize(self, _arg: bool) -> None:
		""""""
		...

	def MaximizeOn(self) -> None:
		""""""
		...

	def MaximizeOff(self) -> None:
		""""""
		...

	def GetMinimize(self) -> bool:
		""""""
		...

	def SetMinimize(self, v: bool) -> None:
		""""""
		...

	def MinimizeOn(self) -> None:
		""""""
		...

	def MinimizeOff(self) -> None:
		""""""
		...

	def SetNumberOfPerturbations(self, _arg: int) -> None:
		""""""
		...

	def GetNumberOfPerturbations(self) -> int:
		""""""
		...

	def GetStateOfConvergence(self) -> float:
		""""""
		...

	def SetStateOfConvergenceDecayRate(self, _arg: float) -> None:
		""""""
		...

	def GetStateOfConvergenceDecayRate(self) -> float:
		""""""
		...

	def SetMinimumNumberOfIterations(self, _arg: int) -> None:
		""""""
		...

	def GetMinimumNumberOfIterations(self) -> int:
		""""""
		...

	def SetMaximumNumberOfIterations(self, _arg: int) -> None:
		""""""
		...

	def GetMaximumNumberOfIterations(self) -> int:
		""""""
		...

	def SetTolerance(self, _arg: float) -> None:
		""""""
		...

	def GetTolerance(self) -> float:
		""""""
		...

	def GetStopConditionDescription(self) -> str:
		""""""
		...

