/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl.provider;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialContextSet;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.opensaml.xmlsec.agreement.KeyAgreementSupport;
import org.opensaml.xmlsec.agreement.impl.KeyAgreementParametersParser;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedType;
import org.opensaml.xmlsec.encryption.EncryptionMethod;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolutionMode;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCriterion;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.slf4j.Logger;

public class AgreementMethodKeyInfoProvider
extends AbstractKeyInfoProvider {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AgreementMethodKeyInfoProvider.class);
    @Nonnull
    private final KeyAgreementParametersParser parametersParser = new KeyAgreementParametersParser();

    @Override
    public boolean handles(@Nonnull XMLObject keyInfoChild) {
        if (!AgreementMethod.class.isInstance(keyInfoChild)) {
            this.log.debug("XMLObject is not an AgreementMethod");
            return false;
        }
        AgreementMethod agreementMethod = (AgreementMethod)AgreementMethod.class.cast(keyInfoChild);
        KeyAgreementProcessorRegistry registry = KeyAgreementSupport.getGlobalProcessorRegistry();
        if (registry == null) {
            this.log.debug("Global KeyAgreementProcessorRegistry is not configured");
            return false;
        }
        if (!registry.getRegisteredAlgorithms().contains(agreementMethod.getAlgorithm())) {
            this.log.debug("No KeyAgreementProcessor registered for algorithm: {}", (Object)agreementMethod.getAlgorithm());
            return false;
        }
        XMLObject parent = agreementMethod.getParent();
        if (parent == null || parent.getParent() == null || !EncryptedType.class.isInstance(parent.getParent())) {
            this.log.debug("AgreementMethod is not the grandchild of an EncryptedType element");
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public Collection<Credential> process(@Nonnull KeyInfoCredentialResolver resolver, @Nonnull XMLObject keyInfoChild, @Nullable CriteriaSet criteriaSet, @Nonnull KeyInfoResolutionContext kiContext) throws SecurityException {
        CredentialContextSet ctxset;
        KeyAgreementProcessor processor;
        if (!this.handles(keyInfoChild)) {
            return null;
        }
        AgreementMethod agreementMethod = (AgreementMethod)AgreementMethod.class.cast(keyInfoChild);
        String agreementAlg = agreementMethod.getAlgorithm();
        KeyAgreementProcessor keyAgreementProcessor = processor = agreementAlg != null ? KeyAgreementSupport.ensureGlobalProcessorRegistry().getProcessor(agreementAlg) : null;
        if (processor == null) {
            throw new SecurityException("No KeyAgreementProcessor returned from registry");
        }
        this.log.debug("Attempting to process key agreemenent for algorithm: {}", (Object)processor.getAlgorithm());
        KeyAgreementCredential cred = null;
        try {
            Credential originatorCredential = this.resolveOriginatorCredential(agreementMethod, resolver);
            Credential recipientCredential = this.resolveRecipientCredential(agreementMethod, resolver);
            KeyAgreementParameters parameters = this.parametersParser.parse(agreementMethod);
            parameters.add(new PrivateCredential(recipientCredential));
            String keyAlgorithm = this.resolveKeyAlgorithm(agreementMethod);
            cred = processor.execute(originatorCredential, keyAlgorithm, parameters);
        }
        catch (KeyAgreementException e) {
            this.log.error("Error processing AgreementMethod with algorithm: {}", (Object)processor.getAlgorithm(), (Object)e);
            throw new SecurityException("Error processing AgreementMethod", e);
        }
        cred.getKeyNames().addAll(kiContext.getKeyNames());
        KeyInfoCredentialContext credContext = this.buildCredentialContext(kiContext);
        if (credContext != null && (ctxset = cred.getCredentialContextSet()) != null) {
            ctxset.add(credContext);
        }
        this.log.debug("Credential successfully produced by AgreementMethod with algorithm: {}", (Object)cred.getAlgorithm());
        LazySet<Credential> credentialSet = new LazySet<Credential>();
        credentialSet.add(cred);
        return credentialSet;
    }

    @Nonnull
    private String resolveKeyAlgorithm(@Nonnull AgreementMethod agreementMethod) throws SecurityException {
        XMLObject parent = agreementMethod.getParent();
        assert (parent != null);
        EncryptedType encrytpedType = (EncryptedType)EncryptedType.class.cast(parent.getParent());
        EncryptionMethod method = encrytpedType.getEncryptionMethod();
        if (method == null) {
            throw new SecurityException("EncryptionMethod is missing");
        }
        String alg = method.getAlgorithm();
        if (alg == null) {
            throw new SecurityException("EncryptedType contains no EncryptionMethod algorithm");
        }
        return alg;
    }

    @Nonnull
    private Credential resolveOriginatorCredential(@Nonnull AgreementMethod agreementMethod, @Nonnull KeyInfoCredentialResolver resolver) throws SecurityException {
        if (agreementMethod.getOriginatorKeyInfo() == null) {
            throw new SecurityException("AgreementMethod OriginatorKeyInfo was null");
        }
        CriteriaSet criteria = new CriteriaSet(new KeyInfoCriterion(agreementMethod.getOriginatorKeyInfo()), new KeyInfoCredentialResolutionMode(KeyInfoCredentialResolutionMode.Mode.PUBLIC));
        try {
            Credential cred = (Credential)resolver.resolveSingle(criteria);
            if (cred == null) {
                throw new SecurityException("Failed to resolve Credential from OriginatorKeyInfo ");
            }
            return cred;
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving Credential from OriginatorKeyInfo", e);
        }
    }

    @Nonnull
    private Credential resolveRecipientCredential(@Nonnull AgreementMethod agreementMethod, @Nonnull KeyInfoCredentialResolver resolver) throws SecurityException {
        if (agreementMethod.getRecipientKeyInfo() == null) {
            throw new SecurityException("AgreementMethod RecipientKeyInfo was null");
        }
        CriteriaSet criteria = new CriteriaSet(new KeyInfoCriterion(agreementMethod.getRecipientKeyInfo()));
        try {
            Credential cred = (Credential)resolver.resolveSingle(criteria);
            if (cred == null) {
                throw new SecurityException("Failed to resolve Credential from RecipientKeyInfo ");
            }
            if (cred.getPrivateKey() == null) {
                throw new SecurityException("Credential resolved from RecipientKeyInfo did not contain PrivateKey");
            }
            return cred;
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving Credential from RecipientKeyInfo", e);
        }
    }
}

