.TH XScreenSaver 1 "24-May-97" "X Version 11"
.SH NAME
flag \- draws a waving flag, containing text or an image
.SH SYNOPSIS
.B flag
[\-\-display \fIhost:display.screen\fP] [\-\-foreground \fIcolor\fP]
[\-\-background \fIcolor\fP] [\-\-window] [\-\-root]
[\-\-window\-id \fInumber\fP][\-\-mono] [\-\-install] [\-\-visual \fIvisual\fP] [\-\-ncolors \fIinteger\fP] [\-\-delay \fImicroseconds\fP] [\-\-cycles \fIinteger\fP] [\-\-size \fIinteger\fP] [\-\-text \fIstring\fP] [\-\-font \fIfont\fP] [\-\-bitmap \fIxbm-file\fP]

[\-\-fps]
.SH DESCRIPTION
The \fIflag\fP program draws a waving flag that contains text or a bitmap.
.SH OPTIONS
.I flag
accepts the following options:
.TP 8
.B \-\-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-\-root
Draw on the root window.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-mono 
If on a color display, pretend we're on a monochrome display.
.TP 8
.B \-\-install
Install a private colormap for the window.
.TP 8
.B \-\-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-\-ncolors \fIinteger\fP
How many colors should be used (if possible).  Default 200.
.TP 8
.B \-\-cycles \fIinteger\fP

.TP 8
.B \-\-count \fIinteger\fP

.TP 8
.B \-\-size \fIinteger\fP
How large the pixels in the flag should be, from 1 to 8.
If this is a negative number, the pixel size is chosen randomly
from the range 1 to -size.  Default -7.
.TP 8
.B \-\-text \fItext\fP
The text to display in the flag.  Multiple lines of text are allowed;
the lines will be displayed centered atop one another.  Default: none.
If the text is the magic string \fI"(default)"\fP, then the text used 
will be the local machine name; a newline; and the local OS version.
.TP 8
.B \-\-bitmap \fIxbm-file\fP
The bitmap to display in the flag; this must be an XBM file (color XPMs
are not allowed.)  Default: none.  If the bitmap is the magic 
string \fI"(default)"\fP, then the bitmap used will be a charming 
little picture of J. R. "Bob" Dobbs.

If neither \fI\-\-text\fP nor \fI\-\-bitmap\fP are specified, then either
the builtin text or the builtin bitmap will be chosen randomly.
.TP 8
.B \-\-font \fIfont\fP
The font in which to draw the text; the default is
"-*-helvetica-bold-r-*-240-*".
.TP 8
.B \-\-fps
Display the current frame rate and CPU load.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.BR xlock (1)
.SH COPYRIGHT
Copyright \(co 1996 Charles Vidal.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation. 

.SH AUTHOR
Charles Vidal <vidalc@univ-mlv.fr>, 1996.

Ability to run standalone or with \fIxscreensaver\fP, and the \-\-text
and \-\-bitmap options, added by Jamie Zawinski <jwz@jwz.org>, 24-May-97.
