// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The content block to be evaluated by the guardrail.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub enum GuardrailContentBlock {
    /// <p>Image within guardrail content block to be evaluated by the guardrail.</p>
    Image(crate::types::GuardrailImageBlock),
    /// <p>Text within content block to be evaluated by the guardrail.</p>
    Text(crate::types::GuardrailTextBlock),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl GuardrailContentBlock {
    /// Tries to convert the enum instance into [`Image`](crate::types::GuardrailContentBlock::Image), extracting the inner [`GuardrailImageBlock`](crate::types::GuardrailImageBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_image(&self) -> ::std::result::Result<&crate::types::GuardrailImageBlock, &Self> {
        if let GuardrailContentBlock::Image(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Image`](crate::types::GuardrailContentBlock::Image).
    pub fn is_image(&self) -> bool {
        self.as_image().is_ok()
    }
    /// Tries to convert the enum instance into [`Text`](crate::types::GuardrailContentBlock::Text), extracting the inner [`GuardrailTextBlock`](crate::types::GuardrailTextBlock).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_text(&self) -> ::std::result::Result<&crate::types::GuardrailTextBlock, &Self> {
        if let GuardrailContentBlock::Text(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Text`](crate::types::GuardrailContentBlock::Text).
    pub fn is_text(&self) -> bool {
        self.as_text().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
impl ::std::fmt::Debug for GuardrailContentBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            GuardrailContentBlock::Image(_) => f.debug_tuple("*** Sensitive Data Redacted ***").finish(),
            GuardrailContentBlock::Text(val) => f.debug_tuple("Text").field(&val).finish(),
            GuardrailContentBlock::Unknown => f.debug_tuple("Unknown").finish(),
        }
    }
}
