//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpcproxycreating?language=objc)
    pub unsafe trait NSXPCProxyCreating {
        #[unsafe(method(remoteObjectProxy))]
        #[unsafe(method_family = none)]
        unsafe fn remoteObjectProxy(&self) -> Retained<AnyObject>;

        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[unsafe(method(remoteObjectProxyWithErrorHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn remoteObjectProxyWithErrorHandler(
            &self,
            handler: &block2::DynBlock<dyn Fn(NonNull<NSError>)>,
        ) -> Retained<AnyObject>;

        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[optional]
        #[unsafe(method(synchronousRemoteObjectProxyWithErrorHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn synchronousRemoteObjectProxyWithErrorHandler(
            &self,
            handler: &block2::DynBlock<dyn Fn(NonNull<NSError>)>,
        ) -> Retained<AnyObject>;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpcconnectionoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSXPCConnectionOptions(pub NSUInteger);
bitflags::bitflags! {
    impl NSXPCConnectionOptions: NSUInteger {
        #[doc(alias = "NSXPCConnectionPrivileged")]
        const Privileged = 1<<12;
    }
}

unsafe impl Encode for NSXPCConnectionOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSXPCConnectionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpcconnection?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSXPCConnection;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSXPCConnection {}
);

extern_conformance!(
    unsafe impl NSXPCProxyCreating for NSXPCConnection {}
);

impl NSXPCConnection {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithServiceName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithServiceName(
            this: Allocated<Self>,
            service_name: &NSString,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(serviceName))]
        #[unsafe(method_family = none)]
        pub unsafe fn serviceName(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithMachServiceName:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMachServiceName_options(
            this: Allocated<Self>,
            name: &NSString,
            options: NSXPCConnectionOptions,
        ) -> Retained<Self>;

        #[unsafe(method(initWithListenerEndpoint:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithListenerEndpoint(
            this: Allocated<Self>,
            endpoint: &NSXPCListenerEndpoint,
        ) -> Retained<Self>;

        #[unsafe(method(endpoint))]
        #[unsafe(method_family = none)]
        pub unsafe fn endpoint(&self) -> Retained<NSXPCListenerEndpoint>;

        #[unsafe(method(exportedInterface))]
        #[unsafe(method_family = none)]
        pub unsafe fn exportedInterface(&self) -> Option<Retained<NSXPCInterface>>;

        /// Setter for [`exportedInterface`][Self::exportedInterface].
        #[unsafe(method(setExportedInterface:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExportedInterface(&self, exported_interface: Option<&NSXPCInterface>);

        #[unsafe(method(exportedObject))]
        #[unsafe(method_family = none)]
        pub unsafe fn exportedObject(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`exportedObject`][Self::exportedObject].
        #[unsafe(method(setExportedObject:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExportedObject(&self, exported_object: Option<&AnyObject>);

        #[unsafe(method(remoteObjectInterface))]
        #[unsafe(method_family = none)]
        pub unsafe fn remoteObjectInterface(&self) -> Option<Retained<NSXPCInterface>>;

        /// Setter for [`remoteObjectInterface`][Self::remoteObjectInterface].
        #[unsafe(method(setRemoteObjectInterface:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRemoteObjectInterface(
            &self,
            remote_object_interface: Option<&NSXPCInterface>,
        );

        #[unsafe(method(remoteObjectProxy))]
        #[unsafe(method_family = none)]
        pub unsafe fn remoteObjectProxy(&self) -> Retained<AnyObject>;

        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[unsafe(method(remoteObjectProxyWithErrorHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn remoteObjectProxyWithErrorHandler(
            &self,
            handler: &block2::DynBlock<dyn Fn(NonNull<NSError>)>,
        ) -> Retained<AnyObject>;

        #[cfg(all(feature = "NSError", feature = "block2"))]
        #[unsafe(method(synchronousRemoteObjectProxyWithErrorHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn synchronousRemoteObjectProxyWithErrorHandler(
            &self,
            handler: &block2::DynBlock<dyn Fn(NonNull<NSError>)>,
        ) -> Retained<AnyObject>;

        #[cfg(feature = "block2")]
        #[unsafe(method(interruptionHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn interruptionHandler(&self) -> *mut block2::DynBlock<dyn Fn()>;

        #[cfg(feature = "block2")]
        /// Setter for [`interruptionHandler`][Self::interruptionHandler].
        #[unsafe(method(setInterruptionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInterruptionHandler(
            &self,
            interruption_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(invalidationHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidationHandler(&self) -> *mut block2::DynBlock<dyn Fn()>;

        #[cfg(feature = "block2")]
        /// Setter for [`invalidationHandler`][Self::invalidationHandler].
        #[unsafe(method(setInvalidationHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInvalidationHandler(
            &self,
            invalidation_handler: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[unsafe(method(resume))]
        #[unsafe(method_family = none)]
        pub unsafe fn resume(&self);

        #[unsafe(method(suspend))]
        #[unsafe(method_family = none)]
        pub unsafe fn suspend(&self);

        #[unsafe(method(activate))]
        #[unsafe(method_family = none)]
        pub unsafe fn activate(&self);

        #[unsafe(method(invalidate))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidate(&self);

        #[cfg(feature = "libc")]
        #[unsafe(method(processIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn processIdentifier(&self) -> libc::pid_t;

        #[cfg(feature = "libc")]
        #[unsafe(method(effectiveUserIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectiveUserIdentifier(&self) -> libc::uid_t;

        #[cfg(feature = "libc")]
        #[unsafe(method(effectiveGroupIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn effectiveGroupIdentifier(&self) -> libc::gid_t;

        #[unsafe(method(currentConnection))]
        #[unsafe(method_family = none)]
        pub unsafe fn currentConnection() -> Option<Retained<NSXPCConnection>>;

        #[cfg(feature = "block2")]
        #[unsafe(method(scheduleSendBarrierBlock:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scheduleSendBarrierBlock(&self, block: &block2::DynBlock<dyn Fn()>);

        #[cfg(feature = "NSString")]
        /// Sets the code signing requirement for this connection. If the requirement is malformed, an exception is thrown. If new messages do not match the requirement, the connection is invalidated. It is recommended to set this before calling `resume`, as it is an XPC error to call it more than once.
        /// See https://developer.apple.com/library/archive/documentation/Security/Conceptual/CodeSigningGuide/RequirementLang/RequirementLang.html for more information on the format.
        #[unsafe(method(setCodeSigningRequirement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCodeSigningRequirement(&self, requirement: &NSString);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSXPCConnection {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpclistener?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSXPCListener;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSXPCListener {}
);

impl NSXPCListener {
    extern_methods!(
        #[unsafe(method(serviceListener))]
        #[unsafe(method_family = none)]
        pub unsafe fn serviceListener() -> Retained<NSXPCListener>;

        #[unsafe(method(anonymousListener))]
        #[unsafe(method_family = none)]
        pub unsafe fn anonymousListener() -> Retained<NSXPCListener>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithMachServiceName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithMachServiceName(
            this: Allocated<Self>,
            name: &NSString,
        ) -> Retained<Self>;

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn NSXPCListenerDelegate>>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`delegate`][Self::delegate].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn NSXPCListenerDelegate>>,
        );

        #[unsafe(method(endpoint))]
        #[unsafe(method_family = none)]
        pub unsafe fn endpoint(&self) -> Retained<NSXPCListenerEndpoint>;

        #[unsafe(method(resume))]
        #[unsafe(method_family = none)]
        pub unsafe fn resume(&self);

        #[unsafe(method(suspend))]
        #[unsafe(method_family = none)]
        pub unsafe fn suspend(&self);

        #[unsafe(method(activate))]
        #[unsafe(method_family = none)]
        pub unsafe fn activate(&self);

        #[unsafe(method(invalidate))]
        #[unsafe(method_family = none)]
        pub unsafe fn invalidate(&self);

        #[cfg(feature = "NSString")]
        /// Sets the code signing requirement for new connections. If the requirement is malformed, an exception is thrown. If new peer connections do not match the requirement, the incoming connection is automatically rejected before consulting the delegate.
        /// This method will only work on `anonymousListener` or `initWithMachServiceName` listener instances. Use on other types of listeners will result in an assertion failure.
        /// See https://developer.apple.com/library/archive/documentation/Security/Conceptual/CodeSigningGuide/RequirementLang/RequirementLang.html for more information on the format.
        #[unsafe(method(setConnectionCodeSigningRequirement:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setConnectionCodeSigningRequirement(&self, requirement: &NSString);
    );
}

/// Methods declared on superclass `NSObject`.
impl NSXPCListener {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpclistenerdelegate?language=objc)
    pub unsafe trait NSXPCListenerDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(listener:shouldAcceptNewConnection:))]
        #[unsafe(method_family = none)]
        unsafe fn listener_shouldAcceptNewConnection(
            &self,
            listener: &NSXPCListener,
            new_connection: &NSXPCConnection,
        ) -> bool;
    }
);

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpcinterface?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSXPCInterface;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSXPCInterface {}
);

impl NSXPCInterface {
    extern_methods!(
        #[unsafe(method(interfaceWithProtocol:))]
        #[unsafe(method_family = none)]
        pub unsafe fn interfaceWithProtocol(protocol: &AnyProtocol) -> Retained<NSXPCInterface>;

        #[unsafe(method(protocol))]
        #[unsafe(method_family = none)]
        pub unsafe fn protocol(&self) -> Retained<AnyProtocol>;

        /// Setter for [`protocol`][Self::protocol].
        #[unsafe(method(setProtocol:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProtocol(&self, protocol: &AnyProtocol);

        #[cfg(feature = "NSSet")]
        #[unsafe(method(setClasses:forSelector:argumentIndex:ofReply:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setClasses_forSelector_argumentIndex_ofReply(
            &self,
            classes: &NSSet<AnyClass>,
            sel: Sel,
            arg: NSUInteger,
            of_reply: bool,
        );

        #[cfg(feature = "NSSet")]
        #[unsafe(method(classesForSelector:argumentIndex:ofReply:))]
        #[unsafe(method_family = none)]
        pub unsafe fn classesForSelector_argumentIndex_ofReply(
            &self,
            sel: Sel,
            arg: NSUInteger,
            of_reply: bool,
        ) -> Retained<NSSet<AnyClass>>;

        #[unsafe(method(setInterface:forSelector:argumentIndex:ofReply:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInterface_forSelector_argumentIndex_ofReply(
            &self,
            ifc: &NSXPCInterface,
            sel: Sel,
            arg: NSUInteger,
            of_reply: bool,
        );

        #[unsafe(method(interfaceForSelector:argumentIndex:ofReply:))]
        #[unsafe(method_family = none)]
        pub unsafe fn interfaceForSelector_argumentIndex_ofReply(
            &self,
            sel: Sel,
            arg: NSUInteger,
            of_reply: bool,
        ) -> Option<Retained<NSXPCInterface>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSXPCInterface {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpclistenerendpoint?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSXPCListenerEndpoint;
);

unsafe impl Send for NSXPCListenerEndpoint {}

unsafe impl Sync for NSXPCListenerEndpoint {}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSXPCListenerEndpoint {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSXPCListenerEndpoint {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSXPCListenerEndpoint {}
);

impl NSXPCListenerEndpoint {
    extern_methods!();
}

/// Methods declared on superclass `NSObject`.
impl NSXPCListenerEndpoint {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxpccoder?language=objc)
    #[unsafe(super(NSCoder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSCoder")]
    pub struct NSXPCCoder;
);

#[cfg(feature = "NSCoder")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSXPCCoder {}
);

#[cfg(feature = "NSCoder")]
impl NSXPCCoder {
    extern_methods!(
        #[unsafe(method(userInfo))]
        #[unsafe(method_family = none)]
        pub unsafe fn userInfo(&self) -> Option<Retained<ProtocolObject<dyn NSObjectProtocol>>>;

        /// Setter for [`userInfo`][Self::userInfo].
        #[unsafe(method(setUserInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setUserInfo(&self, user_info: Option<&ProtocolObject<dyn NSObjectProtocol>>);

        #[unsafe(method(connection))]
        #[unsafe(method_family = none)]
        pub unsafe fn connection(&self) -> Option<Retained<NSXPCConnection>>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSCoder")]
impl NSXPCCoder {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
