// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package kinesisvideoiface provides an interface to enable mocking the Amazon Kinesis Video Streams service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package kinesisvideoiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/kinesisvideo"
)

// KinesisVideoAPI provides an interface to enable mocking the
// kinesisvideo.KinesisVideo service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Kinesis Video Streams.
//	func myFunc(svc kinesisvideoiface.KinesisVideoAPI) bool {
//	    // Make svc.CreateSignalingChannel request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := kinesisvideo.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockKinesisVideoClient struct {
//	    kinesisvideoiface.KinesisVideoAPI
//	}
//	func (m *mockKinesisVideoClient) CreateSignalingChannel(input *kinesisvideo.CreateSignalingChannelInput) (*kinesisvideo.CreateSignalingChannelOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockKinesisVideoClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type KinesisVideoAPI interface {
	CreateSignalingChannel(*kinesisvideo.CreateSignalingChannelInput) (*kinesisvideo.CreateSignalingChannelOutput, error)
	CreateSignalingChannelWithContext(aws.Context, *kinesisvideo.CreateSignalingChannelInput, ...request.Option) (*kinesisvideo.CreateSignalingChannelOutput, error)
	CreateSignalingChannelRequest(*kinesisvideo.CreateSignalingChannelInput) (*request.Request, *kinesisvideo.CreateSignalingChannelOutput)

	CreateStream(*kinesisvideo.CreateStreamInput) (*kinesisvideo.CreateStreamOutput, error)
	CreateStreamWithContext(aws.Context, *kinesisvideo.CreateStreamInput, ...request.Option) (*kinesisvideo.CreateStreamOutput, error)
	CreateStreamRequest(*kinesisvideo.CreateStreamInput) (*request.Request, *kinesisvideo.CreateStreamOutput)

	DeleteEdgeConfiguration(*kinesisvideo.DeleteEdgeConfigurationInput) (*kinesisvideo.DeleteEdgeConfigurationOutput, error)
	DeleteEdgeConfigurationWithContext(aws.Context, *kinesisvideo.DeleteEdgeConfigurationInput, ...request.Option) (*kinesisvideo.DeleteEdgeConfigurationOutput, error)
	DeleteEdgeConfigurationRequest(*kinesisvideo.DeleteEdgeConfigurationInput) (*request.Request, *kinesisvideo.DeleteEdgeConfigurationOutput)

	DeleteSignalingChannel(*kinesisvideo.DeleteSignalingChannelInput) (*kinesisvideo.DeleteSignalingChannelOutput, error)
	DeleteSignalingChannelWithContext(aws.Context, *kinesisvideo.DeleteSignalingChannelInput, ...request.Option) (*kinesisvideo.DeleteSignalingChannelOutput, error)
	DeleteSignalingChannelRequest(*kinesisvideo.DeleteSignalingChannelInput) (*request.Request, *kinesisvideo.DeleteSignalingChannelOutput)

	DeleteStream(*kinesisvideo.DeleteStreamInput) (*kinesisvideo.DeleteStreamOutput, error)
	DeleteStreamWithContext(aws.Context, *kinesisvideo.DeleteStreamInput, ...request.Option) (*kinesisvideo.DeleteStreamOutput, error)
	DeleteStreamRequest(*kinesisvideo.DeleteStreamInput) (*request.Request, *kinesisvideo.DeleteStreamOutput)

	DescribeEdgeConfiguration(*kinesisvideo.DescribeEdgeConfigurationInput) (*kinesisvideo.DescribeEdgeConfigurationOutput, error)
	DescribeEdgeConfigurationWithContext(aws.Context, *kinesisvideo.DescribeEdgeConfigurationInput, ...request.Option) (*kinesisvideo.DescribeEdgeConfigurationOutput, error)
	DescribeEdgeConfigurationRequest(*kinesisvideo.DescribeEdgeConfigurationInput) (*request.Request, *kinesisvideo.DescribeEdgeConfigurationOutput)

	DescribeImageGenerationConfiguration(*kinesisvideo.DescribeImageGenerationConfigurationInput) (*kinesisvideo.DescribeImageGenerationConfigurationOutput, error)
	DescribeImageGenerationConfigurationWithContext(aws.Context, *kinesisvideo.DescribeImageGenerationConfigurationInput, ...request.Option) (*kinesisvideo.DescribeImageGenerationConfigurationOutput, error)
	DescribeImageGenerationConfigurationRequest(*kinesisvideo.DescribeImageGenerationConfigurationInput) (*request.Request, *kinesisvideo.DescribeImageGenerationConfigurationOutput)

	DescribeMappedResourceConfiguration(*kinesisvideo.DescribeMappedResourceConfigurationInput) (*kinesisvideo.DescribeMappedResourceConfigurationOutput, error)
	DescribeMappedResourceConfigurationWithContext(aws.Context, *kinesisvideo.DescribeMappedResourceConfigurationInput, ...request.Option) (*kinesisvideo.DescribeMappedResourceConfigurationOutput, error)
	DescribeMappedResourceConfigurationRequest(*kinesisvideo.DescribeMappedResourceConfigurationInput) (*request.Request, *kinesisvideo.DescribeMappedResourceConfigurationOutput)

	DescribeMappedResourceConfigurationPages(*kinesisvideo.DescribeMappedResourceConfigurationInput, func(*kinesisvideo.DescribeMappedResourceConfigurationOutput, bool) bool) error
	DescribeMappedResourceConfigurationPagesWithContext(aws.Context, *kinesisvideo.DescribeMappedResourceConfigurationInput, func(*kinesisvideo.DescribeMappedResourceConfigurationOutput, bool) bool, ...request.Option) error

	DescribeMediaStorageConfiguration(*kinesisvideo.DescribeMediaStorageConfigurationInput) (*kinesisvideo.DescribeMediaStorageConfigurationOutput, error)
	DescribeMediaStorageConfigurationWithContext(aws.Context, *kinesisvideo.DescribeMediaStorageConfigurationInput, ...request.Option) (*kinesisvideo.DescribeMediaStorageConfigurationOutput, error)
	DescribeMediaStorageConfigurationRequest(*kinesisvideo.DescribeMediaStorageConfigurationInput) (*request.Request, *kinesisvideo.DescribeMediaStorageConfigurationOutput)

	DescribeNotificationConfiguration(*kinesisvideo.DescribeNotificationConfigurationInput) (*kinesisvideo.DescribeNotificationConfigurationOutput, error)
	DescribeNotificationConfigurationWithContext(aws.Context, *kinesisvideo.DescribeNotificationConfigurationInput, ...request.Option) (*kinesisvideo.DescribeNotificationConfigurationOutput, error)
	DescribeNotificationConfigurationRequest(*kinesisvideo.DescribeNotificationConfigurationInput) (*request.Request, *kinesisvideo.DescribeNotificationConfigurationOutput)

	DescribeSignalingChannel(*kinesisvideo.DescribeSignalingChannelInput) (*kinesisvideo.DescribeSignalingChannelOutput, error)
	DescribeSignalingChannelWithContext(aws.Context, *kinesisvideo.DescribeSignalingChannelInput, ...request.Option) (*kinesisvideo.DescribeSignalingChannelOutput, error)
	DescribeSignalingChannelRequest(*kinesisvideo.DescribeSignalingChannelInput) (*request.Request, *kinesisvideo.DescribeSignalingChannelOutput)

	DescribeStream(*kinesisvideo.DescribeStreamInput) (*kinesisvideo.DescribeStreamOutput, error)
	DescribeStreamWithContext(aws.Context, *kinesisvideo.DescribeStreamInput, ...request.Option) (*kinesisvideo.DescribeStreamOutput, error)
	DescribeStreamRequest(*kinesisvideo.DescribeStreamInput) (*request.Request, *kinesisvideo.DescribeStreamOutput)

	GetDataEndpoint(*kinesisvideo.GetDataEndpointInput) (*kinesisvideo.GetDataEndpointOutput, error)
	GetDataEndpointWithContext(aws.Context, *kinesisvideo.GetDataEndpointInput, ...request.Option) (*kinesisvideo.GetDataEndpointOutput, error)
	GetDataEndpointRequest(*kinesisvideo.GetDataEndpointInput) (*request.Request, *kinesisvideo.GetDataEndpointOutput)

	GetSignalingChannelEndpoint(*kinesisvideo.GetSignalingChannelEndpointInput) (*kinesisvideo.GetSignalingChannelEndpointOutput, error)
	GetSignalingChannelEndpointWithContext(aws.Context, *kinesisvideo.GetSignalingChannelEndpointInput, ...request.Option) (*kinesisvideo.GetSignalingChannelEndpointOutput, error)
	GetSignalingChannelEndpointRequest(*kinesisvideo.GetSignalingChannelEndpointInput) (*request.Request, *kinesisvideo.GetSignalingChannelEndpointOutput)

	ListEdgeAgentConfigurations(*kinesisvideo.ListEdgeAgentConfigurationsInput) (*kinesisvideo.ListEdgeAgentConfigurationsOutput, error)
	ListEdgeAgentConfigurationsWithContext(aws.Context, *kinesisvideo.ListEdgeAgentConfigurationsInput, ...request.Option) (*kinesisvideo.ListEdgeAgentConfigurationsOutput, error)
	ListEdgeAgentConfigurationsRequest(*kinesisvideo.ListEdgeAgentConfigurationsInput) (*request.Request, *kinesisvideo.ListEdgeAgentConfigurationsOutput)

	ListEdgeAgentConfigurationsPages(*kinesisvideo.ListEdgeAgentConfigurationsInput, func(*kinesisvideo.ListEdgeAgentConfigurationsOutput, bool) bool) error
	ListEdgeAgentConfigurationsPagesWithContext(aws.Context, *kinesisvideo.ListEdgeAgentConfigurationsInput, func(*kinesisvideo.ListEdgeAgentConfigurationsOutput, bool) bool, ...request.Option) error

	ListSignalingChannels(*kinesisvideo.ListSignalingChannelsInput) (*kinesisvideo.ListSignalingChannelsOutput, error)
	ListSignalingChannelsWithContext(aws.Context, *kinesisvideo.ListSignalingChannelsInput, ...request.Option) (*kinesisvideo.ListSignalingChannelsOutput, error)
	ListSignalingChannelsRequest(*kinesisvideo.ListSignalingChannelsInput) (*request.Request, *kinesisvideo.ListSignalingChannelsOutput)

	ListSignalingChannelsPages(*kinesisvideo.ListSignalingChannelsInput, func(*kinesisvideo.ListSignalingChannelsOutput, bool) bool) error
	ListSignalingChannelsPagesWithContext(aws.Context, *kinesisvideo.ListSignalingChannelsInput, func(*kinesisvideo.ListSignalingChannelsOutput, bool) bool, ...request.Option) error

	ListStreams(*kinesisvideo.ListStreamsInput) (*kinesisvideo.ListStreamsOutput, error)
	ListStreamsWithContext(aws.Context, *kinesisvideo.ListStreamsInput, ...request.Option) (*kinesisvideo.ListStreamsOutput, error)
	ListStreamsRequest(*kinesisvideo.ListStreamsInput) (*request.Request, *kinesisvideo.ListStreamsOutput)

	ListStreamsPages(*kinesisvideo.ListStreamsInput, func(*kinesisvideo.ListStreamsOutput, bool) bool) error
	ListStreamsPagesWithContext(aws.Context, *kinesisvideo.ListStreamsInput, func(*kinesisvideo.ListStreamsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*kinesisvideo.ListTagsForResourceInput) (*kinesisvideo.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *kinesisvideo.ListTagsForResourceInput, ...request.Option) (*kinesisvideo.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*kinesisvideo.ListTagsForResourceInput) (*request.Request, *kinesisvideo.ListTagsForResourceOutput)

	ListTagsForStream(*kinesisvideo.ListTagsForStreamInput) (*kinesisvideo.ListTagsForStreamOutput, error)
	ListTagsForStreamWithContext(aws.Context, *kinesisvideo.ListTagsForStreamInput, ...request.Option) (*kinesisvideo.ListTagsForStreamOutput, error)
	ListTagsForStreamRequest(*kinesisvideo.ListTagsForStreamInput) (*request.Request, *kinesisvideo.ListTagsForStreamOutput)

	StartEdgeConfigurationUpdate(*kinesisvideo.StartEdgeConfigurationUpdateInput) (*kinesisvideo.StartEdgeConfigurationUpdateOutput, error)
	StartEdgeConfigurationUpdateWithContext(aws.Context, *kinesisvideo.StartEdgeConfigurationUpdateInput, ...request.Option) (*kinesisvideo.StartEdgeConfigurationUpdateOutput, error)
	StartEdgeConfigurationUpdateRequest(*kinesisvideo.StartEdgeConfigurationUpdateInput) (*request.Request, *kinesisvideo.StartEdgeConfigurationUpdateOutput)

	TagResource(*kinesisvideo.TagResourceInput) (*kinesisvideo.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *kinesisvideo.TagResourceInput, ...request.Option) (*kinesisvideo.TagResourceOutput, error)
	TagResourceRequest(*kinesisvideo.TagResourceInput) (*request.Request, *kinesisvideo.TagResourceOutput)

	TagStream(*kinesisvideo.TagStreamInput) (*kinesisvideo.TagStreamOutput, error)
	TagStreamWithContext(aws.Context, *kinesisvideo.TagStreamInput, ...request.Option) (*kinesisvideo.TagStreamOutput, error)
	TagStreamRequest(*kinesisvideo.TagStreamInput) (*request.Request, *kinesisvideo.TagStreamOutput)

	UntagResource(*kinesisvideo.UntagResourceInput) (*kinesisvideo.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *kinesisvideo.UntagResourceInput, ...request.Option) (*kinesisvideo.UntagResourceOutput, error)
	UntagResourceRequest(*kinesisvideo.UntagResourceInput) (*request.Request, *kinesisvideo.UntagResourceOutput)

	UntagStream(*kinesisvideo.UntagStreamInput) (*kinesisvideo.UntagStreamOutput, error)
	UntagStreamWithContext(aws.Context, *kinesisvideo.UntagStreamInput, ...request.Option) (*kinesisvideo.UntagStreamOutput, error)
	UntagStreamRequest(*kinesisvideo.UntagStreamInput) (*request.Request, *kinesisvideo.UntagStreamOutput)

	UpdateDataRetention(*kinesisvideo.UpdateDataRetentionInput) (*kinesisvideo.UpdateDataRetentionOutput, error)
	UpdateDataRetentionWithContext(aws.Context, *kinesisvideo.UpdateDataRetentionInput, ...request.Option) (*kinesisvideo.UpdateDataRetentionOutput, error)
	UpdateDataRetentionRequest(*kinesisvideo.UpdateDataRetentionInput) (*request.Request, *kinesisvideo.UpdateDataRetentionOutput)

	UpdateImageGenerationConfiguration(*kinesisvideo.UpdateImageGenerationConfigurationInput) (*kinesisvideo.UpdateImageGenerationConfigurationOutput, error)
	UpdateImageGenerationConfigurationWithContext(aws.Context, *kinesisvideo.UpdateImageGenerationConfigurationInput, ...request.Option) (*kinesisvideo.UpdateImageGenerationConfigurationOutput, error)
	UpdateImageGenerationConfigurationRequest(*kinesisvideo.UpdateImageGenerationConfigurationInput) (*request.Request, *kinesisvideo.UpdateImageGenerationConfigurationOutput)

	UpdateMediaStorageConfiguration(*kinesisvideo.UpdateMediaStorageConfigurationInput) (*kinesisvideo.UpdateMediaStorageConfigurationOutput, error)
	UpdateMediaStorageConfigurationWithContext(aws.Context, *kinesisvideo.UpdateMediaStorageConfigurationInput, ...request.Option) (*kinesisvideo.UpdateMediaStorageConfigurationOutput, error)
	UpdateMediaStorageConfigurationRequest(*kinesisvideo.UpdateMediaStorageConfigurationInput) (*request.Request, *kinesisvideo.UpdateMediaStorageConfigurationOutput)

	UpdateNotificationConfiguration(*kinesisvideo.UpdateNotificationConfigurationInput) (*kinesisvideo.UpdateNotificationConfigurationOutput, error)
	UpdateNotificationConfigurationWithContext(aws.Context, *kinesisvideo.UpdateNotificationConfigurationInput, ...request.Option) (*kinesisvideo.UpdateNotificationConfigurationOutput, error)
	UpdateNotificationConfigurationRequest(*kinesisvideo.UpdateNotificationConfigurationInput) (*request.Request, *kinesisvideo.UpdateNotificationConfigurationOutput)

	UpdateSignalingChannel(*kinesisvideo.UpdateSignalingChannelInput) (*kinesisvideo.UpdateSignalingChannelOutput, error)
	UpdateSignalingChannelWithContext(aws.Context, *kinesisvideo.UpdateSignalingChannelInput, ...request.Option) (*kinesisvideo.UpdateSignalingChannelOutput, error)
	UpdateSignalingChannelRequest(*kinesisvideo.UpdateSignalingChannelInput) (*request.Request, *kinesisvideo.UpdateSignalingChannelOutput)

	UpdateStream(*kinesisvideo.UpdateStreamInput) (*kinesisvideo.UpdateStreamOutput, error)
	UpdateStreamWithContext(aws.Context, *kinesisvideo.UpdateStreamInput, ...request.Option) (*kinesisvideo.UpdateStreamOutput, error)
	UpdateStreamRequest(*kinesisvideo.UpdateStreamInput) (*request.Request, *kinesisvideo.UpdateStreamOutput)
}

var _ KinesisVideoAPI = (*kinesisvideo.KinesisVideo)(nil)
