// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// Response body payload for CreateOAuth2Token operation The response content depends on the grant_type from the request: - grant_type=authorization_code: Returns all fields including refresh_token and id_token - grant_type=refresh_token: Returns access_token, token_type, expires_in, refresh_token (no id_token)
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct CreateOAuth2TokenResponseBody {
    /// Scoped-down AWS credentials (15 minute duration) Present for both authorization code redemption and token refresh
    pub access_token: ::std::option::Option<crate::types::AccessToken>,
    /// Token type indicating this is AWS SigV4 credentials Value is "aws_sigv4" for both flows
    pub token_type: ::std::string::String,
    /// Time to expiry in seconds (maximum 900) Present for both authorization code redemption and token refresh
    pub expires_in: i32,
    /// Encrypted refresh token with cnf.jkt (SHA-256 thumbprint of presented jwk) Always present in responses (required for both flows)
    pub refresh_token: ::std::string::String,
    /// ID token containing user identity information Present only in authorization code redemption response (grant_type=authorization_code) Not included in token refresh responses
    pub id_token: ::std::option::Option<::std::string::String>,
}
impl CreateOAuth2TokenResponseBody {
    /// Scoped-down AWS credentials (15 minute duration) Present for both authorization code redemption and token refresh
    pub fn access_token(&self) -> ::std::option::Option<&crate::types::AccessToken> {
        self.access_token.as_ref()
    }
    /// Token type indicating this is AWS SigV4 credentials Value is "aws_sigv4" for both flows
    pub fn token_type(&self) -> &str {
        use std::ops::Deref;
        self.token_type.deref()
    }
    /// Time to expiry in seconds (maximum 900) Present for both authorization code redemption and token refresh
    pub fn expires_in(&self) -> i32 {
        self.expires_in
    }
    /// Encrypted refresh token with cnf.jkt (SHA-256 thumbprint of presented jwk) Always present in responses (required for both flows)
    pub fn refresh_token(&self) -> &str {
        use std::ops::Deref;
        self.refresh_token.deref()
    }
    /// ID token containing user identity information Present only in authorization code redemption response (grant_type=authorization_code) Not included in token refresh responses
    pub fn id_token(&self) -> ::std::option::Option<&str> {
        self.id_token.as_deref()
    }
}
impl ::std::fmt::Debug for CreateOAuth2TokenResponseBody {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOAuth2TokenResponseBody");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("token_type", &self.token_type);
        formatter.field("expires_in", &self.expires_in);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.field("id_token", &self.id_token);
        formatter.finish()
    }
}
impl CreateOAuth2TokenResponseBody {
    /// Creates a new builder-style object to manufacture [`CreateOAuth2TokenResponseBody`](crate::types::CreateOAuth2TokenResponseBody).
    pub fn builder() -> crate::types::builders::CreateOAuth2TokenResponseBodyBuilder {
        crate::types::builders::CreateOAuth2TokenResponseBodyBuilder::default()
    }
}

/// A builder for [`CreateOAuth2TokenResponseBody`](crate::types::CreateOAuth2TokenResponseBody).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct CreateOAuth2TokenResponseBodyBuilder {
    pub(crate) access_token: ::std::option::Option<crate::types::AccessToken>,
    pub(crate) token_type: ::std::option::Option<::std::string::String>,
    pub(crate) expires_in: ::std::option::Option<i32>,
    pub(crate) refresh_token: ::std::option::Option<::std::string::String>,
    pub(crate) id_token: ::std::option::Option<::std::string::String>,
}
impl CreateOAuth2TokenResponseBodyBuilder {
    /// Scoped-down AWS credentials (15 minute duration) Present for both authorization code redemption and token refresh
    /// This field is required.
    pub fn access_token(mut self, input: crate::types::AccessToken) -> Self {
        self.access_token = ::std::option::Option::Some(input);
        self
    }
    /// Scoped-down AWS credentials (15 minute duration) Present for both authorization code redemption and token refresh
    pub fn set_access_token(mut self, input: ::std::option::Option<crate::types::AccessToken>) -> Self {
        self.access_token = input;
        self
    }
    /// Scoped-down AWS credentials (15 minute duration) Present for both authorization code redemption and token refresh
    pub fn get_access_token(&self) -> &::std::option::Option<crate::types::AccessToken> {
        &self.access_token
    }
    /// Token type indicating this is AWS SigV4 credentials Value is "aws_sigv4" for both flows
    /// This field is required.
    pub fn token_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.token_type = ::std::option::Option::Some(input.into());
        self
    }
    /// Token type indicating this is AWS SigV4 credentials Value is "aws_sigv4" for both flows
    pub fn set_token_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.token_type = input;
        self
    }
    /// Token type indicating this is AWS SigV4 credentials Value is "aws_sigv4" for both flows
    pub fn get_token_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.token_type
    }
    /// Time to expiry in seconds (maximum 900) Present for both authorization code redemption and token refresh
    /// This field is required.
    pub fn expires_in(mut self, input: i32) -> Self {
        self.expires_in = ::std::option::Option::Some(input);
        self
    }
    /// Time to expiry in seconds (maximum 900) Present for both authorization code redemption and token refresh
    pub fn set_expires_in(mut self, input: ::std::option::Option<i32>) -> Self {
        self.expires_in = input;
        self
    }
    /// Time to expiry in seconds (maximum 900) Present for both authorization code redemption and token refresh
    pub fn get_expires_in(&self) -> &::std::option::Option<i32> {
        &self.expires_in
    }
    /// Encrypted refresh token with cnf.jkt (SHA-256 thumbprint of presented jwk) Always present in responses (required for both flows)
    /// This field is required.
    pub fn refresh_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.refresh_token = ::std::option::Option::Some(input.into());
        self
    }
    /// Encrypted refresh token with cnf.jkt (SHA-256 thumbprint of presented jwk) Always present in responses (required for both flows)
    pub fn set_refresh_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.refresh_token = input;
        self
    }
    /// Encrypted refresh token with cnf.jkt (SHA-256 thumbprint of presented jwk) Always present in responses (required for both flows)
    pub fn get_refresh_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.refresh_token
    }
    /// ID token containing user identity information Present only in authorization code redemption response (grant_type=authorization_code) Not included in token refresh responses
    pub fn id_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.id_token = ::std::option::Option::Some(input.into());
        self
    }
    /// ID token containing user identity information Present only in authorization code redemption response (grant_type=authorization_code) Not included in token refresh responses
    pub fn set_id_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.id_token = input;
        self
    }
    /// ID token containing user identity information Present only in authorization code redemption response (grant_type=authorization_code) Not included in token refresh responses
    pub fn get_id_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.id_token
    }
    /// Consumes the builder and constructs a [`CreateOAuth2TokenResponseBody`](crate::types::CreateOAuth2TokenResponseBody).
    /// This method will fail if any of the following fields are not set:
    /// - [`token_type`](crate::types::builders::CreateOAuth2TokenResponseBodyBuilder::token_type)
    /// - [`expires_in`](crate::types::builders::CreateOAuth2TokenResponseBodyBuilder::expires_in)
    /// - [`refresh_token`](crate::types::builders::CreateOAuth2TokenResponseBodyBuilder::refresh_token)
    pub fn build(self) -> ::std::result::Result<crate::types::CreateOAuth2TokenResponseBody, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::CreateOAuth2TokenResponseBody {
            access_token: self.access_token,
            token_type: self.token_type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "token_type",
                    "token_type was not specified but it is required when building CreateOAuth2TokenResponseBody",
                )
            })?,
            expires_in: self.expires_in.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "expires_in",
                    "expires_in was not specified but it is required when building CreateOAuth2TokenResponseBody",
                )
            })?,
            refresh_token: self.refresh_token.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "refresh_token",
                    "refresh_token was not specified but it is required when building CreateOAuth2TokenResponseBody",
                )
            })?,
            id_token: self.id_token,
        })
    }
}
impl ::std::fmt::Debug for CreateOAuth2TokenResponseBodyBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("CreateOAuth2TokenResponseBodyBuilder");
        formatter.field("access_token", &"*** Sensitive Data Redacted ***");
        formatter.field("token_type", &self.token_type);
        formatter.field("expires_in", &self.expires_in);
        formatter.field("refresh_token", &"*** Sensitive Data Redacted ***");
        formatter.field("id_token", &self.id_token);
        formatter.finish()
    }
}
